set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7505195';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '2313240',
      3,
      1,
      NULL,
      NULL,
      '4421',
      1.358419,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951913,
      1,
      0,
      '11- 7-1977',
      54.521771,
      2,
      263,
      74.232404,
      NULL,
      ' 2- 1-1995',
      '10-13-1999',
      ' 9-13-1979',
      3,
      NULL,
      2.798323,
      1.157034,
      NULL,
      NULL,
      0.989243,
      0.487203,
      0.789388,
      21.656719,
      14,
      14.413995,
      3.170529,
      NULL,
      63.293780,
      13,
      NULL,
      NULL,
      5.471176,
      17,
      1,
      NULL,
      0.940333,
      1.677934,
      0,
      1,
      1.804023,
      1.625242,
      1,
      0,
      79.442561,
      2.171480,
      NULL,
      7,
      2,
      3.502229,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.103776,
      NULL,
      3.170277,
      NULL,
      NULL,
      0,
      2.687529,
      0,
      4.759853,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.402054,
      NULL,
      NULL,
      0.320462,
      2,
      2,
      1,
      0.381881,
      0.145309,
      1,
      0.215873,
      1,
      2,
      NULL,
      0,
      1.543841,
      0.741603,
      NULL,
      0,
      1.205298,
      1,
      1.092094,
      NULL,
      NULL,
      2.309839,
      0,
      1.345066,
      NULL,
      NULL,
      0.384904,
      NULL,
      NULL,
      0.003900,
      NULL,
      NULL,
      5.293736,
      7,
      0.089384,
      0,
      4.178639,
      3.998010,
      NULL,
      0,
      5.821030,
      1,
      5.492086,
      0.902118,
      0,
      3,
      0,
      1,
      1.225198,
      0.990458,
      0.665471,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      0.381346,
      NULL,
      1,
      1,
      1,
      NULL,
      1.556276,
      1,
      0.589660,
      6.113983,
      NULL,
      8.847516,
      NULL,
      5,
      5.788920,
      4.558608,
      7,
      5,
      1,
      5.531904,
      NULL,
      1.208720,
      0.277109,
      '10- 6-1979',
      1716,
      ' 4-20-1998',
      626,
      0.292399,
      1.260679,
      1.920868,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.524128,
      1,
      3.514128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.818000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.695369,
      0.328457,
      0,
      5,
      0.595412,
      NULL,
      NULL,
      NULL,
      0.147266,
      1,
      1.808655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.118705,
      NULL,
      0,
      1,
      1,
      1,
      0,
      6222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.032327,
      0.372438,
      0,
      1.859251,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.653411,
      0.170963,
      3.088480,
      1,
      9,
      16,
      150.826774,
      NULL,
      111.850850,
      NULL,
      198.176205,
      47,
      0.149984,
      1,
      1.774322,
      NULL,
      0.493881,
      1.387277,
      1,
      6.542719,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.721987,
      5,
      1.651325,
      1.918135,
      '12234',
      NULL,
      '11320',
      0.268213,
      '',
      '',
      '',
      NULL,
      '3340',
      '',
      '',
      2.729272,
      19,
      254,
      14.594484,
      3,
      27.144513,
      2,
      176.934680,
      9,
      NULL,
      3,
      NULL,
      0.986628,
      NULL,
      NULL,
      0.358422,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.936210,
      NULL,
      NULL,
      2,
      16,
      1.288426,
      1,
      16.147022,
      0.206797,
      0,
      NULL,
      NULL,
      0.448730,
      NULL,
      NULL,
      1.747858,
      NULL,
      NULL,
      0.217697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      4.400974,
      1,
      1.925801,
      NULL,
      NULL,
      NULL,
      1.597293,
      NULL,
      NULL,
      NULL,
      0.325179,
      0.791633,
      0.258848,
      17,
      NULL,
      NULL,
      17.912793,
      NULL,
      NULL,
      2,
      0.167283,
      1,
      1,
      1,
      NULL,
      0.898622,
      NULL,
      NULL,
      1.058689,
      NULL,
      1.614109,
      1,
      1.310141,
      0,
      1,
      0,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10.099584,
      0.290529,
      2.385438,
      0,
      4,
      1.322881,
      0.124769,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.475440,
      3,
      0.786460,
      3,
      3.411393,
      NULL,
      3.372014,
      1,
      NULL,
      NULL,
      2.541421,
      2,
      4,
      NULL,
      NULL,
      2.728987,
      0.665033,
      1.235137,
      1,
      5,
      7.538335,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991921,
      NULL,
      NULL,
      0.319263,
      NULL,
      NULL,
      1.345121,
      NULL,
      NULL,
      1.357852,
      NULL,
      NULL,
      1.060755,
      NULL,
      NULL,
      2.794552,
      2.087403,
      1.838944,
      NULL,
      NULL,
      0.132824,
      NULL,
      0.994691,
      1,
      NULL,
      0,
      3.111851,
      2.478428,
      NULL,
      3.399631,
      NULL,
      0,
      1,
      2,
      NULL,
      2.110381,
      7,
      4.445728,
      4.614174,
      1,
      1.154461,
      2,
      0.854038,
      2.184899,
      0.341714,
      3,
      0,
      2.501339,
      NULL,
      2.008106,
      2,
      1.518871,
      0.133679,
      8,
      0.126631,
      5,
      1,
      3.596229,
      1,
      4.486446,
      1,
      1.542681,
      0.600584,
      1.889724,
      1.233910,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736632,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.086091,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.874934,
      NULL,
      NULL,
      NULL,
      0,
      0.185692,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.351316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522185,
      NULL,
      NULL,
      NULL,
      3.818530,
      NULL,
      NULL,
      NULL,
      1.769361,
      NULL,
      NULL,
      NULL,
      0.313716,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      197.625498,
      3,
      11.005946,
      3,
      NULL,
      NULL,
      NULL,
      1.907152,
      NULL,
      NULL,
      2,
      36,
      1,
      1,
      NULL,
      NULL,
      3,
      1751.900222,
      0.145025,
      NULL,
      45,
      NULL,
      0,
      0.030404,
      1.077709,
      0.202340,
      NULL,
      1,
      2.076307,
      1,
      2,
      0.537802,
      0.955458,
      NULL,
      2.153533,
      1,
      0.692332,
      1.141645,
      0,
      NULL,
      1,
      NULL,
      0.428588,
      NULL,
      0,
      NULL,
      1.373119,
      NULL,
      2.806760,
      NULL,
      0,
      NULL,
      1.502564,
      1,
      4,
      NULL,
      0.831958,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475501,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.846726,
      NULL,
      NULL,
      NULL,
      0.915422,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.843208,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263516,
      0.058240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.274088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899874,
      2,
      NULL,
      0,
      NULL,
      1.615218,
      NULL,
      72,
      NULL,
      1,
      NULL,
      1.489283,
      NULL,
      0,
      1,
      NULL,
      3,
      17.536564,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378548,
      1,
      NULL,
      18,
      NULL,
      NULL,
      15.526375,
      0,
      NULL,
      8,
      13.622101,
      NULL,
      NULL,
      14.005109,
      NULL,
      10.087342,
      13.427080,
      NULL,
      15,
      14.485592,
      NULL,
      13,
      3,
      NULL,
      NULL,
      15,
      NULL,
      10.998028,
      15,
      NULL,
      NULL,
      17.203613,
      NULL,
      2,
      18.075612,
      NULL,
      NULL,
      0.482399,
      0.168505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.967075,
      NULL,
      13,
      NULL,
      14.765995,
      NULL,
      4,
      10.688432,
      NULL,
      NULL,
      0.042864,
      3,
      0.653078,
      34,
      1,
      NULL,
      7.101879,
      '01112',
      '43211',
      NULL,
      0.475837,
      '',
      '',
      '',
      1.974740,
      '2242',
      '',
      NULL);
commit;
end;
/


