set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-3-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '3324120',
      2,
      1.136718,
      NULL,
      0,
      '3244',
      1,
      1,
      NULL,
      NULL,
      ' 0-14-1983',
      NULL,
      NULL,
      1,
      1,
      NULL,
      ' 4-23-1994',
      49,
      2,
      103,
      142.511480,
      1,
      NULL,
      '10- 4-1994',
      ' 3-24-2002',
      1.458275,
      0.581539,
      0,
      3,
      0,
      NULL,
      0.353827,
      1,
      1,
      26,
      NULL,
      19,
      1,
      20,
      12.661397,
      NULL,
      4.440822,
      NULL,
      NULL,
      NULL,
      0,
      4.985451,
      0,
      0,
      0,
      1,
      0,
      0.840411,
      0.392148,
      0.647580,
      1.819914,
      NULL,
      5,
      NULL,
      NULL,
      1.091616,
      0,
      NULL,
      0.558519,
      0.310233,
      0,
      0.902220,
      1.277195,
      0,
      NULL,
      0.735627,
      1,
      1.451173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.926459,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376681,
      NULL,
      1.782280,
      0.837923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.078692,
      0.887203,
      0.746269,
      1.622517,
      0.324998,
      NULL,
      0.641876,
      1,
      1.841475,
      1.551177,
      NULL,
      NULL,
      1.230278,
      1.991348,
      1.221175,
      NULL,
      NULL,
      3,
      0.708673,
      0.836708,
      1.561679,
      0,
      NULL,
      NULL,
      0.614999,
      7,
      1,
      7,
      0.734999,
      7.226016,
      0.422181,
      NULL,
      0,
      1,
      2.267010,
      5,
      6.995844,
      NULL,
      3.431004,
      2,
      0.277015,
      4.482974,
      2,
      1.202172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.254637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.767935,
      NULL,
      1,
      0.968991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      3.862727,
      1.782030,
      0.146513,
      2.340870,
      0.536937,
      0.103756,
      0,
      1.461056,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.664007,
      0,
      0.307936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.463319,
      1,
      1.078698,
      1,
      0.517682,
      NULL,
      1,
      15.425061,
      3,
      1.052390,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.746999,
      NULL,
      0.511319,
      0.113093,
      NULL,
      0.025212,
      0.517624,
      3,
      2.931134,
      NULL,
      1,
      3.399007,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0.863838,
      1,
      0.665200,
      NULL,
      NULL,
      2,
      1.040017,
      NULL,
      7,
      0,
      1,
      NULL,
      2,
      3.212872,
      3.418162,
      1.631571,
      NULL,
      2,
      1.953056,
      7.674588,
      2.805190,
      1,
      NULL,
      5.752851,
      31.785644,
      NULL,
      1,
      NULL,
      1,
      '13032',
      '40434',
      '20424',
      1,
      '',
      '',
      '',
      2,
      '30412',
      NULL,
      '',
      3,
      5,
      40,
      0,
      0.814405,
      NULL,
      10.304098,
      NULL,
      0.465570,
      3,
      NULL,
      0.818208,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.692885,
      1,
      0,
      0,
      1.015936,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.894968,
      NULL,
      NULL,
      0.054549,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.499698,
      1,
      NULL,
      NULL,
      NULL,
      1.195950,
      0.537016,
      NULL,
      1,
      2,
      2,
      1.910877,
      1.944593,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.011139,
      1.204962,
      2.816816,
      2,
      NULL,
      0,
      0,
      0,
      1.270288,
      0.048125,
      0.393144,
      1.540991,
      1.916257,
      1.551808,
      0.528765,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563821,
      NULL,
      NULL,
      0.329090,
      5,
      0.523868,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.903171,
      0.611758,
      NULL,
      1,
      1.846901,
      NULL,
      NULL,
      NULL,
      3.159530,
      0,
      NULL,
      3.818751,
      0.589593,
      0.378391,
      NULL,
      NULL,
      3.500303,
      1,
      2,
      3.890906,
      NULL,
      0.579985,
      1,
      2,
      1,
      2.896338,
      3,
      1.951790,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.240702,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.011274,
      NULL,
      NULL,
      1.567872,
      NULL,
      NULL,
      2.849380,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      5,
      NULL,
      NULL,
      2.648802,
      NULL,
      NULL,
      3.471016,
      1.777855,
      0.318418,
      2,
      2,
      2.931582,
      NULL,
      NULL,
      3,
      NULL,
      2.705662,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      0.771411,
      5.405503,
      8.509677,
      4.161632,
      4,
      NULL,
      0,
      3.221976,
      1,
      7.717956,
      0.715498,
      3.253522,
      NULL,
      1.357666,
      1,
      1.208970,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.035009,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.314128,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.023140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.911628,
      NULL,
      NULL,
      NULL,
      2.323581,
      3.613432,
      1.831178,
      3,
      1,
      1,
      NULL,
      1.910657,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.047446,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.599377,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.082945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418331,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.626784,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.749240,
      NULL,
      NULL,
      0.619810,
      0.629904,
      1.209875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.810550,
      NULL,
      0.470222,
      1,
      1.907933,
      NULL,
      4.129746,
      0,
      NULL,
      4.854793,
      1,
      NULL,
      NULL,
      0.114576,
      1,
      NULL,
      NULL,
      NULL,
      0.202023,
      NULL,
      0.941262,
      0,
      1,
      0,
      1,
      1,
      0.080279,
      0.552252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.104268,
      NULL,
      3.362834,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365057,
      NULL,
      NULL,
      1.972802,
      NULL,
      1.770476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818356,
      NULL,
      1,
      NULL,
      2.547648,
      NULL,
      NULL,
      NULL,
      108.355165,
      NULL,
      0,
      NULL,
      2.119486,
      NULL,
      2,
      NULL,
      0.442690,
      0.478987,
      0.156767,
      NULL,
      1.403524,
      NULL,
      NULL,
      NULL,
      211,
      NULL,
      2.715617,
      0.752584,
      1,
      NULL,
      3.093103,
      NULL,
      3,
      NULL,
      283.870366,
      NULL,
      1,
      0,
      2.695882,
      NULL,
      0.863209,
      NULL,
      3,
      NULL,
      25,
      NULL,
      1.129211,
      NULL,
      3.829057,
      NULL,
      0.728699,
      1.305652,
      3,
      12.751480,
      39.925487,
      0.224849,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.697349,
      2.608556,
      1,
      NULL,
      3.206098,
      NULL,
      2,
      3,
      2.160675,
      1,
      0,
      NULL,
      NULL,
      0.780544,
      2.051237,
      0.038220,
      0.406728,
      0,
      0,
      0,
      1,
      1,
      0,
      2.846001,
      0,
      2,
      NULL,
      NULL,
      0,
      1.156935,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.221008,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0.010056,
      1.066696,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.664007,
      0,
      NULL,
      0,
      0.621065,
      2.820993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      1.107896,
      0.789116,
      1,
      NULL,
      '03220',
      '22423',
      1.298173,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


