set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8900787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '0331024',
      0,
      0.317311,
      5,
      1,
      '0011',
      1.995865,
      0.126772,
      NULL,
      NULL,
      ' 0-27-1994',
      31.051720,
      NULL,
      2.568270,
      0,
      1,
      ' 9-15-2002',
      20,
      0.145134,
      NULL,
      146,
      3,
      ' 5- 6-1976',
      '11- 7-1978',
      ' 5-22-1996',
      NULL,
      2.376157,
      NULL,
      1,
      0,
      1.295264,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      9.007439,
      0,
      1.492349,
      27.979535,
      0.572448,
      25.036098,
      9,
      2,
      3.716720,
      1,
      0.842217,
      1,
      0.607653,
      1,
      0.265472,
      1,
      1,
      0.306045,
      0,
      0,
      5.518505,
      3.864214,
      0,
      1.308647,
      0.927846,
      NULL,
      NULL,
      2,
      5.447215,
      0.183903,
      9,
      1.617431,
      2.711853,
      0,
      3,
      2.343589,
      4.625174,
      0,
      2.115131,
      2,
      NULL,
      0.182450,
      NULL,
      NULL,
      1.797482,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3.151277,
      0.661929,
      NULL,
      0.088314,
      1.984611,
      3.522243,
      1,
      0,
      NULL,
      0.735237,
      1,
      1,
      0,
      2,
      1,
      1.727974,
      1,
      0.914292,
      0.164808,
      5,
      0,
      3.299680,
      5.506282,
      NULL,
      NULL,
      NULL,
      0.680429,
      NULL,
      NULL,
      0,
      1.450830,
      3,
      0.165715,
      1,
      0,
      1.488279,
      0,
      0.045280,
      NULL,
      2,
      0,
      0,
      3,
      0.315743,
      0,
      1.365309,
      1,
      1.850227,
      NULL,
      1.129143,
      NULL,
      NULL,
      0,
      0,
      0.071252,
      NULL,
      0.182860,
      3,
      0,
      8,
      9.379019,
      1.217588,
      0.933233,
      1,
      2.411216,
      3.957249,
      NULL,
      2,
      NULL,
      1.040278,
      0.396716,
      6.754353,
      5.404140,
      NULL,
      0,
      0,
      0,
      ' 6-23-1981',
      194.061954,
      ' 0- 8-1996',
      NULL,
      NULL,
      1.130549,
      NULL,
      NULL,
      1.181651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.512267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651184,
      NULL,
      4.415932,
      1.789288,
      0.816162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.546486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5,
      0.648666,
      1,
      1.093742,
      0.200819,
      NULL,
      NULL,
      1.813598,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.300105,
      1,
      2.457404,
      2,
      0,
      0,
      2.735808,
      104.353765,
      2,
      2,
      40,
      NULL,
      36,
      2,
      1.735632,
      3.367839,
      3.969880,
      NULL,
      NULL,
      2,
      1.836250,
      2.823136,
      NULL,
      2.761265,
      NULL,
      3.288997,
      2,
      1,
      0.714870,
      0.262434,
      0.544405,
      0.319432,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391662,
      NULL,
      NULL,
      NULL,
      2.738700,
      3,
      0,
      10,
      NULL,
      6,
      9.043484,
      7.625141,
      NULL,
      NULL,
      NULL,
      2.845728,
      3,
      1,
      1,
      23,
      1,
      1,
      NULL,
      2.277595,
      43.245640,
      55.593490,
      2.814571,
      1.111272,
      3.353095,
      '03024',
      '30441',
      NULL,
      2.012362,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.320923,
      34,
      98,
      21,
      2,
      1.986089,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.180827,
      0.515931,
      NULL,
      NULL,
      0.898894,
      NULL,
      NULL,
      3.867042,
      3.087075,
      1.589561,
      NULL,
      3,
      0.860040,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.835887,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732292,
      NULL,
      NULL,
      NULL,
      2.681712,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.580079,
      0.420039,
      0.026130,
      1,
      2.350534,
      1.581198,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.262742,
      0.212325,
      2,
      3.113383,
      NULL,
      NULL,
      1,
      0,
      0,
      0.186871,
      2.668879,
      1.068044,
      NULL,
      0,
      0.893256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.050678,
      NULL,
      NULL,
      9,
      5.750814,
      2.699757,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.408850,
      NULL,
      NULL,
      3,
      3,
      1.384575,
      0,
      NULL,
      NULL,
      0.953051,
      NULL,
      NULL,
      1.091512,
      1.434871,
      3.998192,
      3,
      3,
      1.138634,
      0.647189,
      2,
      0,
      3.408928,
      1.092331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839366,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.767407,
      NULL,
      NULL,
      1.536697,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      1,
      2.412659,
      3.725120,
      1,
      6,
      4,
      NULL,
      1,
      2,
      1.636045,
      0,
      2.553167,
      0.843440,
      3,
      3,
      0,
      1,
      3.611346,
      2.360139,
      6.721886,
      6,
      4,
      2,
      5.532946,
      2.415622,
      1.777944,
      0,
      7.454587,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369490,
      NULL,
      NULL,
      1.970961,
      NULL,
      NULL,
      1.193975,
      NULL,
      NULL,
      0.851933,
      NULL,
      NULL,
      2.494171,
      NULL,
      NULL,
      1.885543,
      NULL,
      NULL,
      0.883463,
      NULL,
      NULL,
      2.521221,
      0.095405,
      2.045494,
      0.201124,
      1,
      NULL,
      1.177495,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.825704,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5.144359,
      NULL,
      NULL,
      NULL,
      0.543184,
      0,
      0.900074,
      3.002699,
      1,
      NULL,
      23,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2.338709,
      NULL,
      NULL,
      23.943764,
      1.659259,
      NULL,
      NULL,
      0,
      NULL,
      1,
      13296,
      675.030791,
      NULL,
      0.261656,
      1,
      0.231881,
      NULL,
      1,
      0,
      1.280043,
      0.209530,
      1.215488,
      NULL,
      1.490808,
      1.637752,
      0.350182,
      1,
      1,
      1.679158,
      0.135043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868398,
      0,
      1.069496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472708,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.214325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.520747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.635672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.063024,
      NULL,
      1,
      NULL,
      1.591916,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.895276,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.281631,
      6,
      3.279331,
      5.809563,
      NULL,
      3,
      13,
      2.190929,
      0.387014,
      0.785277,
      1,
      NULL,
      NULL,
      0,
      1.371390,
      NULL,
      0.337563,
      3.899819,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.327568,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.556633,
      NULL,
      NULL,
      1.631455,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.218016,
      NULL,
      NULL,
      0.651372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.676776,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.399152,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.651268,
      NULL,
      1.380872,
      NULL,
      NULL,
      NULL,
      1.998242,
      NULL,
      1,
      NULL,
      12,
      0.302949,
      8,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.612649,
      2.916405,
      3,
      3,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      4,
      '34423',
      '21123',
      '',
      0,
      '23244',
      '',
      '',
      0.242893,
      NULL,
      '',
      '');
commit;
end;
/


