set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9749389';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1,
      5,
      2.181976,
      0,
      3.694570,
      3,
      1,
      '442',
      '30041114',
      19.910543,
      37.367740,
      '3310031',
      NULL,
      NULL,
      NULL,
      3,
      '2432',
      4,
      1.964969,
      NULL,
      NULL,
      ' 9-12-1980',
      158.924966,
      143.464366,
      NULL,
      0.913552,
      NULL,
      '10- 0-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      1.895370,
      ' 4- 7-1984',
      NULL,
      NULL,
      3,
      1.615659,
      2,
      NULL,
      0,
      3.399329,
      2.278093,
      1,
      1,
      4.255089,
      4,
      7.777360,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.029822,
      0.437176,
      0,
      NULL,
      0,
      1.027484,
      1,
      0,
      0,
      145,
      12.293398,
      3.488548,
      0,
      NULL,
      1.492404,
      NULL,
      1,
      0.535460,
      1.754003,
      NULL,
      1,
      1,
      0,
      0.528224,
      0,
      0.877295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734350,
      NULL,
      3,
      NULL,
      0.594765,
      0.588472,
      0.971633,
      1.496202,
      2.774052,
      0.129054,
      NULL,
      NULL,
      0,
      0.525571,
      2.909057,
      1.558801,
      0.871894,
      NULL,
      3,
      1.486397,
      1.623162,
      2,
      6,
      1,
      5,
      1.587905,
      1.774470,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.393108,
      1.373660,
      4,
      NULL,
      2.766312,
      2.922239,
      5,
      1.232262,
      3.843605,
      0,
      0,
      4.335324,
      0,
      1,
      0,
      1.024276,
      1.698397,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.530473,
      NULL,
      0.987310,
      0.243929,
      2.550383,
      9,
      NULL,
      0,
      4.854430,
      4,
      7,
      NULL,
      NULL,
      0.261759,
      5,
      9,
      NULL,
      0,
      8,
      3.744660,
      6,
      5,
      5.883269,
      4.296088,
      1.811458,
      0,
      ' 6- 9-1995',
      553,
      ' 3-29-1990',
      8.779462,
      0.981439,
      0,
      NULL,
      4,
      1.106378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.580070,
      2,
      0.285072,
      0.449257,
      0.743435,
      0,
      2.173137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.579105,
      0,
      4,
      0.230037,
      0.271860,
      3,
      2,
      NULL,
      NULL,
      1.744946,
      0,
      1.144596,
      NULL,
      1,
      1,
      2,
      5.736663,
      NULL,
      1.087950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748952,
      0,
      1,
      0,
      0.312531,
      1,
      NULL,
      2,
      1053,
      0.612366,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      NULL,
      2.866424,
      NULL,
      2,
      0.062901,
      1.928966,
      1,
      1.915033,
      0,
      0.253575,
      3,
      1,
      0.084268,
      1.755858,
      1,
      3.109476,
      0,
      1.869171,
      1,
      0.230653,
      NULL,
      0.500924,
      1,
      1.348937,
      0,
      0.900221,
      2.617655,
      1.768328,
      0,
      9,
      3.488301,
      NULL,
      9,
      5,
      0.262671,
      3,
      3,
      1.588065,
      1.428048,
      NULL,
      26,
      3,
      NULL,
      17,
      NULL,
      9.732661,
      NULL,
      1.318339,
      5,
      0.248224,
      '00303',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.279510,
      '',
      '',
      '',
      3.903678,
      NULL,
      0.616380,
      15.893754,
      2.950157,
      37.640730,
      NULL,
      3.222932,
      4.568190,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.629758,
      NULL,
      NULL,
      2,
      3,
      1.968577,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.664587,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.084499,
      NULL,
      NULL,
      0,
      0.592163,
      NULL,
      NULL,
      NULL,
      1.011051,
      NULL,
      NULL,
      NULL,
      0.506757,
      0.585595,
      1,
      3.185615,
      1.939058,
      2.269745,
      2.585672,
      0.898156,
      0,
      3.257036,
      1,
      1.836031,
      1,
      NULL,
      1.787471,
      1.615540,
      3,
      3.073963,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.953933,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992956,
      0,
      1,
      4,
      5.372748,
      1,
      0.794004,
      NULL,
      NULL,
      NULL,
      2,
      1.759935,
      0.542295,
      1,
      NULL,
      NULL,
      NULL,
      0.808053,
      1.423996,
      3,
      NULL,
      NULL,
      0.565497,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.433758,
      2.288827,
      1.093797,
      NULL,
      NULL,
      1.774567,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.011364,
      0,
      3,
      2,
      0,
      6,
      4.615567,
      2.299962,
      6,
      0,
      3,
      3.662176,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.721393,
      2,
      2.800840,
      0,
      3,
      0,
      0.515427,
      1,
      NULL,
      0,
      2.565148,
      1,
      NULL,
      1.824111,
      0.480355,
      2,
      1,
      0,
      1,
      2.466363,
      5,
      4,
      4.613478,
      3,
      2.765439,
      3,
      2.884054,
      NULL,
      8,
      NULL,
      1.396608,
      0,
      1,
      NULL,
      1.780716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559092,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707944,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      3,
      1.454346,
      1,
      NULL,
      NULL,
      2.438435,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750855,
      NULL,
      NULL,
      1.910816,
      NULL,
      NULL,
      NULL,
      0.308594,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3,
      1.052271,
      NULL,
      NULL,
      2.630401,
      1,
      NULL,
      NULL,
      0.237872,
      0.376030,
      NULL,
      NULL,
      0,
      3.047044,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939455,
      NULL,
      NULL,
      NULL,
      0.549663,
      NULL,
      NULL,
      2,
      2.123293,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4.475666,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770720,
      11.584152,
      NULL,
      NULL,
      21,
      1,
      1.919896,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.188962,
      NULL,
      NULL,
      1,
      NULL,
      1.656532,
      NULL,
      3.263851,
      NULL,
      NULL,
      NULL,
      1.675162,
      1,
      2,
      1,
      2,
      0.689671,
      3,
      1,
      1,
      0,
      2,
      1.682168,
      0,
      0,
      0,
      NULL,
      0.806566,
      NULL,
      1.326178,
      NULL,
      2.181384,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      27.681236,
      NULL,
      0.389345,
      23.740880,
      9,
      0.226663,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602944,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.711364,
      NULL,
      3,
      NULL,
      0.444912,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.780024,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.228335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.379724,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.782860,
      NULL,
      5,
      NULL,
      3.713295,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.882767,
      0.787954,
      3,
      NULL,
      2.097882,
      NULL,
      1.928791,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.620671,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.121933,
      1.913414,
      NULL,
      1,
      NULL,
      3.935639,
      NULL,
      329,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.839627,
      1,
      3.171416,
      23,
      36.997117,
      1.310783,
      1,
      3.398198,
      NULL,
      0,
      0.740282,
      NULL,
      0,
      1,
      0.618810,
      0,
      NULL,
      1.378195,
      1.748029,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.604801,
      NULL,
      NULL,
      1.244041,
      3,
      NULL,
      1.443841,
      2.441874,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.533712,
      1,
      NULL,
      0,
      0.706235,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.298108,
      NULL,
      4.836746,
      5,
      NULL,
      0.325360,
      NULL,
      NULL,
      NULL,
      75.522811,
      0,
      1,
      3.292992,
      '33110',
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


