set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9697949';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      '41',
      1,
      NULL,
      '0201310',
      2.132510,
      NULL,
      1,
      NULL,
      '3430',
      1.044382,
      0.552225,
      NULL,
      NULL,
      ' 6- 2-1974',
      27.000191,
      NULL,
      NULL,
      0.496907,
      0.846829,
      ' 0- 3-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-10-1985',
      NULL,
      ' 0-29-1983',
      3,
      NULL,
      2.773694,
      2.285416,
      1.823394,
      0,
      0.800020,
      0.533266,
      NULL,
      NULL,
      NULL,
      NULL,
      7.060943,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.129922,
      2.238725,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      9,
      1,
      1,
      9,
      0,
      NULL,
      0,
      0.423883,
      8.324582,
      NULL,
      5,
      0.359063,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.022047,
      1.407064,
      NULL,
      1.160953,
      NULL,
      0.751898,
      NULL,
      0,
      2.838241,
      1,
      3,
      NULL,
      3,
      1.700902,
      1.666484,
      NULL,
      0,
      NULL,
      2.709526,
      6.202147,
      NULL,
      NULL,
      7,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347658,
      5,
      1,
      NULL,
      3.713754,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.300264,
      1,
      0.185568,
      1.834376,
      NULL,
      NULL,
      0.737328,
      1,
      1,
      0,
      5,
      0,
      NULL,
      NULL,
      1.337966,
      7.020741,
      2,
      2.963826,
      NULL,
      4.769806,
      2,
      3,
      4.126269,
      9,
      NULL,
      7.927262,
      5,
      4.030087,
      5,
      NULL,
      3.735084,
      3,
      2,
      0.113461,
      '11- 4-1985',
      436.479302,
      ' 1-27-1999',
      241.860616,
      0,
      NULL,
      0.479009,
      7,
      0.971505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.454619,
      NULL,
      NULL,
      0,
      1.409747,
      0.855611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571827,
      NULL,
      9.140849,
      1.729850,
      1.681564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      3.739969,
      NULL,
      1.736912,
      NULL,
      0,
      1,
      5,
      1.907902,
      4.249381,
      2.624242,
      NULL,
      NULL,
      NULL,
      1,
      0.652806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.181817,
      1.848955,
      0,
      1.477181,
      0.407118,
      NULL,
      13,
      NULL,
      1.062482,
      NULL,
      NULL,
      NULL,
      2,
      0.024196,
      1,
      1.151343,
      3.017717,
      0,
      1.838486,
      1.938772,
      3,
      2.125467,
      0.371475,
      3,
      1.220153,
      NULL,
      3.408876,
      1.804974,
      0.720006,
      0.344250,
      1.065928,
      NULL,
      0,
      0.980660,
      0,
      0,
      0,
      0,
      1,
      0.004701,
      NULL,
      3,
      0,
      0.607435,
      4,
      0,
      7.255520,
      5.649301,
      7.782068,
      NULL,
      3.077687,
      NULL,
      0,
      3.442642,
      0.811745,
      1.343024,
      1.377590,
      3,
      0.801370,
      13,
      NULL,
      44,
      25.669906,
      NULL,
      NULL,
      1.367882,
      NULL,
      '',
      '',
      1.872668,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      2.263109,
      11.600685,
      292,
      NULL,
      1,
      6.542254,
      2,
      0.819463,
      NULL,
      1.157649,
      0,
      0,
      1.202397,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.737323,
      1.224354,
      1,
      NULL,
      NULL,
      1.427411,
      0.672089,
      1,
      2.335016,
      0,
      1.539731,
      2.460903,
      0.801620,
      NULL,
      3,
      0.341507,
      0,
      0.755667,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.331552,
      NULL,
      NULL,
      5,
      0,
      0.445896,
      1,
      0.816598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.007244,
      0,
      0,
      1.720916,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.691528,
      0,
      0.274121,
      1,
      0,
      0,
      2,
      1,
      0.043880,
      0.357935,
      0,
      1,
      NULL,
      2.121579,
      0.879248,
      NULL,
      0.080088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385211,
      2,
      0,
      3.899224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.703885,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181791,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      0.103143,
      3.354160,
      1.378764,
      2.220066,
      1.771652,
      1,
      1,
      NULL,
      NULL,
      2,
      0.452830,
      0.078168,
      1.467915,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.475683,
      NULL,
      NULL,
      1.186845,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.495579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403784,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.107180,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671076,
      NULL,
      NULL,
      2,
      1.255570,
      2,
      0.018254,
      0,
      1.960001,
      0.002597,
      NULL,
      3,
      3.083865,
      0.771537,
      3.817099,
      0.413197,
      NULL,
      NULL,
      0.742439,
      1,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      5,
      NULL,
      6.442708,
      3.668421,
      2,
      2.451722,
      4.269772,
      0,
      1.931676,
      NULL,
      0,
      NULL,
      0.902973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.015588,
      NULL,
      NULL,
      1.571348,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.355656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      0.056308,
      2.144688,
      1,
      6,
      NULL,
      1.427840,
      NULL,
      1,
      NULL,
      8.512352,
      NULL,
      1.199892,
      NULL,
      0.084710,
      NULL,
      0.299035,
      NULL,
      2,
      NULL,
      1.105552,
      NULL,
      3.581508,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.857264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183592,
      NULL,
      NULL,
      NULL,
      1.028461,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.784230,
      NULL,
      0.198071,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.391118,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.849375,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      10,
      NULL,
      2.396060,
      NULL,
      0.765816,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      12.561930,
      3.316103,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.323000,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.574056,
      98,
      1,
      0,
      0.935603,
      NULL,
      1.577078,
      NULL,
      1.033022,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.645182,
      0.352074,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.379304,
      1,
      2,
      5,
      2.937056,
      0.411726,
      NULL,
      1.193340,
      12,
      3,
      3.317570,
      1,
      0,
      1,
      NULL,
      0.334619,
      0,
      NULL,
      1,
      2.963488,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.816622,
      0.777113,
      NULL,
      NULL,
      0.867677,
      NULL,
      1,
      3.911381,
      NULL,
      1,
      0.948484,
      NULL,
      NULL,
      2.701899,
      NULL,
      NULL,
      0,
      NULL,
      1.098449,
      0,
      0.084394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191214,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.098880,
      NULL,
      1.608183,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      7,
      3.889983,
      NULL,
      NULL,
      NULL,
      3.869119,
      NULL,
      1.261279,
      NULL,
      5,
      NULL,
      9,
      1.247080,
      NULL,
      NULL,
      104,
      NULL,
      NULL,
      3,
      1.922523,
      '21414',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


