set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100613';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '1403324',
      NULL,
      0.989171,
      0,
      0,
      '4104',
      3.243160,
      0,
      NULL,
      NULL,
      NULL,
      66.204486,
      NULL,
      3,
      2,
      1,
      ' 1- 8-1981',
      NULL,
      3.649127,
      301.413298,
      53,
      NULL,
      ' 6-20-1996',
      NULL,
      ' 9-17-1978',
      2,
      1.965727,
      0.506089,
      0.587984,
      0.220316,
      0.877289,
      0,
      0.858357,
      0.332338,
      23.821966,
      9,
      3.060414,
      7.213080,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.450210,
      9.191596,
      0.554323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070135,
      NULL,
      NULL,
      0,
      0,
      0.993140,
      0,
      NULL,
      1,
      1.148755,
      0,
      1.842495,
      0.307898,
      0,
      1,
      1.575412,
      1.624444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771618,
      0.073091,
      NULL,
      0.551131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080379,
      0,
      0.669686,
      0,
      2,
      NULL,
      0.395339,
      NULL,
      5.887163,
      3.738988,
      NULL,
      0.821858,
      NULL,
      2,
      NULL,
      0.288032,
      1,
      0.428195,
      NULL,
      NULL,
      1.745593,
      1,
      0,
      2.536612,
      1,
      0,
      3,
      1.678049,
      0.233724,
      0.427999,
      0,
      NULL,
      1.245018,
      NULL,
      3,
      NULL,
      1.535427,
      0,
      4,
      3.644920,
      NULL,
      5.681510,
      2,
      1,
      1.046989,
      NULL,
      3.180437,
      1,
      ' 7-16-1987',
      1561.142900,
      ' 3-15-1998',
      NULL,
      2.482177,
      0.955645,
      1,
      5.503742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.018460,
      NULL,
      1.642430,
      0.018683,
      0,
      1.734861,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858639,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774893,
      NULL,
      1,
      1,
      1,
      1,
      1.664827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.529910,
      1.903822,
      1.822873,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066479,
      0.651736,
      0.417368,
      0,
      1,
      1.735061,
      NULL,
      3.954521,
      63,
      1.992309,
      1.582790,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.910337,
      3.159890,
      1,
      NULL,
      NULL,
      1.438011,
      2.266539,
      3,
      2.663826,
      2,
      NULL,
      1,
      NULL,
      2.638984,
      2.756574,
      NULL,
      1,
      10,
      0,
      0.114559,
      0,
      1,
      NULL,
      1.360873,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      11.250929,
      5,
      3.398281,
      3.570951,
      0.231340,
      NULL,
      5.983374,
      2,
      2.177535,
      1,
      1.392876,
      NULL,
      55.310320,
      2.856535,
      3,
      NULL,
      16,
      101.813070,
      44.892454,
      4.170661,
      1.363585,
      1.517994,
      '44314',
      NULL,
      NULL,
      1.077380,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      25,
      482.770477,
      0.372990,
      1,
      38,
      3.357150,
      121.677531,
      4,
      0.330126,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.803668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.510580,
      0.164077,
      0.468827,
      1.826094,
      NULL,
      NULL,
      2,
      2,
      1.594202,
      1.299134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.357580,
      NULL,
      NULL,
      3,
      2,
      2.443311,
      1,
      1.350363,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.377505,
      3.478862,
      1.788540,
      3.159480,
      NULL,
      1.613599,
      0,
      NULL,
      1.295339,
      1.539771,
      1.133401,
      NULL,
      0.927452,
      1.660968,
      1.645269,
      3,
      1.998619,
      0.988200,
      NULL,
      NULL,
      0.674446,
      NULL,
      NULL,
      4,
      2,
      1,
      NULL,
      1.592224,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.130510,
      0.697723,
      NULL,
      NULL,
      8,
      7,
      1.420266,
      1.909225,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.858823,
      4.452687,
      5,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.552573,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.800802,
      1,
      5.454220,
      2,
      NULL,
      5.168333,
      0,
      1.988278,
      1.404417,
      NULL,
      5.777224,
      NULL,
      NULL,
      NULL,
      3.750825,
      3.739277,
      0.679806,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3.958775,
      0.768478,
      1.900536,
      NULL,
      0,
      NULL,
      NULL,
      1.616463,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.634825,
      3,
      0.601145,
      1,
      1,
      2.384930,
      1.109418,
      0,
      3,
      1,
      0.016166,
      0.034078,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.545411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353839,
      NULL,
      NULL,
      1.085253,
      NULL,
      NULL,
      1.625534,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.972369,
      NULL,
      NULL,
      1.873848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.979363,
      1,
      0,
      0.401915,
      1.137541,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445576,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.531124,
      NULL,
      NULL,
      NULL,
      1.841052,
      NULL,
      NULL,
      NULL,
      0.534299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.770482,
      NULL,
      NULL,
      NULL,
      1.540474,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      183.749407,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.140659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.832320,
      134,
      2.398573,
      NULL,
      0,
      1.610521,
      1.064325,
      0.917201,
      0.793792,
      1.531166,
      1.308425,
      1,
      1,
      0.138017,
      0.073364,
      NULL,
      NULL,
      1,
      0,
      0.348976,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.021840,
      1,
      0.514407,
      2,
      2,
      1.500485,
      NULL,
      NULL,
      3.404213,
      1.575838,
      0.209021,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.475923,
      3.458325,
      NULL,
      0,
      0.503746,
      NULL,
      1.347383,
      1.164968,
      NULL,
      3,
      2.348206,
      NULL,
      1,
      1.145894,
      NULL,
      1,
      0.538042,
      NULL,
      1.180191,
      0,
      NULL,
      3.310402,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916985,
      NULL,
      0.622595,
      NULL,
      1.941456,
      NULL,
      3.052159,
      NULL,
      4.409557,
      NULL,
      NULL,
      NULL,
      54,
      18,
      4.620605,
      0.745277,
      2.539942,
      '33203',
      '44043',
      '42031',
      0.970920,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


