set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9020917';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '1312211',
      NULL,
      1.042470,
      0,
      NULL,
      '2434',
      NULL,
      1.936484,
      NULL,
      NULL,
      ' 9- 0-1998',
      12,
      NULL,
      2.393542,
      2,
      NULL,
      ' 5- 6-1995',
      0.081448,
      3.211224,
      307.004278,
      NULL,
      0,
      NULL,
      ' 0-26-1991',
      ' 6- 4-2003',
      0,
      0,
      0,
      3,
      1.903811,
      1,
      NULL,
      0.010872,
      1,
      10.044384,
      3.249495,
      18,
      5,
      15.883940,
      NULL,
      NULL,
      NULL,
      4,
      3,
      4,
      0.650650,
      1,
      1.757269,
      NULL,
      0,
      NULL,
      1.858120,
      0,
      0.685735,
      1,
      NULL,
      NULL,
      1,
      5,
      2,
      NULL,
      0.907430,
      1.916972,
      NULL,
      NULL,
      1.846426,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      3,
      1.924912,
      0.936564,
      0,
      1.954306,
      NULL,
      1,
      1.310074,
      NULL,
      0.148522,
      0.137387,
      1.058514,
      1.490744,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.725731,
      NULL,
      NULL,
      NULL,
      0.944369,
      2,
      1,
      1.953850,
      0.598736,
      0.238239,
      1,
      1.574547,
      0.108426,
      0,
      1,
      0.872549,
      0.082525,
      0,
      NULL,
      1,
      NULL,
      5.721116,
      0,
      NULL,
      5,
      4.576309,
      0.294950,
      2,
      2.176944,
      NULL,
      1.501149,
      1,
      NULL,
      0,
      0,
      NULL,
      0.282302,
      1,
      3,
      5,
      4.929025,
      0,
      3.071381,
      1,
      1.113111,
      7.069671,
      3,
      '11-21-1995',
      44.435567,
      ' 5-27-1975',
      11,
      3,
      NULL,
      0,
      NULL,
      1.709417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.358586,
      1.783548,
      1.286324,
      1,
      0,
      0.787004,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616145,
      0,
      1.191980,
      1,
      0,
      3,
      0.347516,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.982868,
      0.950737,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.235288,
      2,
      NULL,
      2.149132,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.010048,
      1.217951,
      0.718756,
      3.205382,
      3,
      4,
      0,
      1,
      1.033004,
      0.439003,
      NULL,
      0.625989,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2.101375,
      1.006320,
      2,
      6,
      NULL,
      6.945427,
      NULL,
      7.772048,
      5.999847,
      NULL,
      7.208633,
      NULL,
      0.686770,
      1.715806,
      8,
      NULL,
      1,
      NULL,
      21,
      29.962726,
      1,
      5,
      1,
      3.041843,
      '33120',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1.003933,
      '',
      '',
      '',
      1,
      NULL,
      334,
      NULL,
      NULL,
      3,
      0,
      1.780024,
      0.366446,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.166729,
      NULL,
      NULL,
      NULL,
      0.668265,
      1.762159,
      1.893557,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.146968,
      0.776923,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.340557,
      NULL,
      NULL,
      1.548298,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.296008,
      5,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.170267,
      2.103107,
      0,
      3.629851,
      1.892049,
      1,
      0.243850,
      NULL,
      1,
      2.703558,
      0,
      1.160966,
      3.583203,
      2,
      NULL,
      NULL,
      2.320649,
      2,
      0,
      NULL,
      NULL,
      0.340850,
      NULL,
      1,
      NULL,
      0.960058,
      3.417231,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      5,
      1.677357,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406561,
      NULL,
      NULL,
      0.341189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.306022,
      3.882959,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.524647,
      3.419776,
      2,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.828840,
      2.499246,
      3,
      0.451494,
      3,
      3,
      0.378811,
      5,
      6.803298,
      NULL,
      1.434755,
      NULL,
      1.788742,
      1,
      NULL,
      0.433341,
      2.601411,
      2,
      0.082879,
      0.265177,
      0.032235,
      1,
      10.060056,
      NULL,
      1,
      4.392726,
      4.784706,
      NULL,
      0.257235,
      0.638995,
      0.028819,
      1,
      0,
      1.342935,
      0,
      1.902135,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.055002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.238863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.523874,
      NULL,
      1.049085,
      3.861579,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365335,
      0.186183,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      0.743089,
      NULL,
      NULL,
      1.589692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482447,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.714933,
      1.913731,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.504209,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868851,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1.451032,
      NULL,
      NULL,
      NULL,
      0,
      18,
      NULL,
      0.822623,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.283740,
      NULL,
      0,
      1.787640,
      NULL,
      NULL,
      1.956597,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.831096,
      0,
      1,
      0.630771,
      1.320837,
      0,
      0,
      0.170926,
      0.264121,
      NULL,
      1,
      1.694854,
      1,
      1,
      0.309897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053639,
      NULL,
      3,
      8.838301,
      NULL,
      0.326241,
      2,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.696815,
      0,
      0.246318,
      NULL,
      1.664999,
      NULL,
      NULL,
      0.934057,
      0.427609,
      1,
      0,
      1,
      0,
      1.776850,
      0,
      NULL,
      0,
      0.882481,
      0.306998,
      NULL,
      0.819084,
      NULL,
      0.372301,
      1,
      1.461686,
      1.966530,
      1.176360,
      NULL,
      NULL,
      1,
      0.077960,
      3.654554,
      0.003816,
      3.036325,
      0.103504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.140435,
      1.712801,
      NULL,
      0.685172,
      6,
      3,
      0,
      NULL,
      NULL,
      58,
      94,
      NULL,
      1,
      5.896451,
      NULL,
      NULL,
      '04013',
      0.591662,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


