set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '2342430',
      3.377816,
      0.006594,
      2,
      2,
      '0014',
      1.987235,
      0,
      NULL,
      NULL,
      ' 8- 5-1995',
      52.753757,
      NULL,
      0,
      1.324293,
      1,
      ' 6-26-1986',
      30,
      1,
      NULL,
      171,
      1.106234,
      ' 4-24-1992',
      ' 5-10-1977',
      '10-15-1983',
      NULL,
      0,
      3,
      NULL,
      1,
      2,
      2.514341,
      1,
      NULL,
      NULL,
      NULL,
      5.198261,
      0.405071,
      0,
      24.579975,
      7,
      16,
      NULL,
      NULL,
      NULL,
      0.928155,
      NULL,
      1.102092,
      0,
      0.993416,
      0.306096,
      1.309067,
      2.236736,
      1.591895,
      NULL,
      1,
      3.593967,
      2,
      4,
      3.547408,
      7,
      1,
      0,
      1.469625,
      1.075679,
      1,
      1,
      0,
      0.399022,
      NULL,
      1.812151,
      1,
      NULL,
      0.609510,
      1,
      1,
      0.858194,
      1,
      NULL,
      NULL,
      2.474413,
      NULL,
      4.271699,
      0.322242,
      0.085679,
      7,
      2,
      2,
      1,
      0.562469,
      0.240786,
      2.327028,
      1.490446,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      3.044325,
      2,
      2,
      1.785927,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      3.678687,
      2.318362,
      1,
      0.313996,
      2,
      0.252168,
      3.981697,
      0,
      0.337826,
      1,
      0,
      0.783447,
      0,
      0,
      0.151057,
      1,
      NULL,
      0.195612,
      1.765527,
      0,
      1,
      NULL,
      0,
      4.714724,
      NULL,
      1.536044,
      5.832341,
      NULL,
      7.350219,
      7.198419,
      1.301700,
      9,
      7.109429,
      1.356771,
      3.575875,
      11,
      5.256054,
      1.008251,
      NULL,
      NULL,
      1.460179,
      5.333529,
      NULL,
      4.730087,
      NULL,
      8,
      5,
      NULL,
      3,
      1,
      '10-21-2001',
      31.802144,
      '11-29-1975',
      180,
      2,
      0.457894,
      0,
      5.689968,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.146083,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809807,
      NULL,
      50,
      0.444902,
      3.068624,
      7.048225,
      0,
      2.255715,
      1,
      1.039016,
      NULL,
      5,
      3.700806,
      1.113369,
      NULL,
      NULL,
      NULL,
      0.985746,
      2.175801,
      5,
      5,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      12,
      1.455674,
      0.552542,
      1.386235,
      3.023193,
      3,
      '11- 4-2001',
      200,
      ' 0-22-2000',
      5.309921,
      NULL,
      0,
      1,
      NULL,
      1.782462,
      NULL,
      1.822834,
      0.248622,
      NULL,
      NULL,
      NULL,
      91,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.153850,
      3,
      1,
      0,
      3.133131,
      2,
      0.131445,
      3.168102,
      5,
      NULL,
      3.589706,
      NULL,
      3.510509,
      NULL,
      1,
      NULL,
      1,
      1,
      0.680777,
      NULL,
      1,
      1,
      1.503259,
      1.813987,
      NULL,
      0,
      NULL,
      0.420509,
      1.403708,
      1.187583,
      11,
      10,
      4.697660,
      NULL,
      2.241355,
      0.273107,
      2,
      0.553968,
      1.892780,
      3,
      2,
      NULL,
      66.139739,
      0.699007,
      0.662379,
      NULL,
      4.574993,
      1.625860,
      NULL,
      2.545282,
      0.055310,
      2,
      NULL,
      '0423',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      15,
      25.181970,
      24.146166,
      NULL,
      NULL,
      2,
      4.822802,
      2,
      3,
      3,
      3,
      0.161839,
      NULL,
      NULL,
      NULL,
      NULL,
      3.529873,
      1,
      NULL,
      NULL,
      1.774061,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.984152,
      2.798919,
      0.303119,
      1.046232,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.962694,
      0,
      NULL,
      0.668515,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.063611,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996177,
      NULL,
      NULL,
      NULL,
      3.641002,
      3.760286,
      NULL,
      0.938528,
      3,
      NULL,
      NULL,
      1.622778,
      2.661415,
      0,
      3.159403,
      0,
      0.016130,
      0.543848,
      1,
      1,
      3.953523,
      1.108163,
      NULL,
      NULL,
      0.924031,
      NULL,
      0,
      3.462166,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      8.408316,
      NULL,
      0,
      0.889075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812886,
      NULL,
      NULL,
      0.916975,
      3,
      0.555947,
      2.329730,
      1.461435,
      3.674268,
      0.458727,
      NULL,
      NULL,
      8.401419,
      5.037762,
      2.475215,
      0,
      NULL,
      NULL,
      0.750939,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.951237,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176922,
      NULL,
      NULL,
      6.529356,
      5,
      2,
      NULL,
      4,
      4,
      NULL,
      7.012333,
      NULL,
      1,
      NULL,
      NULL,
      0.396151,
      1,
      3.569279,
      0.111786,
      0.701139,
      1.107832,
      0.617573,
      5.845383,
      1,
      2.464848,
      2.020805,
      3,
      3,
      1,
      NULL,
      NULL,
      3,
      3,
      2,
      1,
      3,
      NULL,
      NULL,
      2.378193,
      NULL,
      7,
      0.076145,
      1.628626,
      3,
      6.370801,
      0,
      NULL,
      0.130966,
      NULL,
      0.461524,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557743,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.817542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.879542,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.292142,
      1.777521,
      2,
      0.140232,
      NULL,
      NULL,
      5.860844,
      NULL,
      NULL,
      NULL,
      190.531199,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.859193,
      NULL,
      NULL,
      NULL,
      1.381961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718629,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920335,
      NULL,
      NULL,
      NULL,
      2.779689,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.864009,
      NULL,
      NULL,
      NULL,
      2.861697,
      1.734854,
      1.308122,
      1.427289,
      NULL,
      52.039722,
      9.106699,
      NULL,
      21.189905,
      9.521697,
      0,
      NULL,
      NULL,
      0.163835,
      NULL,
      NULL,
      1.799157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.163073,
      0.960979,
      0.481073,
      1.457193,
      0.156298,
      0.102449,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1.998850,
      NULL,
      0.255609,
      0.259072,
      0.957308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.158189,
      NULL,
      NULL,
      0.499030,
      2,
      2.059599,
      NULL,
      3.191271,
      3,
      0.571988,
      1.648881,
      1,
      NULL,
      0,
      0,
      NULL,
      0.717749,
      NULL,
      NULL,
      1.454022,
      1.723873,
      NULL,
      1,
      3.219455,
      NULL,
      0.268529,
      NULL,
      NULL,
      1.290879,
      0,
      NULL,
      1,
      3,
      NULL,
      0,
      0,
      NULL,
      0.376473,
      NULL,
      NULL,
      1.141069,
      0,
      NULL,
      0.843959,
      1.968498,
      0.330331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.465107,
      NULL,
      1,
      NULL,
      3,
      0.885508,
      NULL,
      NULL,
      43,
      52,
      6,
      0,
      4.273535,
      '42420',
      '3141',
      '',
      NULL,
      '',
      '',
      '',
      0.472023,
      '',
      NULL,
      '');
commit;
end;
/


