set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6956684';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '2131322',
      0,
      0.985500,
      3,
      2,
      '0120',
      3,
      NULL,
      NULL,
      NULL,
      ' 2-22-1999',
      141,
      NULL,
      2.386234,
      3,
      NULL,
      ' 9- 7-1981',
      NULL,
      1,
      NULL,
      136,
      2,
      ' 5-10-1990',
      ' 2-27-1976',
      NULL,
      1,
      3,
      3,
      1.150081,
      1,
      2.114758,
      0,
      NULL,
      0,
      NULL,
      9,
      NULL,
      1,
      17,
      12,
      5,
      23,
      1,
      2.823312,
      1.392589,
      0,
      0.835427,
      0.643008,
      NULL,
      NULL,
      1.880806,
      0,
      1,
      0,
      0,
      0.518174,
      0.475341,
      5.649114,
      2.957746,
      1,
      NULL,
      0.213285,
      NULL,
      2,
      6.490915,
      1.995773,
      NULL,
      3,
      3,
      1.723048,
      0,
      1,
      11,
      1.575945,
      1.762383,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.652669,
      1,
      2.289796,
      2,
      1.281653,
      0.885165,
      1.635885,
      0,
      NULL,
      NULL,
      2.629745,
      NULL,
      0.887971,
      3,
      0.058919,
      0.642140,
      3,
      1.590631,
      2.813538,
      NULL,
      1,
      2,
      7,
      NULL,
      0.694096,
      3.486066,
      1.779387,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.814613,
      4.054642,
      NULL,
      3,
      1,
      0.717063,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.970239,
      1,
      NULL,
      1,
      0,
      0.481009,
      NULL,
      4.724431,
      0,
      0,
      1,
      1,
      3,
      0.962161,
      0,
      1,
      0,
      NULL,
      0.763162,
      3,
      0.654995,
      0,
      0.436063,
      1.256093,
      1,
      NULL,
      4,
      2,
      1.155736,
      5.777700,
      2.814812,
      5.807911,
      0.284004,
      1,
      7.570146,
      5.366235,
      3,
      NULL,
      337,
      ' 7-23-1975',
      398,
      NULL,
      0.635221,
      1,
      0.414196,
      1.796923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1.458815,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455569,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536286,
      1.249247,
      1,
      2.322158,
      0,
      0,
      1.702440,
      NULL,
      NULL,
      NULL,
      1.646903,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284185,
      0.718080,
      1.671247,
      3,
      NULL,
      0,
      0.753564,
      44,
      3.119169,
      NULL,
      NULL,
      NULL,
      NULL,
      2.804398,
      1.200542,
      3,
      NULL,
      NULL,
      0.201704,
      3,
      0.977793,
      1.760147,
      2.649114,
      2.722782,
      NULL,
      NULL,
      1.906375,
      NULL,
      2.348842,
      1.738916,
      0.256900,
      0,
      5,
      NULL,
      1.581861,
      0.291299,
      NULL,
      0.368872,
      1.547378,
      0,
      1,
      1,
      NULL,
      3,
      NULL,
      3.999823,
      3,
      0.263533,
      9.400504,
      7,
      5,
      NULL,
      NULL,
      6,
      NULL,
      3.799037,
      2,
      28.061324,
      1.787165,
      0,
      NULL,
      40.461793,
      56.073057,
      40.912821,
      NULL,
      1,
      2,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.020881,
      '',
      '',
      '',
      2,
      0.601932,
      338.793905,
      4,
      0.677240,
      NULL,
      1.852402,
      3,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.230803,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.321676,
      0,
      2.145020,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160375,
      3.750912,
      3,
      2.387033,
      1,
      NULL,
      3,
      1,
      2,
      0,
      1,
      4.611933,
      5,
      6.417613,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.025785,
      NULL,
      NULL,
      NULL,
      1.304000,
      1.888523,
      NULL,
      NULL,
      1.652731,
      1.028835,
      1,
      NULL,
      NULL,
      0.936150,
      NULL,
      1.182734,
      2,
      NULL,
      1.164933,
      NULL,
      1.705331,
      1.385870,
      1,
      1.278653,
      NULL,
      0,
      0.193970,
      1,
      1.510534,
      1,
      NULL,
      NULL,
      0.877447,
      NULL,
      NULL,
      0.460129,
      NULL,
      NULL,
      3.144798,
      0.162865,
      3,
      1.604890,
      0.622866,
      NULL,
      NULL,
      NULL,
      0.696129,
      NULL,
      NULL,
      NULL,
      1.276840,
      NULL,
      NULL,
      0.155036,
      NULL,
      NULL,
      2.933007,
      1,
      1.474246,
      1.347956,
      1,
      NULL,
      1.059762,
      NULL,
      2,
      1.084327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.354127,
      NULL,
      NULL,
      1.391530,
      NULL,
      NULL,
      1.863814,
      NULL,
      NULL,
      1.886284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566601,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163090,
      NULL,
      NULL,
      1,
      0.072366,
      NULL,
      0.886338,
      NULL,
      NULL,
      1.282696,
      1,
      0.410830,
      NULL,
      0,
      0.819785,
      3,
      2,
      3.082226,
      7,
      2.207575,
      5.243054,
      2.861552,
      1,
      1.752559,
      1,
      NULL,
      0,
      0,
      NULL,
      0.750624,
      2,
      3.308732,
      0.358567,
      4,
      NULL,
      NULL,
      1,
      0.221822,
      3.892355,
      NULL,
      4.438997,
      4.282556,
      0,
      NULL,
      NULL,
      0,
      0.796341,
      3.060692,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.169327,
      NULL,
      NULL,
      1.000513,
      NULL,
      NULL,
      3.861695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.267498,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1,
      1.398858,
      1,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      2.302057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322075,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611256,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184975,
      NULL,
      NULL,
      NULL,
      0.905885,
      NULL,
      NULL,
      NULL,
      0.556520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.818790,
      NULL,
      NULL,
      1,
      0.146215,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.916896,
      1.065649,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.315037,
      3.854524,
      15,
      NULL,
      1,
      NULL,
      NULL,
      1.386104,
      NULL,
      NULL,
      2.262858,
      27,
      1116.551136,
      2.977071,
      2,
      NULL,
      0.996535,
      NULL,
      NULL,
      0.532252,
      NULL,
      1,
      NULL,
      23,
      NULL,
      0.207942,
      NULL,
      0,
      1,
      0.131558,
      0.399048,
      0,
      NULL,
      0.000414,
      0.490711,
      0.784997,
      NULL,
      1.726217,
      0.656279,
      0,
      1.276703,
      0.638656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397559,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734881,
      1.927571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.437006,
      0.286454,
      1.460936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.721534,
      1.742633,
      0,
      NULL,
      NULL,
      1,
      0.107093,
      0,
      2.010604,
      2.375756,
      0.119961,
      2.886486,
      0,
      NULL,
      2,
      NULL,
      3.187201,
      2.962273,
      0.257768,
      NULL,
      1,
      1,
      1,
      0.519862,
      1.311658,
      2.423480,
      3.200337,
      NULL,
      3,
      1.332443,
      0.666860,
      0,
      NULL,
      0,
      1.719870,
      1,
      1,
      3.363085,
      NULL,
      0,
      1,
      2,
      0,
      0,
      0.121843,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.938990,
      0,
      0.626373,
      1,
      NULL,
      1,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3.514987,
      2.462198,
      1,
      1,
      NULL,
      '3132',
      '',
      '',
      0,
      '',
      '',
      '',
      1.284179,
      NULL,
      '',
      '');
commit;
end;
/


