set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      '33',
      0,
      1,
      '3301000',
      0.141058,
      1,
      6,
      2,
      '3013',
      3.975679,
      1,
      NULL,
      NULL,
      '11-23-1975',
      28,
      48.274982,
      NULL,
      1,
      0,
      ' 2-18-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-21-1976',
      ' 5-29-1988',
      ' 4-19-1998',
      1.523291,
      3,
      2.900132,
      1,
      1,
      3.500735,
      1.580219,
      3,
      NULL,
      NULL,
      NULL,
      1.926701,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.599483,
      3,
      NULL,
      NULL,
      0,
      0.333743,
      1.151018,
      1.841533,
      0.123458,
      1,
      1,
      1,
      42.724944,
      1.103685,
      12.527780,
      4,
      3.665530,
      3.808224,
      NULL,
      1,
      1,
      2,
      1,
      1,
      3,
      NULL,
      0,
      1.197668,
      0,
      1.775018,
      5.155104,
      NULL,
      4.459016,
      1,
      0.689938,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.411855,
      0.926935,
      1.067026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.135353,
      1.648827,
      3,
      1.540961,
      1,
      NULL,
      0.175066,
      NULL,
      NULL,
      1.677143,
      NULL,
      NULL,
      1,
      2,
      2,
      2.717938,
      4,
      1.551056,
      0.015390,
      0,
      1,
      1.587930,
      1,
      0.818041,
      0,
      0.278428,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.112595,
      0.556785,
      1,
      1.651475,
      1.863995,
      4.322992,
      NULL,
      3,
      0.828431,
      NULL,
      1.973234,
      1.941603,
      1.907862,
      2,
      3,
      0.897201,
      5,
      8.035139,
      3,
      3,
      5,
      7,
      1,
      NULL,
      0,
      2,
      '11-10-1983',
      173.028237,
      ' 1- 7-1984',
      85,
      1.161558,
      NULL,
      1,
      7.102261,
      0.078065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882509,
      0.598243,
      1,
      0.167617,
      0,
      0.564986,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.380946,
      5.944685,
      NULL,
      1.610023,
      3.600493,
      0.921819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.707059,
      NULL,
      0,
      NULL,
      0,
      1,
      0.349510,
      0,
      9,
      NULL,
      0,
      NULL,
      4,
      1.375712,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460813,
      1,
      1,
      0,
      NULL,
      0.648568,
      0.510147,
      0,
      5,
      3.650288,
      1.127210,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      5.843044,
      4,
      1.217505,
      NULL,
      5,
      5.570624,
      1,
      0.270318,
      0,
      2.373694,
      NULL,
      1,
      0,
      3.463240,
      0.985298,
      1,
      NULL,
      NULL,
      0,
      0.678762,
      1,
      NULL,
      1,
      0.936667,
      NULL,
      1,
      3.739280,
      0.823237,
      0.958225,
      NULL,
      1,
      2,
      5,
      10,
      7.572968,
      NULL,
      3.960701,
      0,
      0.709947,
      2,
      2,
      NULL,
      0.919779,
      3.134419,
      48,
      NULL,
      22.471928,
      30.716022,
      4,
      4.918720,
      NULL,
      '43302',
      '22120',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      35,
      NULL,
      18.083800,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677111,
      1,
      NULL,
      NULL,
      NULL,
      1.101114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.448700,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.786033,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      6.766935,
      5.855039,
      1.295833,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626815,
      NULL,
      1,
      NULL,
      NULL,
      0.245514,
      NULL,
      NULL,
      0,
      0,
      1.573705,
      1,
      NULL,
      0.678583,
      NULL,
      2.584587,
      1.096683,
      1.451071,
      3.737339,
      0.448812,
      1,
      0,
      0.525713,
      0.072031,
      2.058482,
      0,
      0.946331,
      1.119295,
      NULL,
      NULL,
      3,
      1.640982,
      NULL,
      0.804909,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094899,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.576012,
      NULL,
      1,
      3,
      1.390316,
      3,
      2,
      2.757852,
      8,
      5.998690,
      0,
      1.298716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.432587,
      NULL,
      NULL,
      1.831458,
      NULL,
      NULL,
      1.015707,
      NULL,
      NULL,
      0.106284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.222908,
      NULL,
      NULL,
      0.397223,
      NULL,
      NULL,
      1.240912,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.820754,
      2.075930,
      3.796570,
      3,
      3.112501,
      1.530121,
      3.969763,
      NULL,
      0.305676,
      0.963137,
      3.784087,
      3,
      NULL,
      NULL,
      2.949369,
      NULL,
      0,
      0,
      3,
      0.976757,
      0.394429,
      3,
      9,
      7,
      1.054696,
      NULL,
      NULL,
      0,
      1,
      2.967851,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1.490466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424391,
      NULL,
      NULL,
      0.830922,
      NULL,
      NULL,
      3.177351,
      NULL,
      NULL,
      2.090536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639570,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.022922,
      NULL,
      NULL,
      1.785046,
      2,
      3,
      NULL,
      0.133158,
      0.278180,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.437144,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.408374,
      NULL,
      NULL,
      NULL,
      1.611246,
      NULL,
      NULL,
      NULL,
      1.741098,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.718009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.915706,
      NULL,
      NULL,
      NULL,
      1.070914,
      NULL,
      NULL,
      NULL,
      3,
      0.843907,
      8,
      3,
      4,
      32,
      1,
      NULL,
      NULL,
      0.552875,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.619163,
      NULL,
      1,
      384,
      3927.317160,
      1.889754,
      1,
      3,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.015464,
      1,
      3,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      3,
      NULL,
      0.802801,
      NULL,
      0,
      NULL,
      3,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.937382,
      NULL,
      1,
      NULL,
      0.815963,
      NULL,
      3,
      NULL,
      2.301954,
      NULL,
      3.176192,
      NULL,
      1.909850,
      NULL,
      0.674057,
      NULL,
      0.254376,
      NULL,
      0,
      NULL,
      1.196239,
      NULL,
      2.546885,
      NULL,
      0.524705,
      NULL,
      3.562284,
      1.456458,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.094882,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.357225,
      1.426178,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.715173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135366,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991548,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108513,
      1.914569,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482772,
      3,
      1.205566,
      3,
      NULL,
      0,
      NULL,
      135,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.015724,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.861697,
      9,
      2.225131,
      NULL,
      1.833542,
      NULL,
      1.872472,
      NULL,
      2.864724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.791466,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.912494,
      NULL,
      NULL,
      1.488528,
      NULL,
      1.459606,
      3.325309,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.225952,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507538,
      1.474719,
      NULL,
      0.212992,
      NULL,
      0.086382,
      NULL,
      0,
      NULL,
      2.489246,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.129463,
      NULL,
      3.841183,
      NULL,
      3.027759,
      NULL,
      2.580014,
      NULL,
      1,
      NULL,
      16.322587,
      3.019912,
      NULL,
      0.647099,
      NULL,
      0,
      NULL,
      1.618107,
      NULL,
      3,
      9,
      7,
      NULL,
      2,
      0.292448,
      NULL,
      40.822677,
      2,
      NULL,
      1,
      '00131',
      '02141',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


