set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1.335966,
      '322',
      NULL,
      56,
      0,
      '4142123',
      1.462895,
      1,
      5,
      1,
      '1342',
      4.100785,
      1.732662,
      NULL,
      NULL,
      ' 6-18-2002',
      53.469090,
      35.764449,
      NULL,
      3,
      2,
      ' 1-11-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 1-26-1983',
      1,
      1.563589,
      NULL,
      3,
      1.274097,
      0.921905,
      2.232424,
      3.663096,
      NULL,
      NULL,
      NULL,
      4.471118,
      5.559452,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4.758375,
      NULL,
      0,
      NULL,
      0.212588,
      0.433617,
      NULL,
      0,
      NULL,
      NULL,
      0.189092,
      0,
      1,
      1.494807,
      NULL,
      2.672742,
      NULL,
      2,
      0,
      0.109675,
      0,
      0,
      NULL,
      1.466821,
      NULL,
      NULL,
      0.055131,
      0.750838,
      0.484154,
      5.402954,
      1.130085,
      2,
      1.508231,
      0.065483,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      9.996453,
      2,
      2.545045,
      3.341947,
      0.847681,
      1,
      2.957982,
      1,
      NULL,
      NULL,
      1,
      0.325750,
      0,
      2.243878,
      1.950457,
      1.327223,
      2.318734,
      1.060655,
      0.691999,
      1.836527,
      1,
      3,
      8,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.150741,
      0,
      1,
      0.907812,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.444040,
      0,
      1.655633,
      4,
      0.437831,
      3,
      NULL,
      1,
      1.296987,
      0.643684,
      0.281465,
      NULL,
      1,
      1,
      0,
      2.021696,
      3.566535,
      NULL,
      1.954918,
      2,
      1.874261,
      0,
      1,
      3,
      2,
      1.069162,
      1,
      0.855108,
      8,
      2,
      NULL,
      NULL,
      2.504110,
      5.324683,
      4,
      9,
      2,
      NULL,
      5,
      0,
      ' 1-25-1983',
      21.433926,
      ' 6- 3-1978',
      31,
      0,
      3.054194,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.708037,
      1.796788,
      1.188899,
      NULL,
      0.107832,
      2.240649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.682325,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.133256,
      2.938812,
      1.089150,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      7.006520,
      5.856172,
      NULL,
      NULL,
      NULL,
      0.546278,
      9,
      3.455076,
      3,
      2,
      0.311269,
      NULL,
      ' 4-24-1984',
      29.680798,
      ' 0- 1-1974',
      21,
      0.401361,
      3.333656,
      0.579359,
      0.376582,
      0,
      0,
      1.560086,
      NULL,
      0.863667,
      0,
      0.877173,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.819866,
      0,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      3,
      3.358659,
      0,
      NULL,
      NULL,
      0.418922,
      3,
      NULL,
      0,
      0,
      NULL,
      0,
      1.107772,
      1.836809,
      0,
      0,
      1.083600,
      1.184774,
      0,
      1,
      0,
      0.641331,
      2.012107,
      0,
      5.107644,
      6,
      4.022634,
      4,
      7,
      7.431415,
      NULL,
      NULL,
      3.973828,
      NULL,
      3.231900,
      3,
      18,
      2.751385,
      1.831015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      '34044',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.904863,
      '',
      '',
      '',
      2.328335,
      26.917507,
      NULL,
      17,
      NULL,
      NULL,
      4.886895,
      1.789488,
      4.745733,
      3.466059,
      1.850383,
      NULL,
      1,
      NULL,
      NULL,
      2.765499,
      3.463917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.480200,
      0,
      NULL,
      3.847684,
      1,
      1,
      NULL,
      NULL,
      1.759650,
      NULL,
      NULL,
      1.483572,
      NULL,
      NULL,
      0.163008,
      NULL,
      NULL,
      NULL,
      1.225044,
      4.113624,
      NULL,
      0.448265,
      NULL,
      NULL,
      NULL,
      2,
      1.516625,
      3,
      0.673629,
      3.966278,
      3.354058,
      3,
      1,
      2,
      1,
      NULL,
      0.361184,
      1.857897,
      1.297638,
      2.121240,
      1.456603,
      0,
      3,
      1,
      2.849720,
      3.709994,
      1,
      1,
      3,
      0.735536,
      1,
      3.094572,
      NULL,
      0.461819,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      0,
      9,
      3,
      2,
      1.292439,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.733034,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.039257,
      1,
      0.283325,
      NULL,
      0,
      0.813353,
      4.188835,
      3,
      1.960273,
      0.585204,
      NULL,
      1.866001,
      0,
      NULL,
      NULL,
      2,
      0.024091,
      0,
      0.561439,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.104626,
      NULL,
      NULL,
      0.250701,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.438954,
      NULL,
      NULL,
      1.810957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.148808,
      NULL,
      NULL,
      5.138926,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.018448,
      NULL,
      3.351917,
      1,
      0,
      9.073206,
      NULL,
      7,
      2.864178,
      0.459906,
      0,
      NULL,
      NULL,
      NULL,
      0.999095,
      3.481241,
      1,
      1,
      3,
      NULL,
      4.721073,
      7,
      8,
      0.605052,
      3.289205,
      3.580324,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0.817651,
      0,
      1.917412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.211090,
      0,
      2,
      0.617397,
      0,
      1.072498,
      1.198183,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      7.476127,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.397840,
      NULL,
      NULL,
      NULL,
      2.248545,
      NULL,
      NULL,
      NULL,
      0.961952,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.801225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.788650,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.403006,
      NULL,
      NULL,
      NULL,
      1.418686,
      NULL,
      NULL,
      NULL,
      3.696838,
      NULL,
      NULL,
      NULL,
      5.938562,
      NULL,
      NULL,
      NULL,
      0,
      3.509363,
      2,
      4.494529,
      2.558909,
      2,
      NULL,
      1,
      3,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.625230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003212,
      NULL,
      0.063612,
      0.994433,
      1,
      1,
      0,
      0,
      1.525726,
      0,
      NULL,
      1.984190,
      0,
      0,
      0.371484,
      1,
      1.335632,
      1.286771,
      NULL,
      0.445874,
      0,
      1,
      1.746333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.583254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061689,
      NULL,
      1.805407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2.396067,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      1.158209,
      1.459696,
      NULL,
      0.998287,
      0.607408,
      NULL,
      0,
      0,
      NULL,
      0.912936,
      0.082299,
      NULL,
      0,
      1,
      NULL,
      0.677805,
      1,
      NULL,
      0.650632,
      1.796121,
      NULL,
      1,
      0.505470,
      NULL,
      3.359166,
      NULL,
      0.117189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.703753,
      NULL,
      0.863617,
      NULL,
      3.921600,
      1.177303,
      NULL,
      0.338770,
      NULL,
      NULL,
      90.358023,
      76,
      NULL,
      2.466124,
      NULL,
      '20123',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


