set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8834646';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '4212140',
      3.956906,
      0,
      1,
      NULL,
      '0420',
      0.242722,
      1.678129,
      NULL,
      NULL,
      ' 7- 3-1979',
      3,
      NULL,
      2.630965,
      0,
      0,
      NULL,
      29,
      3.531125,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1993',
      NULL,
      ' 2- 9-1984',
      2,
      0.158139,
      2.467811,
      1.389180,
      NULL,
      1.323241,
      2,
      1,
      NULL,
      107,
      12,
      12,
      NULL,
      161.534594,
      NULL,
      19,
      9,
      NULL,
      3.058035,
      NULL,
      NULL,
      0.317806,
      1,
      1,
      0.544324,
      0.902522,
      0,
      0,
      0,
      3,
      0.117198,
      7,
      NULL,
      1.927296,
      NULL,
      2,
      1.525718,
      0.812493,
      0,
      1.785515,
      1,
      3.714237,
      0,
      1.125322,
      NULL,
      0.508759,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      1,
      1.090564,
      0,
      NULL,
      1,
      1.039610,
      0.071621,
      1,
      0,
      NULL,
      1,
      1.843411,
      1.720153,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1.403652,
      0.000270,
      8.521497,
      1.441672,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.779664,
      NULL,
      0,
      NULL,
      7.600238,
      1.924668,
      0,
      1,
      0,
      1,
      0,
      0.816009,
      4,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      6,
      NULL,
      0.608402,
      0,
      0,
      NULL,
      4.032711,
      1,
      2.230893,
      4.835827,
      2,
      NULL,
      2.571218,
      1,
      2,
      NULL,
      0.111881,
      8.776101,
      10.720397,
      6,
      5.013182,
      4,
      NULL,
      4,
      1.515715,
      1,
      2.082159,
      ' 4-18-1978',
      320,
      ' 0-29-2001',
      255,
      2.701556,
      1.383908,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970709,
      0.941769,
      1,
      NULL,
      2.670597,
      2.517700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856614,
      0.467609,
      5,
      1,
      0.607119,
      NULL,
      0.027672,
      NULL,
      NULL,
      NULL,
      1,
      7.833280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.415672,
      1,
      1,
      NULL,
      0.983118,
      NULL,
      0,
      1.847750,
      NULL,
      NULL,
      NULL,
      0.203902,
      0.287962,
      1,
      1,
      1.089716,
      2.882230,
      3.036922,
      3,
      3,
      0,
      3.963993,
      3,
      NULL,
      1,
      10.384595,
      NULL,
      NULL,
      NULL,
      0,
      0.460132,
      0.867991,
      0.717458,
      1.337346,
      1.289901,
      NULL,
      NULL,
      0.293701,
      1,
      0.622925,
      17,
      NULL,
      0.780693,
      2.437314,
      1.451982,
      NULL,
      0,
      NULL,
      0.887194,
      1.218928,
      0,
      6.188561,
      3.506604,
      1,
      1.926885,
      NULL,
      3,
      3.122589,
      NULL,
      59,
      43.711440,
      66,
      1.181434,
      1.332433,
      NULL,
      '01340',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1.562430,
      '',
      '',
      '',
      NULL,
      NULL,
      74,
      37,
      3,
      9,
      5,
      NULL,
      0.578525,
      0,
      3,
      3.154017,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.760440,
      2.711989,
      2.430330,
      1.446761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494621,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.150291,
      NULL,
      NULL,
      2.935856,
      3.565319,
      NULL,
      2.506544,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.406922,
      0,
      3,
      19.112167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1.331360,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0.285499,
      0.072163,
      1.869484,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.638939,
      NULL,
      NULL,
      2.767352,
      NULL,
      3,
      1.460738,
      0,
      NULL,
      NULL,
      NULL,
      0.776665,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.990116,
      NULL,
      NULL,
      NULL,
      1.302039,
      NULL,
      NULL,
      7,
      6,
      6,
      0.626805,
      2,
      2,
      3,
      3,
      NULL,
      NULL,
      2.931339,
      1,
      0.226883,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      2.849753,
      0,
      0.460886,
      7,
      2,
      5,
      2,
      2.961018,
      1.084616,
      0.090614,
      3.918148,
      0,
      NULL,
      2,
      0.351069,
      2.079650,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3.037043,
      3,
      7.462839,
      2,
      2.041712,
      0,
      1,
      1,
      3,
      3.620069,
      2,
      3,
      3.540789,
      1,
      3.109227,
      9.944620,
      2.594325,
      NULL,
      NULL,
      2,
      5,
      0,
      NULL,
      NULL,
      0.518764,
      1,
      0.959246,
      1.834782,
      NULL,
      0.938208,
      NULL,
      NULL,
      1.323337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155197,
      NULL,
      NULL,
      0.170209,
      NULL,
      NULL,
      1.075693,
      NULL,
      NULL,
      0.500465,
      NULL,
      NULL,
      0.899264,
      NULL,
      NULL,
      0.185836,
      NULL,
      NULL,
      0.987000,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1.621505,
      3.539424,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.932254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690279,
      NULL,
      NULL,
      NULL,
      1.508129,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3.407297,
      1.438794,
      0.411318,
      NULL,
      NULL,
      1.912262,
      NULL,
      NULL,
      0.736908,
      NULL,
      NULL,
      3.274524,
      1,
      1.612891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707698,
      12513,
      339,
      1,
      NULL,
      0,
      0,
      1.074692,
      NULL,
      1,
      0,
      0,
      NULL,
      0.448071,
      1,
      1.041065,
      NULL,
      0,
      1.060695,
      1.509574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      3.929647,
      1,
      4,
      5,
      22,
      1,
      1,
      0.101147,
      NULL,
      0.816252,
      NULL,
      6,
      1.638338,
      NULL,
      12.116570,
      NULL,
      NULL,
      11,
      0,
      NULL,
      2,
      2,
      NULL,
      11.879676,
      0,
      NULL,
      17.917360,
      0,
      NULL,
      10,
      1,
      NULL,
      13,
      3.626118,
      NULL,
      NULL,
      0.716413,
      NULL,
      7.252318,
      0.647534,
      NULL,
      2.359486,
      NULL,
      0.719315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469796,
      NULL,
      0,
      NULL,
      7,
      9,
      3,
      1.102042,
      1.728990,
      2,
      62,
      35,
      6,
      0,
      2.544102,
      '30214',
      NULL,
      '',
      0.182832,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


