set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9709528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03',
      '13',
      8.257751,
      NULL,
      '1331400',
      1.603923,
      1.233636,
      2,
      3,
      NULL,
      0,
      0.026173,
      NULL,
      NULL,
      ' 9-22-1981',
      38.621615,
      8.147781,
      NULL,
      0.273586,
      0,
      ' 8- 8-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      2.014933,
      ' 0-26-1977',
      NULL,
      ' 5-27-1991',
      NULL,
      1,
      1.777536,
      1,
      NULL,
      NULL,
      NULL,
      0.373400,
      1.313902,
      6,
      4.699836,
      12.703519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.874948,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.153031,
      1.243478,
      2.938674,
      1.194882,
      3,
      0,
      3.472554,
      0.222071,
      1,
      5.402320,
      5.374246,
      1,
      1.658372,
      1.130755,
      0,
      0.025477,
      8.144431,
      0.008385,
      2,
      0.921424,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186512,
      3,
      1,
      NULL,
      0,
      3.190279,
      2,
      1.383382,
      0,
      1,
      0.909138,
      0.342199,
      3.273750,
      NULL,
      0,
      0.500728,
      2.386469,
      4.644028,
      NULL,
      4,
      3.966672,
      NULL,
      0,
      NULL,
      0.402968,
      NULL,
      NULL,
      0.171754,
      NULL,
      NULL,
      0,
      NULL,
      1.166386,
      0,
      0,
      0,
      1,
      1.814831,
      0,
      NULL,
      0,
      1.107817,
      0.968345,
      0.050067,
      1,
      1,
      1.808338,
      0,
      0,
      NULL,
      NULL,
      0,
      0.515210,
      0,
      1,
      0,
      1.741964,
      1.652636,
      NULL,
      0.909105,
      NULL,
      0.125195,
      NULL,
      1,
      0.209295,
      0.448430,
      6.032389,
      5,
      8.083268,
      7.161864,
      0,
      1.985771,
      2,
      1.541212,
      0,
      NULL,
      0,
      0.273875,
      ' 5-22-1983',
      31,
      ' 6- 3-1983',
      NULL,
      0.549223,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775429,
      1.634739,
      0,
      0,
      0,
      NULL,
      1.199710,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908461,
      NULL,
      NULL,
      0,
      0,
      2,
      0.711564,
      2.125667,
      1,
      1.507551,
      4.480567,
      6.031195,
      2,
      0.097126,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3.140355,
      6,
      5.012205,
      5,
      NULL,
      0.965268,
      NULL,
      NULL,
      1,
      0.455720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      1,
      NULL,
      0.397933,
      NULL,
      NULL,
      0.624465,
      NULL,
      NULL,
      NULL,
      NULL,
      2.816602,
      1,
      0.501137,
      3.149688,
      NULL,
      1,
      NULL,
      2.442044,
      6.725160,
      1,
      0.208395,
      3.020358,
      2,
      0,
      2,
      NULL,
      1.079745,
      1.734118,
      1.045631,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0.953887,
      0,
      1.928136,
      0,
      NULL,
      2,
      0.455584,
      NULL,
      0.881525,
      6.798624,
      10.476279,
      9,
      NULL,
      3.937417,
      0.949873,
      6,
      3,
      1,
      3.946238,
      24.450674,
      0,
      2.773939,
      26.546772,
      NULL,
      NULL,
      NULL,
      2.653390,
      2.346829,
      0.554021,
      '42040',
      '40234',
      NULL,
      0,
      '',
      '',
      '',
      1.686518,
      NULL,
      NULL,
      '',
      0.106790,
      41,
      99.837891,
      19.130930,
      3.306576,
      26.256619,
      2.378719,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.280278,
      NULL,
      NULL,
      2,
      0.176094,
      3,
      0.122413,
      NULL,
      NULL,
      NULL,
      3.260746,
      1,
      2.915156,
      2.778898,
      NULL,
      0,
      1,
      0.745024,
      NULL,
      NULL,
      NULL,
      1.264884,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.808382,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.822378,
      2,
      NULL,
      1.898516,
      1.274416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560523,
      0.850574,
      0.299405,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0.377367,
      1.234836,
      0.473376,
      0.408062,
      1,
      1,
      0.127288,
      0,
      1,
      1.426572,
      1.117380,
      3.176772,
      2,
      0.765597,
      NULL,
      0.061546,
      NULL,
      NULL,
      1,
      0,
      0.434812,
      2.406464,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.873617,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.775719,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.441414,
      NULL,
      NULL,
      0.057912,
      NULL,
      NULL,
      1.094205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680181,
      NULL,
      NULL,
      1.831492,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.815561,
      NULL,
      NULL,
      2.942349,
      0.857134,
      1.100816,
      2,
      0.237356,
      NULL,
      0,
      0.553597,
      1.574267,
      1,
      NULL,
      2.111398,
      3,
      3.148022,
      1.326194,
      0,
      1,
      1,
      3,
      3,
      0.334148,
      3.143179,
      2.040128,
      3,
      6.237661,
      0.400197,
      5,
      2.399180,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412828,
      0.028861,
      NULL,
      0.970873,
      0.634569,
      1,
      0.643281,
      NULL,
      NULL,
      1.548264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.644497,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.966466,
      NULL,
      NULL,
      1.630918,
      NULL,
      NULL,
      0.157011,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.687624,
      2,
      3.798715,
      0.945786,
      NULL,
      NULL,
      1.662162,
      NULL,
      NULL,
      9.059004,
      NULL,
      NULL,
      NULL,
      5.877439,
      NULL,
      NULL,
      NULL,
      3.127375,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.658730,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736305,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.172191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.147962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.654652,
      NULL,
      NULL,
      NULL,
      1,
      0.618991,
      3,
      0,
      1,
      0.477471,
      1.480698,
      0.512390,
      NULL,
      NULL,
      0.302446,
      NULL,
      NULL,
      2.090397,
      5.049654,
      2,
      1.958589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      169,
      8.767049,
      1.047220,
      0.655076,
      0,
      1,
      0.338740,
      1,
      1.521830,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0.062630,
      0,
      1.597580,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774128,
      1.791946,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982545,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.787851,
      NULL,
      0.123040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.879137,
      1.835979,
      NULL,
      NULL,
      2.954138,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.933771,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.709525,
      NULL,
      0.521345,
      NULL,
      230.819126,
      NULL,
      1.891634,
      NULL,
      1,
      NULL,
      1,
      0.633414,
      NULL,
      16,
      12,
      3,
      1,
      3.279734,
      7,
      0.534107,
      3.276055,
      NULL,
      1.009640,
      1.625342,
      4,
      0.422885,
      3.442436,
      NULL,
      NULL,
      1,
      1.185398,
      0.965450,
      0,
      NULL,
      0,
      3.411507,
      NULL,
      2,
      3.261883,
      NULL,
      0.376027,
      3.975212,
      NULL,
      1.911130,
      1.684659,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.265936,
      NULL,
      0.234577,
      0.131455,
      NULL,
      0.895537,
      1.264810,
      NULL,
      0.244012,
      3,
      NULL,
      3.852965,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.434072,
      1.685837,
      NULL,
      1,
      NULL,
      1.208997,
      NULL,
      0,
      NULL,
      0.725321,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.568935,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      23.827415,
      3.102164,
      NULL,
      1.330308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      0,
      2.851711,
      NULL,
      96.483530,
      74,
      0.068504,
      5.071440,
      4.571398,
      '43132',
      '13313',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


