set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9622970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1241323',
      3,
      1.458487,
      5,
      2,
      '1403',
      0.169125,
      0.628131,
      NULL,
      NULL,
      '10- 1-1984',
      46.601894,
      NULL,
      5.811768,
      0,
      1,
      ' 0-24-1985',
      38,
      2,
      89.950519,
      31,
      1.699729,
      NULL,
      NULL,
      ' 0- 3-2003',
      0.064383,
      0,
      1,
      3.849435,
      1.229670,
      0,
      0,
      0.367872,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      7,
      9,
      2.057229,
      NULL,
      4.666112,
      2,
      2.966113,
      0,
      4.302174,
      NULL,
      1.805709,
      NULL,
      1.311579,
      NULL,
      NULL,
      1,
      0,
      1.172126,
      3,
      NULL,
      0.665428,
      2.931608,
      NULL,
      0.819205,
      NULL,
      1.305736,
      4.254512,
      NULL,
      3,
      0,
      1,
      NULL,
      0.107488,
      1.905238,
      4,
      0,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.608458,
      0.174484,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971368,
      NULL,
      NULL,
      1.575017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991690,
      0,
      1.859038,
      NULL,
      0.330257,
      5,
      1,
      0.240807,
      0.674133,
      3.836014,
      0,
      0,
      1.697021,
      1.706965,
      1.673001,
      1.745506,
      0,
      1.864278,
      1.368876,
      NULL,
      1,
      NULL,
      2,
      3.336437,
      5,
      NULL,
      3.562278,
      NULL,
      1,
      NULL,
      0,
      0.770235,
      1,
      2.289261,
      0.507409,
      1.053103,
      4,
      3,
      0.439375,
      3,
      9.228598,
      0.211864,
      7.162092,
      NULL,
      1.773744,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.299402,
      NULL,
      NULL,
      0,
      0.619516,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.838170,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      2.721645,
      3.218390,
      3.328420,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.345051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.204935,
      2,
      1,
      NULL,
      0,
      NULL,
      0.869642,
      0.050385,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.323843,
      2,
      NULL,
      0,
      3.815505,
      0,
      3.033934,
      2,
      3,
      1.254228,
      0,
      0.215210,
      6.717969,
      1.319756,
      1,
      NULL,
      1.157489,
      0.225016,
      0,
      1.725792,
      1,
      1.762788,
      NULL,
      0.762496,
      0.439386,
      3,
      0,
      0,
      1,
      10,
      1.856502,
      3,
      7.099309,
      6.498173,
      5.766490,
      NULL,
      2.323577,
      3,
      1,
      1.980773,
      NULL,
      3,
      NULL,
      31.594380,
      NULL,
      NULL,
      NULL,
      2,
      3.061059,
      0.939320,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0.177337,
      NULL,
      '',
      '',
      0,
      58,
      6.929912,
      33.458842,
      1.449995,
      25.929876,
      NULL,
      2,
      3,
      3,
      0,
      1.915798,
      0.606974,
      NULL,
      NULL,
      0.012237,
      2,
      1.304351,
      1.800557,
      NULL,
      NULL,
      0.775580,
      3.944459,
      NULL,
      1.702108,
      NULL,
      NULL,
      2.159232,
      0.203174,
      2,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.883722,
      NULL,
      NULL,
      1.862966,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      8,
      3.017982,
      0.335959,
      0.654497,
      NULL,
      NULL,
      NULL,
      1.498215,
      NULL,
      NULL,
      NULL,
      0.287046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.237805,
      NULL,
      NULL,
      1.489268,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.190133,
      3,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2,
      1,
      2,
      3.476189,
      0.847818,
      0,
      NULL,
      NULL,
      2.763973,
      6,
      1.096847,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377938,
      NULL,
      NULL,
      1.070643,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.257176,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      3.130073,
      4,
      2,
      4,
      1.809231,
      2.098051,
      1.490194,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.941113,
      NULL,
      1,
      1.967110,
      NULL,
      6,
      2.344118,
      2.048731,
      1.929117,
      1.708965,
      0.062965,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0.345640,
      0.409523,
      2,
      NULL,
      2,
      2,
      2,
      2,
      1.078681,
      0,
      1,
      0,
      1,
      2.363481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.630113,
      NULL,
      NULL,
      1.341637,
      NULL,
      NULL,
      0.442104,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.479572,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.109997,
      1.226048,
      0.790581,
      0.251596,
      1.049410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738075,
      12.137784,
      NULL,
      NULL,
      0,
      2.525693,
      NULL,
      NULL,
      NULL,
      1.239763,
      NULL,
      NULL,
      2.139008,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.121393,
      NULL,
      NULL,
      NULL,
      1.174205,
      NULL,
      NULL,
      NULL,
      1.771553,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.000278,
      NULL,
      NULL,
      1,
      2.613107,
      NULL,
      NULL,
      2.855841,
      0.418231,
      NULL,
      NULL,
      0,
      0.773484,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.865270,
      0,
      3.325271,
      0,
      0.943975,
      1,
      NULL,
      NULL,
      0.033663,
      NULL,
      NULL,
      NULL,
      4.081759,
      3,
      1,
      NULL,
      NULL,
      1.636846,
      NULL,
      0,
      340.171746,
      6.209964,
      0.842508,
      0.155644,
      1.795737,
      NULL,
      0,
      0.585529,
      NULL,
      1.593610,
      0.647153,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.820474,
      1,
      NULL,
      1.878197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.741787,
      1.010166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.374120,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.324922,
      NULL,
      0.390144,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.556051,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.116585,
      NULL,
      1,
      NULL,
      0.478571,
      0.093667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.821192,
      NULL,
      0.131606,
      NULL,
      NULL,
      NULL,
      0.359299,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      1,
      3,
      2.476527,
      3,
      2,
      3.727504,
      1.998684,
      0,
      0,
      0.837578,
      1,
      0.239798,
      3.835741,
      NULL,
      0.062974,
      0,
      1,
      NULL,
      0,
      1.049495,
      0,
      1.033751,
      NULL,
      1.088439,
      2.050889,
      NULL,
      NULL,
      3,
      0.606706,
      0.860499,
      1.016552,
      0.020392,
      NULL,
      1.745834,
      1.207267,
      0,
      3.914774,
      0,
      1.145255,
      0,
      2.650121,
      1.380211,
      1.015135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.994515,
      1,
      0.222197,
      NULL,
      NULL,
      NULL,
      0.291959,
      NULL,
      2.530530,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.176057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154413,
      NULL,
      1.282210,
      5.713061,
      NULL,
      NULL,
      0,
      1,
      1.586552,
      0,
      0.054376,
      1.148737,
      6,
      0,
      NULL,
      1,
      NULL,
      NULL,
      96.406056,
      23.211038,
      1.851725,
      NULL,
      3.340589,
      '21403',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


