set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7833744';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      NULL,
      3.980886,
      NULL,
      '2230424',
      2.218978,
      1.874774,
      2,
      1,
      '3234',
      0,
      NULL,
      NULL,
      NULL,
      ' 8-17-1994',
      104.462715,
      3,
      NULL,
      NULL,
      NULL,
      ' 1-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      3.899537,
      ' 9-20-2003',
      ' 5- 0-1982',
      ' 9- 5-2002',
      NULL,
      1.411836,
      NULL,
      2,
      1,
      2.865316,
      1.078382,
      2.593439,
      NULL,
      NULL,
      NULL,
      10.341875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.433141,
      NULL,
      1,
      0.269518,
      1.747106,
      NULL,
      1.093905,
      0,
      0,
      1,
      1.493105,
      1.875397,
      13.647214,
      NULL,
      NULL,
      5.796746,
      0.561824,
      NULL,
      1.699880,
      1.897553,
      4.768846,
      0,
      5.856233,
      0,
      NULL,
      2,
      0.074975,
      5,
      0.343444,
      NULL,
      1,
      3,
      NULL,
      3,
      0.170990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137871,
      1.121419,
      1,
      1,
      NULL,
      0,
      2.163197,
      0.473463,
      0,
      0.313849,
      0.405892,
      NULL,
      2.989333,
      1.530534,
      2,
      1.294388,
      3,
      3.115992,
      NULL,
      3.899989,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      1.274720,
      NULL,
      NULL,
      1.886724,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      3.835620,
      6.140107,
      3,
      0,
      0.930672,
      NULL,
      0,
      0,
      4,
      6,
      1.792602,
      0,
      NULL,
      0,
      1,
      NULL,
      0.681090,
      NULL,
      4,
      1.438239,
      NULL,
      1.777122,
      4,
      0,
      5,
      5,
      1,
      2,
      0,
      5.173808,
      NULL,
      8,
      NULL,
      NULL,
      5,
      4,
      6.984292,
      9.879356,
      2,
      7.820186,
      5.212621,
      4,
      0,
      3,
      ' 1- 8-1994',
      NULL,
      ' 9-27-1998',
      1848,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126821,
      1.240919,
      0.758820,
      0,
      1,
      NULL,
      0.905035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867794,
      NULL,
      NULL,
      NULL,
      NULL,
      0.985264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420852,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      1.421302,
      NULL,
      NULL,
      1,
      1.120855,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.930575,
      NULL,
      1,
      NULL,
      0,
      1.893186,
      368,
      1,
      1.693854,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3.795756,
      1,
      2,
      2,
      2,
      NULL,
      0,
      1.768818,
      1.807661,
      3.583715,
      2.564014,
      2,
      2.240392,
      1.880339,
      NULL,
      NULL,
      0.851746,
      1.137055,
      1.902273,
      1.907074,
      1.371043,
      1.986466,
      NULL,
      0.264831,
      0,
      NULL,
      0.537115,
      3.083764,
      1.127189,
      8,
      6,
      3,
      7,
      6,
      1,
      5,
      NULL,
      0.670291,
      2.642808,
      2.793236,
      0.365154,
      31,
      NULL,
      3.544845,
      51.126242,
      NULL,
      34,
      NULL,
      5,
      NULL,
      3.408063,
      '20122',
      '',
      '',
      1,
      '',
      '',
      '',
      2.120131,
      '3132',
      '',
      NULL,
      2,
      11,
      93,
      14,
      NULL,
      20.565418,
      NULL,
      118.150841,
      6.639575,
      0.533328,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.105542,
      NULL,
      1.157819,
      3,
      2,
      1,
      NULL,
      0.141439,
      0.487054,
      NULL,
      NULL,
      3.273215,
      1.633891,
      1.442946,
      2.835254,
      1.705353,
      1,
      0.455696,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      6,
      7,
      4.397485,
      0.952502,
      0,
      NULL,
      NULL,
      NULL,
      1.736791,
      NULL,
      NULL,
      NULL,
      2.479856,
      NULL,
      0.238760,
      0,
      NULL,
      NULL,
      1.803705,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413054,
      3,
      0,
      0,
      3,
      3,
      1,
      0.609630,
      1,
      NULL,
      2.467473,
      1,
      1,
      2,
      1,
      0.668516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.035401,
      0,
      2.146531,
      3,
      3,
      0,
      1.754194,
      NULL,
      NULL,
      NULL,
      1.146404,
      NULL,
      NULL,
      NULL,
      3.903237,
      NULL,
      0.916515,
      0,
      2.333225,
      2,
      3.765310,
      1.227418,
      NULL,
      1.411116,
      NULL,
      NULL,
      5,
      1.146088,
      5,
      0.936907,
      NULL,
      1,
      NULL,
      0,
      0.626352,
      6,
      1.719341,
      2.199768,
      NULL,
      NULL,
      NULL,
      1.737916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126292,
      NULL,
      NULL,
      1.818370,
      2,
      3,
      1.777217,
      5.601531,
      5.667976,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2.942940,
      2,
      0,
      NULL,
      1,
      2,
      0.330162,
      3,
      1,
      3.063270,
      1,
      1,
      NULL,
      NULL,
      2.449344,
      1,
      NULL,
      NULL,
      2,
      1,
      1.580883,
      2.934782,
      2,
      2,
      4,
      0.519426,
      6.300109,
      4,
      1,
      3.911671,
      1,
      2,
      0,
      0.136157,
      NULL,
      NULL,
      1,
      1,
      0.008974,
      NULL,
      NULL,
      1.120039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685076,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.867077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.269142,
      1.213519,
      1.729275,
      NULL,
      NULL,
      0.274927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789517,
      NULL,
      NULL,
      NULL,
      3.567306,
      NULL,
      NULL,
      NULL,
      2.139615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.693415,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      76.026987,
      0.577825,
      NULL,
      NULL,
      0.306598,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.080962,
      124.771611,
      12.437750,
      1.986094,
      1.458725,
      0,
      0.020648,
      1,
      0,
      0,
      1,
      1.315442,
      1,
      1.228230,
      NULL,
      1,
      0,
      NULL,
      1.511403,
      1.429501,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.365181,
      1.816582,
      3,
      11,
      NULL,
      1,
      4,
      3,
      15,
      2.487871,
      0.740128,
      NULL,
      1.817989,
      0.069091,
      NULL,
      1,
      0.726887,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.636863,
      NULL,
      1,
      2,
      NULL,
      0.197099,
      2,
      NULL,
      0,
      3.241190,
      NULL,
      NULL,
      3,
      NULL,
      1.168021,
      1.326959,
      NULL,
      1,
      0.442057,
      NULL,
      0.856280,
      1.126595,
      NULL,
      2,
      NULL,
      0.135656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739463,
      NULL,
      1.597619,
      NULL,
      0.197395,
      NULL,
      7.249258,
      3,
      11,
      2,
      1,
      3.569591,
      38,
      33,
      NULL,
      NULL,
      1,
      '32421',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '');
commit;
end;
/


