set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813899';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '4041021',
      1.492715,
      0.749580,
      0,
      3,
      '4421',
      3,
      NULL,
      5.929531,
      NULL,
      ' 3-10-1977',
      4,
      NULL,
      0,
      0.134785,
      1.760479,
      ' 0-28-1981',
      NULL,
      4.041853,
      56.305840,
      93,
      7,
      NULL,
      NULL,
      ' 6- 2-1999',
      3,
      1,
      1,
      NULL,
      1.342313,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.176378,
      21,
      13.970419,
      3.565109,
      12.815653,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.089147,
      3,
      3.221927,
      NULL,
      NULL,
      NULL,
      1.240614,
      0.351542,
      1,
      0.633677,
      NULL,
      0.129347,
      NULL,
      1.354703,
      NULL,
      1,
      0.642683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501970,
      0.243562,
      1.559806,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.059946,
      1.792208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353037,
      1.646658,
      1.959289,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      4.860754,
      NULL,
      NULL,
      NULL,
      0.814478,
      1,
      0.128994,
      1.561524,
      NULL,
      NULL,
      NULL,
      0.395048,
      0.505708,
      0.682699,
      1,
      0,
      NULL,
      1.230266,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      0.872599,
      1.795640,
      1.581476,
      NULL,
      1.034183,
      0,
      1,
      0,
      NULL,
      1.484973,
      NULL,
      NULL,
      1.598592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.176187,
      1.726103,
      1,
      1.157284,
      0.874317,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944970,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      4.205165,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205301,
      NULL,
      0.183795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184490,
      NULL,
      1.156958,
      1.979106,
      NULL,
      0.093083,
      1,
      1.450627,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.462456,
      2,
      2,
      2,
      0.707239,
      2.632419,
      2.995807,
      2,
      NULL,
      NULL,
      0,
      0.769022,
      1.546779,
      3.520148,
      1.399318,
      4,
      0.782492,
      0.764788,
      0.905056,
      0,
      0.875240,
      2,
      0.093810,
      0,
      NULL,
      2,
      1.747939,
      3.138214,
      0.396738,
      NULL,
      0.156490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      83,
      NULL,
      NULL,
      NULL,
      1.254306,
      0,
      NULL,
      '43222',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.800609,
      0,
      59,
      NULL,
      3.397173,
      27,
      3,
      0.298154,
      2,
      1.196321,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.915540,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.103218,
      NULL,
      NULL,
      1.175752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921240,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.011145,
      NULL,
      NULL,
      0.323279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911590,
      NULL,
      NULL,
      0.980538,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235419,
      NULL,
      NULL,
      0.458728,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.838166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.729701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162859,
      NULL,
      NULL,
      0.436164,
      NULL,
      NULL,
      0,
      1,
      3,
      3.808136,
      0,
      0.323218,
      1.209049,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.160546,
      NULL,
      NULL,
      1.204690,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.846322,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402727,
      NULL,
      NULL,
      1.877103,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.385875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.099498,
      NULL,
      NULL,
      1.545433,
      NULL,
      NULL,
      1.443862,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737080,
      NULL,
      0,
      1.129390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.446928,
      1,
      3.787148,
      0,
      1.844798,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.556538,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.087099,
      NULL,
      NULL,
      NULL,
      1.848631,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.486145,
      NULL,
      NULL,
      NULL,
      1.020403,
      NULL,
      NULL,
      NULL,
      0.476710,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.049465,
      NULL,
      NULL,
      NULL,
      0.739321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      318.201978,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.808889,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14261,
      1503.360105,
      NULL,
      NULL,
      0.645879,
      0,
      0.676126,
      NULL,
      1.369318,
      0,
      1.359448,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1.609206,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      1,
      0,
      3.422430,
      2,
      4,
      1,
      0,
      2,
      0.218956,
      1.419272,
      NULL,
      1,
      0.320063,
      NULL,
      1,
      1,
      0.887932,
      0,
      1,
      0,
      0.934047,
      0,
      1.153900,
      1.093064,
      0.404716,
      1,
      1,
      0,
      1.341086,
      1.937609,
      NULL,
      0,
      NULL,
      1.063353,
      0,
      1,
      0.043497,
      0.260559,
      0,
      1.723815,
      1.687183,
      1.087232,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.453841,
      NULL,
      3.143834,
      3.609918,
      1.850015,
      0.093002,
      1,
      3.923405,
      0,
      NULL,
      1.249443,
      3,
      NULL,
      1.627061,
      0,
      0.989022,
      3,
      1,
      NULL,
      0.876158,
      1.505087,
      1,
      0.665914,
      NULL,
      NULL,
      1,
      1.012459,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.974107,
      0.249712,
      1,
      1.289361,
      7.121046,
      1,
      NULL,
      NULL,
      130.435059,
      59,
      NULL,
      0,
      2.275578,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


