set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9030786';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      0.502428,
      0,
      1,
      2,
      '2432',
      NULL,
      1,
      NULL,
      NULL,
      ' 7-13-2002',
      9.015512,
      NULL,
      5,
      0,
      1.785469,
      ' 7-12-1985',
      NULL,
      5,
      NULL,
      129,
      1,
      ' 5-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.531095,
      1.578620,
      2.553697,
      0.068711,
      1.438634,
      344,
      8,
      7,
      6.502102,
      185.094864,
      109,
      7,
      11,
      0.751837,
      NULL,
      5.263495,
      0,
      0,
      1.573538,
      1,
      1,
      0.663710,
      1,
      NULL,
      1.554800,
      0,
      3,
      5.467356,
      NULL,
      6.333816,
      NULL,
      7.482851,
      4,
      2.002775,
      NULL,
      NULL,
      0.909901,
      5.567453,
      1,
      0,
      1,
      0.526861,
      NULL,
      7.514029,
      0,
      4,
      0.096391,
      1,
      1,
      NULL,
      NULL,
      0.082703,
      NULL,
      NULL,
      NULL,
      1.161918,
      0,
      1,
      0.660121,
      NULL,
      NULL,
      3.418617,
      2,
      3.269913,
      1,
      0.093633,
      0,
      NULL,
      1.993490,
      0,
      1,
      2,
      2,
      NULL,
      1.184790,
      3,
      4.603303,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      0.292237,
      NULL,
      NULL,
      1,
      1,
      8,
      1,
      6.799102,
      5.848049,
      NULL,
      1,
      0,
      0.632172,
      0,
      1,
      0,
      0,
      NULL,
      1.079436,
      NULL,
      0.585300,
      NULL,
      NULL,
      1,
      1.247224,
      4,
      0,
      2.502234,
      4,
      2,
      7,
      3.324934,
      6.230949,
      6.438120,
      7.905959,
      NULL,
      NULL,
      2.924426,
      6,
      2,
      7.286621,
      9.065191,
      4,
      0.983557,
      NULL,
      4.873608,
      11.552491,
      2.839801,
      NULL,
      3.473451,
      1,
      ' 3-16-1994',
      269,
      ' 4-18-1991',
      323,
      2,
      0.992264,
      1,
      7.678359,
      1.376415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.163500,
      0.993953,
      1.592251,
      0.083153,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.533401,
      2,
      NULL,
      1.914791,
      3.077007,
      0,
      NULL,
      NULL,
      NULL,
      0.171867,
      3.700917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.095040,
      NULL,
      1,
      1.708277,
      0.240377,
      NULL,
      2.041515,
      1923,
      0,
      1.791179,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.121259,
      0.989152,
      0.015230,
      NULL,
      NULL,
      NULL,
      0.964781,
      NULL,
      0.055118,
      NULL,
      NULL,
      3,
      1.879830,
      1,
      0,
      0.956408,
      NULL,
      0,
      0.288528,
      1,
      1,
      1.871113,
      1.239277,
      0,
      0,
      0,
      0,
      3,
      0.812549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      28.484717,
      21,
      39,
      2,
      NULL,
      NULL,
      '22312',
      '',
      '',
      0.628029,
      '',
      '',
      '',
      0.503382,
      '',
      '',
      '',
      0.759061,
      NULL,
      255.817892,
      0,
      3,
      13.795868,
      3,
      96.461555,
      4,
      3.976985,
      1,
      3.965005,
      1,
      1.946745,
      1,
      2.537397,
      0,
      1,
      1,
      NULL,
      NULL,
      1.409302,
      NULL,
      NULL,
      1.262479,
      1,
      0.513747,
      3.412425,
      0.548976,
      2.273317,
      1,
      NULL,
      NULL,
      NULL,
      1.479512,
      NULL,
      0.082777,
      1,
      1.271127,
      0,
      NULL,
      NULL,
      1.905035,
      NULL,
      NULL,
      4.107583,
      2.413822,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.171948,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.243321,
      1,
      1,
      1.670241,
      0.545038,
      3.975144,
      NULL,
      2,
      0,
      1,
      3,
      0.262580,
      0,
      1,
      2,
      3,
      0,
      0.652003,
      0,
      0.520703,
      NULL,
      NULL,
      3.151167,
      1,
      0,
      10,
      1,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759745,
      NULL,
      NULL,
      2.956459,
      1,
      0.536381,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      9,
      2,
      4,
      2.433167,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      5.739359,
      4,
      0.208540,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.823177,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.899977,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      7.702438,
      0.095105,
      7.626121,
      0,
      7.751137,
      NULL,
      1,
      0.365716,
      6,
      3.751667,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      2.203912,
      NULL,
      4.027163,
      NULL,
      5,
      0,
      0,
      2.982909,
      3.329470,
      3,
      0,
      1,
      18.273806,
      NULL,
      2.922842,
      3,
      NULL,
      0.228313,
      4,
      2,
      6.506063,
      0.071092,
      NULL,
      0.763378,
      1,
      NULL,
      NULL,
      0.684982,
      1,
      NULL,
      1,
      2.255663,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376794,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.803136,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3.865728,
      1.024812,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.315416,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.405481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592732,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.106271,
      NULL,
      NULL,
      NULL,
      3.424588,
      NULL,
      NULL,
      NULL,
      1.322238,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.456077,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      4.450464,
      NULL,
      3,
      2.982540,
      62.423290,
      NULL,
      0.771431,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.548368,
      NULL,
      NULL,
      0,
      0.109222,
      NULL,
      0.024943,
      NULL,
      NULL,
      1,
      NULL,
      0,
      105,
      34.158701,
      NULL,
      0,
      0,
      1.938888,
      0.717397,
      0,
      0,
      1,
      1.804438,
      1.256214,
      NULL,
      1.421643,
      0.067380,
      0,
      0,
      0.497573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580195,
      NULL,
      0.966511,
      1.504789,
      7.746385,
      4.901084,
      3.737380,
      6.104285,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.228758,
      NULL,
      0,
      NULL,
      NULL,
      0.076786,
      3.333964,
      NULL,
      0.512383,
      1.598170,
      NULL,
      1,
      3.369934,
      NULL,
      0,
      1.290694,
      NULL,
      0,
      NULL,
      NULL,
      1.742533,
      NULL,
      NULL,
      0,
      3.389305,
      NULL,
      0.474729,
      1.312223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.072314,
      NULL,
      0,
      NULL,
      2.811396,
      6,
      6.130220,
      3.572998,
      0,
      1,
      25.991650,
      NULL,
      7,
      NULL,
      NULL,
      '24432',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


