set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '4440433',
      1,
      1,
      NULL,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '10-19-1983',
      28,
      NULL,
      4,
      2.179825,
      3,
      NULL,
      34,
      4.393957,
      NULL,
      NULL,
      3,
      ' 6-23-1992',
      ' 7-21-1983',
      ' 3-15-1978',
      NULL,
      1,
      2.971988,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4.497098,
      5.735672,
      3,
      2,
      34.218774,
      NULL,
      NULL,
      10,
      3.683108,
      0,
      NULL,
      0.560694,
      3.228989,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1.527861,
      1.214595,
      NULL,
      0,
      5,
      0,
      2,
      1.577043,
      0.384021,
      6,
      3,
      1.312629,
      0.447881,
      3.645726,
      NULL,
      6,
      NULL,
      2,
      0,
      0.676634,
      2,
      0.543639,
      5.393094,
      1.366908,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.709466,
      4.285746,
      NULL,
      2,
      NULL,
      0.820204,
      0,
      1,
      0,
      0,
      0,
      1,
      3.413957,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.960122,
      0,
      1.596826,
      7.746408,
      0.132575,
      4,
      0.386519,
      NULL,
      NULL,
      NULL,
      1.867263,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1.570957,
      0.598644,
      NULL,
      1,
      0.160034,
      0.963202,
      1.656744,
      0.041936,
      1.989076,
      1.416186,
      0.395192,
      NULL,
      1.406064,
      NULL,
      0,
      0,
      5,
      1,
      2,
      0,
      3,
      3.554642,
      1.666667,
      NULL,
      1,
      4,
      2.327053,
      1.811489,
      0,
      6.678411,
      3,
      0.486112,
      1,
      2,
      NULL,
      6.994918,
      4,
      0.293463,
      0.760621,
      2,
      ' 4-24-1992',
      NULL,
      ' 2-23-1997',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1,
      NULL,
      2,
      1.200719,
      1.133046,
      0,
      7.633966,
      NULL,
      NULL,
      7,
      2.544075,
      2.268113,
      0.881320,
      0,
      8.934871,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.667955,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908699,
      0,
      NULL,
      NULL,
      1,
      8.514130,
      2,
      1,
      2,
      3,
      1.136515,
      2,
      6.720656,
      0.182892,
      1,
      4.625919,
      2,
      1.688641,
      NULL,
      1.798730,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.189205,
      0.960658,
      1,
      1,
      0.665505,
      1,
      NULL,
      0.746171,
      NULL,
      NULL,
      NULL,
      2.885198,
      NULL,
      0.101265,
      3,
      0,
      0,
      2.881739,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.267613,
      NULL,
      1,
      0.682001,
      1,
      0.858204,
      2,
      1.782420,
      1.841136,
      0,
      NULL,
      1.371139,
      1,
      1.773968,
      1.372015,
      1,
      1,
      1.381948,
      11,
      2.596677,
      7,
      4,
      1,
      7,
      4,
      NULL,
      6.124376,
      0,
      NULL,
      2,
      30,
      1.963838,
      0.183534,
      NULL,
      NULL,
      NULL,
      76,
      5.751524,
      1.276186,
      4,
      '31222',
      '30422',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0.757012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.605663,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0.368560,
      0,
      NULL,
      NULL,
      0.308165,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.136877,
      0,
      1.662300,
      0,
      NULL,
      1.118713,
      0.124074,
      1.525892,
      NULL,
      0,
      1.632677,
      1,
      0.319324,
      1.855577,
      NULL,
      1.835402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.456487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.834623,
      NULL,
      1,
      NULL,
      NULL,
      1.339799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.804823,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.243194,
      NULL,
      3,
      NULL,
      303,
      NULL,
      0.596827,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      17.829961,
      37,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.472226,
      0,
      2.118927,
      1.282953,
      NULL,
      3,
      NULL,
      2.026138,
      1.887164,
      0.960820,
      NULL,
      0.014116,
      NULL,
      0,
      1,
      NULL,
      0,
      1.827783,
      NULL,
      0,
      NULL,
      NULL,
      0.919462,
      2.276149,
      NULL,
      2.789062,
      3,
      NULL,
      NULL,
      2.086101,
      NULL,
      NULL,
      0,
      NULL,
      0.315252,
      1.102237,
      NULL,
      0.350822,
      1,
      NULL,
      0,
      1.363782,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.309063,
      NULL,
      0,
      NULL,
      NULL,
      2,
      4.205893,
      0,
      NULL,
      NULL,
      80.596254,
      NULL,
      3,
      NULL,
      1.521794,
      '01144',
      NULL,
      '22343',
      1.947267,
      '',
      NULL,
      NULL,
      0.339985,
      '',
      '',
      '');
commit;
end;
/


