set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3300441',
      NULL,
      1.923406,
      2,
      2,
      NULL,
      2,
      0.810534,
      NULL,
      NULL,
      ' 8- 6-1997',
      42.115511,
      NULL,
      1.515049,
      3,
      0,
      ' 4-12-1977',
      50,
      1,
      NULL,
      NULL,
      3.335504,
      ' 4- 8-1980',
      ' 9- 1-1993',
      ' 7-13-1983',
      1,
      NULL,
      NULL,
      3.197183,
      NULL,
      2.124750,
      2.155810,
      NULL,
      NULL,
      328,
      9.764310,
      17.265201,
      3.487660,
      21.336837,
      25,
      NULL,
      3.120234,
      1,
      0,
      9.912612,
      0.703783,
      0.963899,
      0.907379,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1.117495,
      7.701640,
      6,
      2,
      0,
      0,
      9,
      1,
      NULL,
      0,
      NULL,
      1.723749,
      0,
      1.197705,
      1.162738,
      0.287164,
      2.644533,
      0,
      1.700802,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.026087,
      NULL,
      NULL,
      5.628724,
      1.440990,
      0.885718,
      3,
      NULL,
      3,
      2,
      NULL,
      3,
      NULL,
      1,
      1.960544,
      0,
      NULL,
      NULL,
      0.932405,
      2.980723,
      NULL,
      NULL,
      0,
      1,
      1.892336,
      4,
      1,
      0.330191,
      0.574000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.445885,
      0,
      3.919988,
      2,
      7,
      0.251307,
      NULL,
      3,
      5.088093,
      1,
      5.944261,
      0.669196,
      2.151906,
      0,
      NULL,
      0.061001,
      0.435694,
      1.492674,
      NULL,
      0,
      NULL,
      NULL,
      6.489869,
      1,
      4,
      5,
      5.608129,
      NULL,
      NULL,
      NULL,
      0.152297,
      0.636836,
      8.466731,
      NULL,
      NULL,
      4,
      5,
      7,
      6.117774,
      0,
      5,
      NULL,
      1.096442,
      3.271466,
      8,
      2,
      2,
      ' 1-15-1994',
      0,
      ' 5-17-1991',
      0,
      0.337019,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673352,
      3.946346,
      NULL,
      NULL,
      NULL,
      3.473069,
      4,
      7.690635,
      1,
      10,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808767,
      0.043842,
      0.617429,
      1.981592,
      1,
      1.850482,
      NULL,
      7,
      2,
      1,
      7.039471,
      0,
      NULL,
      NULL,
      NULL,
      1.666154,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.939075,
      1,
      NULL,
      0.368145,
      NULL,
      NULL,
      41.671790,
      3.187819,
      NULL,
      NULL,
      3.551210,
      NULL,
      1.867585,
      1.324568,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      2.565985,
      1,
      NULL,
      1.702508,
      3.750993,
      NULL,
      1.767800,
      0.827023,
      3,
      1,
      NULL,
      5,
      1,
      0.017480,
      0,
      1,
      0.521896,
      NULL,
      1.472110,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      9.171885,
      NULL,
      NULL,
      7.326424,
      NULL,
      NULL,
      1.721286,
      NULL,
      1,
      0.326922,
      0,
      NULL,
      0,
      0.788441,
      NULL,
      NULL,
      29,
      NULL,
      3.793433,
      0,
      2.924722,
      '33223',
      '',
      '',
      1.521273,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      27,
      444.867087,
      19.179131,
      2,
      NULL,
      NULL,
      89,
      0.592158,
      2.897735,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.165596,
      3.231011,
      0,
      2,
      1,
      1.002383,
      2,
      2.513289,
      3.947889,
      2.494028,
      0.811927,
      NULL,
      2.711553,
      2,
      1,
      1.143826,
      1.702430,
      NULL,
      0,
      NULL,
      NULL,
      1.978842,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.535121,
      NULL,
      NULL,
      5.500266,
      1,
      0.247737,
      1,
      0.694045,
      NULL,
      NULL,
      NULL,
      1.869039,
      NULL,
      NULL,
      NULL,
      3.740066,
      3.824014,
      1.409396,
      0,
      1,
      0.267768,
      0,
      1.501928,
      1.229922,
      NULL,
      2.108395,
      NULL,
      2,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      2,
      NULL,
      1.624497,
      NULL,
      NULL,
      0.293928,
      NULL,
      NULL,
      2,
      2,
      1.080790,
      0.958252,
      0.588105,
      1.721027,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.443844,
      3.252861,
      1.713964,
      NULL,
      2,
      3.805877,
      NULL,
      1.967045,
      2,
      0.579795,
      11,
      2.062479,
      NULL,
      2.292289,
      0.491975,
      0.201303,
      2.246276,
      0,
      1,
      NULL,
      1.794951,
      1,
      1.636407,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.389058,
      NULL,
      NULL,
      0.691862,
      NULL,
      NULL,
      0.006385,
      NULL,
      NULL,
      1.436642,
      NULL,
      NULL,
      0.942531,
      0.614909,
      3,
      0.500552,
      NULL,
      2.512693,
      2,
      0,
      5.720541,
      NULL,
      0.057399,
      2.239796,
      9,
      5,
      NULL,
      1,
      0.431705,
      0.634195,
      2.563555,
      2,
      3,
      3.823975,
      3.922089,
      0,
      6.417839,
      4,
      2,
      0.643307,
      0,
      NULL,
      2.969655,
      3,
      3.951905,
      3.619519,
      2,
      1.379604,
      NULL,
      1.838818,
      1,
      7.859540,
      2.009297,
      2.785391,
      2.885313,
      NULL,
      1.833092,
      3,
      6.415971,
      7,
      0.650233,
      0.036779,
      NULL,
      0,
      1.375209,
      3,
      NULL,
      NULL,
      3.612503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.429260,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.995242,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.947951,
      NULL,
      NULL,
      12.406597,
      NULL,
      NULL,
      NULL,
      1.044408,
      NULL,
      0.911210,
      0,
      1,
      0.769476,
      NULL,
      NULL,
      2,
      2.714587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732475,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.027925,
      1.854924,
      NULL,
      NULL,
      3.433577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.867188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.633090,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.617792,
      NULL,
      NULL,
      0,
      1.512216,
      NULL,
      NULL,
      1.395381,
      NULL,
      NULL,
      NULL,
      1.457034,
      1.736923,
      NULL,
      NULL,
      1,
      0.014459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881625,
      NULL,
      NULL,
      NULL,
      2.682697,
      182.328312,
      247,
      1,
      NULL,
      NULL,
      0.739655,
      NULL,
      NULL,
      0.293883,
      NULL,
      NULL,
      1.501948,
      3.883638,
      23,
      0.632912,
      NULL,
      NULL,
      0,
      NULL,
      1.781983,
      1,
      0.534315,
      0,
      0,
      NULL,
      1,
      1.549761,
      1.562482,
      NULL,
      1.677167,
      1,
      1,
      NULL,
      1,
      0.354341,
      1,
      1.552228,
      1.172898,
      1.150098,
      0.890114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187369,
      0.692773,
      0,
      0,
      0.107160,
      2.483839,
      4.202179,
      1,
      5.246976,
      2.575272,
      0.784923,
      2,
      NULL,
      3,
      NULL,
      0.574760,
      1.917705,
      NULL,
      1.799148,
      0,
      1.670680,
      0.289187,
      0,
      NULL,
      0.601209,
      NULL,
      0,
      1,
      NULL,
      1.514087,
      0,
      2,
      2.902027,
      0.546818,
      0.393730,
      3.827810,
      NULL,
      3.650849,
      1,
      3,
      1,
      3,
      1.548083,
      2.312098,
      0,
      2,
      1.796110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.046602,
      NULL,
      3,
      5.592029,
      NULL,
      NULL,
      0.670868,
      32.913944,
      13.903354,
      5.467633,
      0.890547,
      2.537356,
      '33044',
      '',
      '',
      1.179721,
      '',
      NULL,
      NULL,
      1.980868,
      '',
      '',
      '');
commit;
end;
/


