set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '24',
      3,
      32,
      NULL,
      1,
      0,
      0,
      2,
      NULL,
      4.024823,
      NULL,
      NULL,
      NULL,
      NULL,
      41.236764,
      4,
      NULL,
      0.439392,
      1.524846,
      ' 6-16-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      1.632930,
      ' 6-17-1993',
      NULL,
      ' 3- 1-1984',
      1,
      0,
      0,
      1.074749,
      0,
      2,
      0.197978,
      0.541054,
      1.989708,
      NULL,
      1,
      0.040840,
      1.999010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.776180,
      NULL,
      0.286892,
      1.665090,
      0,
      0,
      1,
      1,
      0.022023,
      2.913285,
      1.840673,
      1.805884,
      0,
      2,
      1,
      7,
      NULL,
      0.286635,
      NULL,
      0.043839,
      0.997904,
      0,
      0.088378,
      1.260410,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232491,
      0.599235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.824048,
      1.893591,
      1.858187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685831,
      1,
      NULL,
      1.514258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.898109,
      1,
      0,
      0,
      1.387883,
      1,
      1.536338,
      0.287222,
      1.851190,
      0.184524,
      1.730552,
      NULL,
      1.236744,
      1,
      NULL,
      1,
      0.257965,
      1,
      2.450088,
      NULL,
      1.207820,
      1,
      1.551350,
      1.616580,
      0.103436,
      1.564160,
      0.254841,
      5.233844,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.614500,
      0,
      1,
      1.346381,
      0.336659,
      1.530943,
      1.093957,
      0.959733,
      NULL,
      1.639189,
      2,
      0.036808,
      NULL,
      NULL,
      0.703077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725208,
      1.199897,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.618965,
      1,
      0.920921,
      NULL,
      NULL,
      NULL,
      0.483038,
      0,
      0.451798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184569,
      0,
      NULL,
      0,
      3,
      1.563715,
      1,
      0.873682,
      13,
      0.153175,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      NULL,
      3,
      0.880756,
      2,
      2,
      3,
      3,
      0,
      2.699451,
      0.024087,
      0.407865,
      1,
      0,
      0,
      1.945178,
      NULL,
      3.601976,
      NULL,
      1.983144,
      0.992005,
      1,
      NULL,
      1.411668,
      0,
      NULL,
      NULL,
      NULL,
      5.860233,
      0.991950,
      7.665974,
      2.135538,
      7,
      10.763768,
      NULL,
      7,
      0,
      2,
      3,
      0.818643,
      2,
      1,
      5,
      NULL,
      1,
      NULL,
      NULL,
      11,
      NULL,
      1,
      1,
      1,
      '12322',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.671153,
      '',
      NULL,
      '',
      2,
      12,
      253,
      25,
      NULL,
      28.915025,
      31.398155,
      12.768426,
      NULL,
      2,
      3.333514,
      1.227737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.512806,
      0,
      3,
      0.021357,
      NULL,
      NULL,
      0.561209,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039877,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.992485,
      0.857555,
      1.867879,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.993810,
      1,
      NULL,
      NULL,
      1.391526,
      NULL,
      0,
      3.628124,
      3.768316,
      NULL,
      3.328143,
      NULL,
      0.661414,
      NULL,
      NULL,
      0.787291,
      1,
      1,
      1,
      NULL,
      0.741317,
      1,
      NULL,
      NULL,
      0.551571,
      NULL,
      NULL,
      0,
      NULL,
      0,
      8.160577,
      NULL,
      2.208175,
      0,
      0.920724,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.449731,
      3.713478,
      3,
      NULL,
      2.761159,
      0,
      NULL,
      3.927175,
      1,
      3.888336,
      0,
      2,
      0.065990,
      1.240860,
      1,
      3,
      1.936373,
      0.305314,
      2.893482,
      2.622824,
      1.862703,
      0,
      NULL,
      1.091278,
      0.127746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.220783,
      NULL,
      NULL,
      1.103317,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.050118,
      1,
      2.989163,
      10.949424,
      1,
      NULL,
      6,
      3,
      6.496091,
      0,
      0.279613,
      1.793397,
      NULL,
      1.013915,
      NULL,
      2.785963,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.891658,
      0.434204,
      3,
      3,
      NULL,
      3.059574,
      2,
      1,
      2,
      1,
      NULL,
      0.147795,
      2,
      1,
      10.765171,
      7,
      4,
      NULL,
      2,
      2.985637,
      1.670552,
      6.074355,
      5,
      2,
      1,
      1.586239,
      1.950270,
      0.274576,
      0.985501,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.291685,
      NULL,
      NULL,
      1.113934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.145748,
      NULL,
      NULL,
      0.198250,
      NULL,
      NULL,
      NULL,
      1,
      1.183613,
      0.429142,
      1.723194,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.809545,
      1,
      NULL,
      NULL,
      1.246654,
      NULL,
      NULL,
      NULL,
      0.143127,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.378849,
      NULL,
      NULL,
      0,
      0.068017,
      NULL,
      NULL,
      NULL,
      1.280650,
      NULL,
      NULL,
      1.805218,
      1,
      NULL,
      NULL,
      1.597041,
      1,
      NULL,
      NULL,
      2.043287,
      NULL,
      NULL,
      NULL,
      0,
      0.788365,
      NULL,
      NULL,
      6,
      4.538680,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.310494,
      NULL,
      NULL,
      0.356818,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      123,
      22.371490,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.609193,
      1.556422,
      1.298764,
      1.431162,
      NULL,
      NULL,
      NULL,
      0,
      0.153713,
      NULL,
      0,
      1.762839,
      1.024948,
      1.502120,
      0.686223,
      0,
      0.969355,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828838,
      0.245932,
      0.225452,
      1.234556,
      2.843546,
      1.131742,
      2.150918,
      NULL,
      5,
      0,
      3.261094,
      1,
      0,
      2.867059,
      0,
      NULL,
      1.145332,
      NULL,
      1.735067,
      NULL,
      1.210183,
      0,
      NULL,
      1.010732,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.645048,
      NULL,
      0.618761,
      0,
      3,
      1,
      2.306806,
      0.921753,
      2,
      3,
      1,
      0,
      0.752101,
      NULL,
      3,
      1.419387,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.074824,
      1.442194,
      1.853383,
      0.479289,
      1.141880,
      3,
      NULL,
      2.762155,
      NULL,
      10,
      1,
      3,
      NULL,
      '34312',
      '',
      '',
      1.706551,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


