set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      2.903525,
      0.912716,
      NULL,
      0,
      '2101',
      3,
      0,
      NULL,
      NULL,
      NULL,
      34.825056,
      NULL,
      NULL,
      0.757527,
      5.911265,
      '11- 5-2003',
      19.855180,
      NULL,
      248.983487,
      113.572530,
      3.818359,
      ' 6-26-1975',
      ' 0-16-1992',
      ' 7-20-1977',
      1.795366,
      2,
      NULL,
      3,
      0,
      NULL,
      2,
      0.043332,
      NULL,
      NULL,
      NULL,
      6.649962,
      NULL,
      14,
      15.452970,
      0.001204,
      19,
      2.988214,
      NULL,
      1,
      0,
      2,
      0,
      1.142653,
      NULL,
      1.776430,
      NULL,
      1,
      1,
      NULL,
      1.202839,
      2,
      3.673218,
      4,
      0.868829,
      6,
      NULL,
      0.993743,
      1.252478,
      1.597180,
      0,
      2.400209,
      NULL,
      0,
      0,
      0.404954,
      NULL,
      3.566897,
      0.487841,
      3.360234,
      1.291772,
      0.796425,
      1,
      NULL,
      NULL,
      1.836026,
      NULL,
      NULL,
      9.796924,
      1,
      0,
      2,
      1,
      NULL,
      3.951968,
      NULL,
      NULL,
      NULL,
      2,
      0.655856,
      0,
      0,
      0.266227,
      1,
      1,
      1.018115,
      0.172975,
      0.481647,
      0,
      0.320247,
      2,
      0.090915,
      0.842915,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159509,
      1.903736,
      0.104814,
      1,
      0.147390,
      3,
      1.186651,
      NULL,
      0.730832,
      3.085578,
      3,
      1,
      0.287849,
      4,
      0,
      NULL,
      0,
      1,
      0.414599,
      NULL,
      1,
      1.525476,
      NULL,
      0,
      NULL,
      0,
      1.889462,
      4,
      0.128652,
      1,
      NULL,
      3,
      0.382994,
      4,
      1,
      0,
      5.810622,
      0.442290,
      5,
      1.758579,
      3,
      2,
      11,
      5,
      1.575632,
      1,
      1,
      NULL,
      ' 7-13-1979',
      36.024895,
      NULL,
      24.744223,
      0.431838,
      1,
      1.580357,
      1,
      1.748443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728433,
      4,
      1,
      NULL,
      1,
      0.946961,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743085,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.238524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.070991,
      0.664365,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.681075,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.797875,
      0.136245,
      NULL,
      1.016292,
      1.832385,
      0,
      1.909373,
      2,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.320632,
      NULL,
      0,
      4.597685,
      NULL,
      3.083754,
      1.093797,
      2.078546,
      5.751744,
      3.459791,
      2.092713,
      2,
      5.682186,
      NULL,
      3.382382,
      2.225305,
      2.341285,
      1.139235,
      1.842886,
      NULL,
      0,
      1,
      0,
      NULL,
      1.755661,
      1.826511,
      0,
      1,
      1.044520,
      1,
      3,
      0.419237,
      4.537800,
      3.086979,
      1,
      6.479757,
      NULL,
      5.797721,
      0.298084,
      0,
      7.013530,
      3.875253,
      NULL,
      1,
      44.679959,
      0.263007,
      3,
      NULL,
      32,
      35.671103,
      29.170501,
      NULL,
      1,
      0.374288,
      '41220',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      19,
      NULL,
      26,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.339826,
      1.366939,
      0,
      1.612937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.077349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      11,
      NULL,
      0.533636,
      0.764542,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.600126,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.711366,
      0.179104,
      3,
      1,
      1.292495,
      1.013363,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1.157713,
      NULL,
      NULL,
      NULL,
      0.309427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      7.660676,
      9,
      1,
      0.165342,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.740493,
      NULL,
      NULL,
      3.960997,
      NULL,
      3,
      3.778300,
      0.940260,
      1.741200,
      NULL,
      NULL,
      NULL,
      3.190181,
      2,
      NULL,
      NULL,
      1.740694,
      1,
      2.332846,
      3,
      NULL,
      NULL,
      NULL,
      0.678692,
      0,
      NULL,
      NULL,
      1.872089,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.940172,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.947436,
      NULL,
      NULL,
      3.195597,
      0,
      0,
      0.098034,
      2,
      1,
      2.871742,
      5.536716,
      0.931021,
      NULL,
      NULL,
      NULL,
      2,
      4.940692,
      4,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.606462,
      2,
      0,
      NULL,
      6,
      0.128105,
      2,
      NULL,
      NULL,
      1,
      1,
      3.426142,
      0,
      1,
      1.553859,
      NULL,
      NULL,
      NULL,
      10.040521,
      NULL,
      5.757033,
      5,
      2.412438,
      NULL,
      NULL,
      2,
      5.267229,
      1.745184,
      0.283969,
      0.405107,
      1,
      1.778598,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.819963,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.907776,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150594,
      NULL,
      NULL,
      0.830349,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.716634,
      1.292652,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794777,
      NULL,
      NULL,
      NULL,
      8.977924,
      NULL,
      NULL,
      NULL,
      1.172062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.762353,
      NULL,
      NULL,
      NULL,
      1.613604,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.883007,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.454431,
      NULL,
      NULL,
      NULL,
      4.316719,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.712334,
      0,
      0,
      1,
      NULL,
      NULL,
      1.938244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237071,
      NULL,
      NULL,
      1.796340,
      NULL,
      NULL,
      0,
      NULL,
      1.369999,
      0.733026,
      0,
      0,
      NULL,
      0.308854,
      0,
      0,
      0.026345,
      0,
      1.139151,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1.165851,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.013966,
      NULL,
      18.127134,
      2.454846,
      0,
      1.526819,
      NULL,
      0,
      NULL,
      0,
      1.456608,
      NULL,
      0.711773,
      1.321427,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.990775,
      NULL,
      3.046960,
      0.066436,
      NULL,
      2,
      3.140555,
      NULL,
      1.246414,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.116087,
      NULL,
      NULL,
      NULL,
      0.292546,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316258,
      NULL,
      1.748936,
      NULL,
      1.705079,
      NULL,
      0.812165,
      5,
      9.482052,
      1,
      NULL,
      NULL,
      86.381347,
      46.847195,
      3.551120,
      NULL,
      NULL,
      '12003',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


