set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      '11',
      35.962157,
      19.047524,
      '0411431',
      3.794227,
      1.357680,
      5,
      NULL,
      '2400',
      2,
      1,
      NULL,
      NULL,
      ' 0- 2-1998',
      35,
      21.589431,
      NULL,
      0.204245,
      1,
      ' 1-18-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 3-16-1986',
      3.055013,
      0.446307,
      2,
      2,
      1,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      4.821585,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.782918,
      NULL,
      1.878155,
      0.315218,
      0,
      NULL,
      1,
      0,
      1.350018,
      NULL,
      0.406899,
      1.022404,
      1.268960,
      NULL,
      0.776458,
      1.888026,
      0.945654,
      NULL,
      1.736132,
      1,
      0.754221,
      1,
      0.871787,
      1.172585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.021185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564728,
      0.018238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948515,
      NULL,
      1,
      0,
      0,
      NULL,
      1.767195,
      0.836894,
      0,
      1,
      5,
      0,
      0,
      3,
      0.981901,
      1.076121,
      0,
      1.912065,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1.581973,
      1.269322,
      NULL,
      0,
      0.196038,
      1,
      0.375310,
      1,
      1,
      0.377899,
      0,
      0,
      0,
      0.106262,
      3.797402,
      4.581123,
      1,
      1,
      2,
      NULL,
      1.398400,
      4.964993,
      0.556337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.564048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082539,
      5.706823,
      1,
      1,
      NULL,
      1.906720,
      1.742719,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.705683,
      1,
      1.134151,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.122860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.634952,
      1.727178,
      1,
      1,
      1.973612,
      1,
      NULL,
      1.457882,
      1.829639,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.866500,
      NULL,
      1.858355,
      NULL,
      0,
      NULL,
      0.883555,
      1.593043,
      0,
      NULL,
      3.132034,
      0,
      2.914087,
      1,
      1.723539,
      0.594191,
      1,
      0,
      1.475445,
      0.513820,
      0.707115,
      1,
      1.649458,
      1,
      0.839267,
      0.333087,
      3,
      1,
      10,
      2,
      3.483480,
      2,
      11.246857,
      4.860255,
      3.120559,
      3,
      5,
      1,
      0,
      3,
      NULL,
      0.613266,
      1,
      64.684834,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1.443126,
      '10243',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      56,
      NULL,
      1.019202,
      NULL,
      NULL,
      0,
      0,
      2.221799,
      2.695113,
      2.600262,
      0,
      NULL,
      NULL,
      1.933812,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.193227,
      3.162132,
      0.134896,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.304311,
      NULL,
      NULL,
      0.758629,
      NULL,
      NULL,
      0.679445,
      NULL,
      NULL,
      10,
      8.137395,
      0.998399,
      1.117777,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.394987,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.096732,
      1,
      0,
      2.490063,
      0.926007,
      NULL,
      2.804232,
      3.822050,
      0.730725,
      NULL,
      2,
      1.752442,
      0,
      3,
      1,
      1.367998,
      NULL,
      NULL,
      NULL,
      1.392799,
      NULL,
      NULL,
      2.505873,
      0.983182,
      2,
      8,
      10.819295,
      NULL,
      0.073408,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427587,
      NULL,
      NULL,
      NULL,
      1.479330,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.879633,
      3.223081,
      0.238970,
      1,
      NULL,
      NULL,
      1,
      0,
      0.088787,
      0.451969,
      NULL,
      NULL,
      3,
      1.110620,
      2,
      5,
      5,
      3,
      1.132044,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.402459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.498515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.537881,
      1,
      5.386226,
      1,
      0.349313,
      2,
      0.263224,
      NULL,
      7.817201,
      0.080361,
      1.728543,
      NULL,
      NULL,
      NULL,
      1.854306,
      0.262110,
      2,
      0.441237,
      NULL,
      NULL,
      5,
      4,
      1,
      3,
      3.705663,
      0,
      1.086790,
      2.835011,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2.575683,
      2.056913,
      5,
      5,
      6,
      2,
      2,
      4,
      2,
      NULL,
      5,
      0.793308,
      0,
      0.055126,
      1.750444,
      1.950022,
      NULL,
      NULL,
      NULL,
      0.285248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.419466,
      NULL,
      NULL,
      1.652299,
      NULL,
      NULL,
      0.542280,
      0.080888,
      1,
      1,
      0,
      2,
      3,
      NULL,
      NULL,
      4,
      1.471058,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      2.333388,
      NULL,
      NULL,
      NULL,
      0.582798,
      NULL,
      NULL,
      NULL,
      1.706408,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0.582405,
      NULL,
      NULL,
      3,
      1.536470,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.699593,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.026233,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      144,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.603736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.269700,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158961,
      5,
      1.019269,
      1.323104,
      0,
      0,
      0.526501,
      NULL,
      0.339863,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.158282,
      0,
      1.094154,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      2.844168,
      5.270448,
      NULL,
      4,
      5,
      7.394143,
      2,
      3.308886,
      NULL,
      1.111800,
      0.288409,
      0,
      0.942797,
      1,
      1,
      1.558599,
      NULL,
      1.948934,
      0,
      1,
      1.542411,
      2.975682,
      0,
      2,
      2,
      NULL,
      3.901843,
      NULL,
      1,
      2,
      1.347003,
      NULL,
      NULL,
      1,
      1,
      1,
      1.905530,
      NULL,
      2.322612,
      0.221686,
      1,
      1.901883,
      0.972891,
      2.147946,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350344,
      1.802390,
      NULL,
      0.052003,
      1.617396,
      1.693328,
      4,
      NULL,
      7,
      3.829493,
      0.071779,
      2.495447,
      97,
      NULL,
      NULL,
      5.265630,
      3.956093,
      '01444',
      '00033',
      '',
      1.569300,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


