set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8500287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.457160,
      0,
      2.560243,
      0.433903,
      2,
      3,
      NULL,
      NULL,
      NULL,
      '13104433',
      NULL,
      NULL,
      '1334411',
      3,
      1.146831,
      NULL,
      NULL,
      NULL,
      2.214391,
      1,
      NULL,
      NULL,
      ' 1-17-2000',
      48.524355,
      40,
      NULL,
      NULL,
      NULL,
      ' 5- 1-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-23-1997',
      ' 9-19-1980',
      ' 1-12-1998',
      NULL,
      3.876183,
      NULL,
      1.269692,
      NULL,
      0.579762,
      3,
      1,
      NULL,
      NULL,
      NULL,
      13.837521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009609,
      NULL,
      0,
      3.615429,
      1,
      NULL,
      1.013762,
      0.082469,
      0.531942,
      3.425493,
      1,
      1.389957,
      1.215568,
      3.813581,
      2,
      2,
      NULL,
      9,
      NULL,
      NULL,
      0.766602,
      NULL,
      1,
      11,
      0.272833,
      NULL,
      0,
      1,
      1.982362,
      0.363275,
      NULL,
      1,
      5.392254,
      4.831309,
      0.005649,
      NULL,
      NULL,
      1.102892,
      NULL,
      NULL,
      2,
      0.716247,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.707984,
      1,
      1.908652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      5,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0.801044,
      0.358422,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.412790,
      1,
      5.823754,
      4.561720,
      NULL,
      2,
      0.747408,
      8.152468,
      NULL,
      1,
      7,
      3,
      NULL,
      4.491845,
      3,
      1.364671,
      7,
      0.266867,
      NULL,
      8,
      0,
      NULL,
      NULL,
      2.655324,
      3,
      9.488598,
      NULL,
      NULL,
      ' 9-23-1979',
      0.709254,
      ' 7-18-1977',
      5,
      1.591899,
      NULL,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616044,
      1.102265,
      6,
      0,
      3,
      5.065980,
      0.978633,
      1.755146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.030548,
      0.660775,
      NULL,
      NULL,
      0.530701,
      NULL,
      NULL,
      NULL,
      0.791971,
      0.112461,
      NULL,
      2.953019,
      5,
      0,
      NULL,
      NULL,
      1,
      4.195571,
      0.436304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.985336,
      NULL,
      1,
      NULL,
      1.993726,
      1.422102,
      0,
      13,
      0.132109,
      0.929608,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3.524336,
      1,
      0,
      NULL,
      1.839018,
      3,
      0.045190,
      3,
      0,
      2.440802,
      0.950702,
      0.482975,
      2.199426,
      3,
      1,
      1.465230,
      NULL,
      0.075788,
      1,
      0,
      1,
      0,
      0,
      1,
      1.154894,
      0,
      1.370609,
      NULL,
      NULL,
      7.130803,
      10.610198,
      NULL,
      5,
      1.548335,
      0.058519,
      2.208683,
      3,
      7,
      2,
      0,
      2,
      56,
      1,
      3.606625,
      16,
      NULL,
      18,
      NULL,
      NULL,
      0,
      4.815943,
      NULL,
      '23103',
      NULL,
      0.990571,
      '',
      NULL,
      '',
      1.897818,
      NULL,
      NULL,
      '',
      NULL,
      11.758241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.352985,
      1,
      1.311107,
      NULL,
      1.423093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.395037,
      NULL,
      NULL,
      1.486996,
      NULL,
      1,
      NULL,
      2.524788,
      0.088853,
      1.832082,
      0,
      1.135116,
      0.502368,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.232712,
      0,
      1.223553,
      0,
      1.990805,
      NULL,
      0.554376,
      1.146478,
      0.486782,
      NULL,
      1.652296,
      NULL,
      0.883320,
      NULL,
      0.662396,
      NULL,
      2.663829,
      NULL,
      1.420316,
      NULL,
      3.668881,
      NULL,
      11.526133,
      NULL,
      0.406990,
      1.996010,
      NULL,
      1.717565,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.876803,
      NULL,
      1.361151,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.639369,
      NULL,
      0.782828,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.626973,
      0.061521,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795394,
      0.769889,
      0,
      NULL,
      1,
      NULL,
      30.865959,
      NULL,
      0.002279,
      NULL,
      0.533483,
      NULL,
      NULL,
      NULL,
      1,
      0,
      22.904202,
      NULL,
      1.191464,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909460,
      0.340060,
      1.301415,
      0,
      1,
      NULL,
      2,
      0.047606,
      NULL,
      0.067709,
      0,
      1,
      1.308676,
      0.355450,
      1.942871,
      3,
      3,
      1.714556,
      1.829452,
      3.301927,
      0,
      3.647682,
      0,
      NULL,
      1,
      NULL,
      1.251841,
      2.609830,
      2.747109,
      1.608278,
      0.113494,
      1,
      NULL,
      3.867157,
      1,
      1.254088,
      0,
      1.706843,
      1,
      0.297323,
      2,
      0.533269,
      1.673677,
      NULL,
      1,
      NULL,
      1.523585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.401784,
      1,
      0.706322,
      0.905031,
      0,
      2.914828,
      0,
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      2.928238,
      5.221246,
      1.594140,
      '2332',
      '02341',
      '02210',
      0.480051,
      NULL,
      '',
      '',
      0.181224,
      '',
      '',
      '');
commit;
end;
/


