set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6403615';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      '24',
      4,
      14.579903,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '3433',
      1.410017,
      1,
      NULL,
      NULL,
      ' 4- 8-1998',
      63.510675,
      1,
      NULL,
      3,
      1.064220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 4-22-1990',
      NULL,
      ' 6-13-1987',
      2,
      1.081664,
      3.474834,
      NULL,
      1,
      0,
      17,
      1.266050,
      1.457046,
      NULL,
      4,
      NULL,
      6.406982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.374899,
      5.625420,
      1.763739,
      1,
      0.195274,
      NULL,
      NULL,
      0.456380,
      NULL,
      NULL,
      1.465557,
      1,
      7,
      2,
      NULL,
      NULL,
      2.214752,
      NULL,
      1,
      0.011134,
      NULL,
      NULL,
      1.403778,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977129,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.706240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764954,
      NULL,
      1,
      1,
      NULL,
      1.683212,
      0.527718,
      NULL,
      NULL,
      0.692338,
      0,
      1,
      0,
      3.576534,
      0,
      1,
      1.170441,
      1.092703,
      5.540515,
      NULL,
      NULL,
      0.345345,
      1,
      NULL,
      1,
      0,
      1.164875,
      NULL,
      0.698767,
      1,
      0,
      NULL,
      1.643989,
      0,
      0,
      0.623123,
      1,
      1.512461,
      0.490060,
      NULL,
      2,
      0,
      0.051191,
      1,
      1,
      NULL,
      1,
      0.518079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.303813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.728246,
      NULL,
      1.148235,
      0,
      1.213791,
      0,
      3.403105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.855414,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.102354,
      0.099400,
      NULL,
      NULL,
      NULL,
      0.358550,
      0.497714,
      0.296953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.059197,
      NULL,
      0.786187,
      1.341727,
      NULL,
      3,
      8.801890,
      1.674305,
      1.051089,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.514805,
      1,
      NULL,
      3.096370,
      0,
      3,
      3,
      3.316637,
      3.468854,
      0.160112,
      3.089976,
      1,
      1.925974,
      1.613917,
      3.594751,
      1,
      0.433339,
      4,
      1,
      0,
      NULL,
      0,
      1.780794,
      0,
      0.929566,
      0.305967,
      0.988373,
      NULL,
      1.022641,
      1.595340,
      1.365814,
      5,
      NULL,
      0.025069,
      8.110310,
      6.833825,
      0.565815,
      0.081670,
      4.713595,
      NULL,
      3.591347,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.329720,
      62,
      1,
      3.486839,
      0.322398,
      '34210',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      17.884027,
      71,
      0,
      3.688105,
      7,
      3,
      37.205386,
      2,
      0.108533,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2.401573,
      3.124341,
      1,
      NULL,
      1,
      0.647611,
      NULL,
      NULL,
      NULL,
      1.074251,
      NULL,
      NULL,
      1,
      3.539741,
      0,
      NULL,
      NULL,
      NULL,
      0.425587,
      NULL,
      NULL,
      0.659111,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489989,
      0.976687,
      1,
      3.575420,
      1.261388,
      1.333277,
      3.481012,
      1.008209,
      0,
      1,
      1.237403,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039207,
      NULL,
      NULL,
      1.057106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      0.182123,
      NULL,
      NULL,
      NULL,
      9,
      9,
      1,
      1,
      3,
      0,
      3.702969,
      NULL,
      0,
      6.270304,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.663772,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.676969,
      NULL,
      0,
      0,
      1.328203,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.528915,
      NULL,
      NULL,
      6,
      0.478574,
      NULL,
      0.872737,
      0.829241,
      0,
      1,
      1.197422,
      0.515807,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      2.449951,
      0,
      0.107229,
      1.705404,
      0,
      1.615285,
      3,
      0,
      0.755760,
      1,
      0,
      0.305297,
      5,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.028921,
      NULL,
      NULL,
      3,
      3,
      3,
      0.300702,
      0.172091,
      NULL,
      NULL,
      NULL,
      32,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.431870,
      NULL,
      NULL,
      1.883682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.313709,
      NULL,
      NULL,
      1.022230,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.247005,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.626359,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3,
      0.407670,
      0,
      NULL,
      0,
      3.369124,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.321772,
      3,
      NULL,
      NULL,
      1.457058,
      2,
      NULL,
      NULL,
      0,
      1.710960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.162545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918830,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.655296,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.324715,
      NULL,
      NULL,
      NULL,
      3,
      0.912346,
      NULL,
      NULL,
      0.518817,
      NULL,
      NULL,
      NULL,
      NULL,
      560.285059,
      NULL,
      3,
      221,
      16.089947,
      1.587413,
      NULL,
      NULL,
      2,
      5,
      0.444731,
      0,
      3,
      2,
      1,
      NULL,
      NULL,
      3.029573,
      5.738292,
      NULL,
      NULL,
      81,
      0,
      1.240505,
      1.254982,
      2.691874,
      NULL,
      0,
      0.205984,
      0,
      0,
      0.237488,
      0,
      2,
      1,
      0.906743,
      NULL,
      0,
      1.453110,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.933033,
      NULL,
      0.360722,
      NULL,
      1.242776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.759315,
      1.994726,
      5.249877,
      1,
      0,
      0,
      1.012824,
      0.424288,
      2,
      1.767882,
      NULL,
      0,
      1.393246,
      0,
      0,
      0,
      1,
      1,
      0.888593,
      NULL,
      0,
      0,
      NULL,
      1.059293,
      NULL,
      1.158359,
      1,
      1.007412,
      2.925013,
      1,
      NULL,
      1,
      1.580885,
      1,
      0.216180,
      1.756029,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1.168627,
      3.943424,
      3.696737,
      NULL,
      0.709530,
      2,
      1.130738,
      2.806777,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1.410441,
      1,
      1.459316,
      1,
      0,
      1.682231,
      1,
      0.055074,
      1,
      NULL,
      1,
      NULL,
      1.706156,
      NULL,
      1.553762,
      0,
      43.656514,
      3,
      NULL,
      2.072668,
      NULL,
      1.687495,
      0.631395,
      3.712255,
      0,
      NULL,
      0,
      NULL,
      1.243670,
      0,
      0,
      0,
      NULL,
      1.032867,
      NULL,
      1.611260,
      1,
      3.165185,
      NULL,
      0.115558,
      1,
      0,
      0.132049,
      0,
      1,
      NULL,
      23.226583,
      1,
      NULL,
      NULL,
      2.359045,
      1,
      NULL,
      1,
      1.511264,
      0,
      NULL,
      4.778369,
      0,
      NULL,
      NULL,
      3.761142,
      8,
      1.260745,
      NULL,
      2,
      '01223',
      '',
      '',
      0.603345,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


