set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1.114060,
      NULL,
      NULL,
      NULL,
      '4404',
      2,
      0.632195,
      NULL,
      NULL,
      NULL,
      52,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      52,
      3,
      3,
      ' 6-19-1988',
      ' 1-12-1976',
      ' 6-11-1982',
      1,
      3,
      2,
      NULL,
      0,
      3.555172,
      0,
      0,
      1,
      3.219708,
      2,
      12,
      9,
      17,
      NULL,
      9,
      6,
      NULL,
      NULL,
      3.414718,
      0,
      5,
      1.317716,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      3,
      2,
      2.878438,
      NULL,
      0.649922,
      1,
      0,
      0,
      2,
      3,
      0.587968,
      2,
      0,
      3.341515,
      1,
      NULL,
      0,
      5.681314,
      NULL,
      2.315232,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.959790,
      0.720350,
      4.109208,
      NULL,
      0,
      1,
      3.541800,
      3,
      1.402721,
      2.114262,
      0.621234,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      0.424445,
      1.408692,
      1,
      2,
      2.789438,
      2,
      1,
      3.167893,
      0.123801,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0.894857,
      0.662880,
      0.139333,
      NULL,
      1,
      1.708833,
      NULL,
      1.548075,
      1,
      1.910679,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.598827,
      1.865220,
      0,
      1,
      3.404180,
      0.181480,
      1.200477,
      NULL,
      3.270177,
      NULL,
      NULL,
      6.649288,
      1,
      1,
      3.267105,
      NULL,
      5,
      3,
      7.713225,
      NULL,
      11.255841,
      NULL,
      NULL,
      3.947055,
      0,
      2.370430,
      NULL,
      203.028748,
      '11- 8-1994',
      NULL,
      NULL,
      1,
      NULL,
      4.289308,
      0.039590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536599,
      2.621377,
      1,
      0.352439,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.650345,
      NULL,
      NULL,
      3.170629,
      2.299619,
      0.252876,
      0,
      0.692963,
      0,
      NULL,
      NULL,
      7,
      1,
      3.356320,
      3.296452,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.183052,
      3,
      0.498654,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      1.012919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      0.026244,
      0.659605,
      2.507105,
      17,
      1.245293,
      1.443294,
      NULL,
      NULL,
      NULL,
      3.810666,
      1,
      NULL,
      1,
      0.051209,
      NULL,
      NULL,
      2,
      3.395883,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.241327,
      3.965548,
      0.566789,
      3,
      0,
      5.798056,
      0,
      1.029903,
      1.086735,
      NULL,
      0,
      NULL,
      1.960877,
      1,
      1,
      2,
      5,
      1.078636,
      2,
      8.380189,
      2,
      NULL,
      11,
      4.862372,
      5,
      3.205060,
      4.845370,
      NULL,
      NULL,
      2.798771,
      NULL,
      2.294459,
      1,
      NULL,
      41,
      NULL,
      65,
      2,
      NULL,
      2,
      '12241',
      '',
      '',
      1.660850,
      '',
      NULL,
      '',
      1.757449,
      '',
      '',
      NULL,
      3,
      31,
      44,
      41,
      2,
      19.769401,
      3.352377,
      NULL,
      5.564222,
      1.658122,
      3.691906,
      3.289341,
      NULL,
      NULL,
      NULL,
      1.979838,
      NULL,
      NULL,
      0.895015,
      NULL,
      NULL,
      0.994774,
      NULL,
      NULL,
      1.762008,
      NULL,
      NULL,
      3,
      2.437882,
      3.321191,
      0,
      NULL,
      NULL,
      2.158953,
      1.614689,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028285,
      NULL,
      NULL,
      3.357440,
      2.011565,
      4,
      1.461389,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.337085,
      NULL,
      NULL,
      1.300616,
      NULL,
      NULL,
      0.082006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.027451,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.122584,
      2.158992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.184258,
      1.823240,
      0.296971,
      0,
      NULL,
      NULL,
      0.979430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276306,
      NULL,
      NULL,
      0.844695,
      3,
      3.787035,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.725027,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      0.564617,
      1.618255,
      3,
      NULL,
      1,
      1.221753,
      NULL,
      5,
      6.985866,
      2.116605,
      0.690717,
      1.284070,
      NULL,
      2,
      2.224253,
      2,
      2.664930,
      3.636680,
      3,
      2,
      NULL,
      2,
      NULL,
      2.983115,
      7.185103,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      0.788103,
      NULL,
      0.071062,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.469362,
      1,
      1.314279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.943196,
      0,
      0.605416,
      3,
      0.206916,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141459,
      NULL,
      NULL,
      1.335318,
      NULL,
      NULL,
      1,
      NULL,
      1.004465,
      56,
      0,
      NULL,
      3.037423,
      NULL,
      1.516134,
      0,
      0,
      0.527788,
      1.268393,
      1.804001,
      NULL,
      1,
      1.228864,
      NULL,
      0.457142,
      0.635242,
      1,
      0.440426,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.427173,
      NULL,
      0.097976,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.366755,
      0,
      2.115233,
      2.756306,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      1,
      NULL,
      0.694050,
      NULL,
      NULL,
      0,
      1.702030,
      NULL,
      3.500852,
      2.179676,
      NULL,
      1,
      0,
      NULL,
      0,
      3.460047,
      NULL,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1.292010,
      1.540458,
      NULL,
      0,
      1.161232,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.133141,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.682679,
      NULL,
      0.319262,
      NULL,
      3.855710,
      NULL,
      0,
      NULL,
      1.012218,
      NULL,
      0,
      NULL,
      11.787505,
      NULL,
      NULL,
      1,
      NULL,
      3.407759,
      NULL,
      1.723648,
      NULL,
      2,
      11,
      0,
      3.164107,
      2,
      0.312185,
      32,
      13,
      1.030750,
      0,
      2.760508,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.417462,
      '',
      '',
      '');
commit;
end;
/


