set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      1.914567,
      0.760103,
      4,
      2,
      '4334',
      0,
      1,
      NULL,
      NULL,
      ' 4- 8-1998',
      NULL,
      NULL,
      0.276414,
      2,
      2,
      ' 6-10-1981',
      1,
      3,
      214,
      61.815389,
      2,
      ' 3-27-2002',
      ' 0-10-1987',
      ' 6- 2-1975',
      1,
      3,
      3,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2.494587,
      5,
      1.664335,
      5,
      11.393917,
      5,
      NULL,
      6.678385,
      NULL,
      NULL,
      0,
      0,
      1.026689,
      1,
      0,
      0.703102,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      6.741035,
      0.189703,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0.625415,
      NULL,
      0.970084,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.271353,
      1.093660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640570,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      3.593435,
      NULL,
      1.497909,
      2.810997,
      1,
      0,
      NULL,
      1.904544,
      1,
      3.036845,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.300621,
      NULL,
      1,
      NULL,
      1.340653,
      2.499827,
      1,
      0,
      1,
      0.029228,
      NULL,
      1.505206,
      NULL,
      2,
      0,
      4.407235,
      5,
      7.015898,
      NULL,
      3.108502,
      1,
      9,
      8,
      NULL,
      NULL,
      5,
      0,
      ' 4-23-1990',
      41,
      ' 2-25-1985',
      40,
      3.328641,
      1.467712,
      3,
      1.821431,
      1.050355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.100939,
      NULL,
      0.601582,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075756,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.229214,
      7.431148,
      0,
      1.941935,
      2,
      NULL,
      1.307723,
      NULL,
      NULL,
      1.043791,
      3,
      1.248500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.855747,
      1.582994,
      0.131344,
      0.264228,
      1.362242,
      1.078703,
      0.027663,
      0,
      19.703357,
      1.644214,
      0.471122,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      1.079256,
      3.563973,
      3,
      0,
      NULL,
      3.025322,
      2.211548,
      1.757049,
      NULL,
      3.509941,
      0,
      3,
      3.113228,
      0.464300,
      NULL,
      0.987435,
      0.425240,
      NULL,
      0,
      0,
      0,
      1,
      1.034790,
      0.424549,
      NULL,
      2,
      1,
      1,
      7.315450,
      6.193167,
      6,
      11.462856,
      8,
      NULL,
      4,
      0,
      2.278978,
      2,
      0,
      2.668910,
      NULL,
      1,
      1.228666,
      NULL,
      19,
      6.874461,
      1,
      1.796236,
      5,
      1.253051,
      '34212',
      '43331',
      '23414',
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      3.778776,
      NULL,
      NULL,
      22,
      2,
      NULL,
      3.480964,
      NULL,
      5.689784,
      1.268226,
      2,
      NULL,
      0.463158,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.538118,
      2,
      NULL,
      1.749904,
      1.837013,
      NULL,
      NULL,
      1.877835,
      3,
      0.228593,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990042,
      NULL,
      NULL,
      0.661677,
      NULL,
      NULL,
      6,
      5.191125,
      0.942368,
      1.347881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592247,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.997402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215460,
      NULL,
      NULL,
      0.002599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488688,
      NULL,
      NULL,
      1.380839,
      1.577375,
      2.322984,
      1,
      NULL,
      NULL,
      1.885395,
      NULL,
      NULL,
      0.011589,
      2.429076,
      NULL,
      NULL,
      1,
      NULL,
      1.442645,
      NULL,
      NULL,
      1.711056,
      1.641454,
      0,
      1.036453,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852302,
      NULL,
      NULL,
      1.449350,
      NULL,
      NULL,
      0.189150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878950,
      1,
      0,
      5,
      4,
      2,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      0.353721,
      2.446472,
      0.818605,
      1.405731,
      3.923023,
      NULL,
      0.566563,
      5,
      0.750428,
      NULL,
      2.348400,
      2,
      2,
      NULL,
      0.965055,
      0.309148,
      3,
      3.394729,
      3,
      2,
      0.043251,
      0.989881,
      NULL,
      NULL,
      4,
      1,
      5.685205,
      4,
      NULL,
      0,
      7.834625,
      1,
      0.174154,
      0,
      1,
      1,
      2.380927,
      NULL,
      NULL,
      1.925090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918007,
      NULL,
      NULL,
      1.700994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.080689,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.969649,
      NULL,
      NULL,
      1.590761,
      NULL,
      1.955404,
      NULL,
      0.259657,
      0.953438,
      0.437105,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.139219,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.219896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.276850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015977,
      NULL,
      NULL,
      0.141604,
      0.082562,
      0,
      1,
      NULL,
      0.130351,
      0.973080,
      NULL,
      NULL,
      1,
      1.787855,
      0.429599,
      1,
      0,
      1,
      NULL,
      1.360930,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.587764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685603,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638487,
      1.231694,
      NULL,
      0,
      NULL,
      1.026169,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.486253,
      NULL,
      NULL,
      NULL,
      0.360540,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      77,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760191,
      0.059634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      115,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.804690,
      NULL,
      3.159296,
      0.708112,
      11.493082,
      NULL,
      0.778245,
      NULL,
      NULL,
      NULL,
      0.691685,
      2.295129,
      NULL,
      5,
      1,
      2.036374,
      1,
      4.713493,
      NULL,
      1.109435,
      NULL,
      0.219960,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.862072,
      NULL,
      1.410743,
      NULL,
      NULL,
      0.110425,
      1.033303,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.003714,
      1.899888,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.072775,
      NULL,
      1,
      NULL,
      0,
      NULL,
      7.071332,
      0,
      0.062566,
      1.114367,
      NULL,
      NULL,
      59,
      130,
      0.987802,
      0.306944,
      3.257380,
      '24303',
      '23102',
      '13213',
      1.864803,
      '',
      '',
      '',
      3.127526,
      '1330',
      '',
      NULL);
commit;
end;
/


