set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41',
      '34',
      10.508290,
      NULL,
      NULL,
      4,
      1.143051,
      0,
      2,
      '0301',
      5,
      NULL,
      NULL,
      NULL,
      ' 4-18-2001',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 6- 6-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 6-23-1998',
      ' 5-26-1978',
      '11-12-1981',
      2.312384,
      1,
      0.843107,
      NULL,
      0.049060,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0.406421,
      0,
      1.639729,
      1.202017,
      0.145631,
      NULL,
      2,
      5.387541,
      2,
      1.997125,
      0.339551,
      1,
      0,
      4.436483,
      NULL,
      0.935359,
      2.000843,
      NULL,
      0,
      7.061529,
      3,
      2.720567,
      8.068296,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718159,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.880321,
      0,
      1,
      1.908040,
      0,
      4,
      0.079562,
      0.778585,
      0.028782,
      0,
      0,
      0.899889,
      3.250088,
      1.534424,
      0,
      0.211798,
      1.532267,
      1.521640,
      NULL,
      NULL,
      3.879038,
      NULL,
      1.164520,
      0,
      NULL,
      5,
      3,
      1,
      0,
      0.166395,
      1.394053,
      NULL,
      1.400259,
      6.428204,
      NULL,
      5,
      1,
      6,
      2,
      5,
      5.678881,
      NULL,
      NULL,
      0,
      3,
      5,
      3,
      NULL,
      80.838342,
      NULL,
      97,
      1.922617,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583161,
      NULL,
      3,
      1,
      1.015168,
      0.667176,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.833323,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      2.595277,
      0,
      NULL,
      NULL,
      1,
      0,
      3.237399,
      1,
      0.751503,
      0.026260,
      NULL,
      1.098828,
      NULL,
      0,
      0,
      NULL,
      3.695344,
      3,
      0.628996,
      1,
      5.175884,
      0.191519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717911,
      NULL,
      1.724558,
      0.528195,
      0,
      0,
      NULL,
      3,
      2.899283,
      1.626380,
      NULL,
      NULL,
      NULL,
      NULL,
      2.233192,
      NULL,
      2.711649,
      2,
      3.566325,
      0.759385,
      0.009343,
      1.023163,
      1,
      3.796041,
      1.728163,
      0.131531,
      3.291976,
      NULL,
      3.612555,
      3.362168,
      2.079522,
      1.988978,
      NULL,
      0.569778,
      1,
      1,
      NULL,
      1,
      1,
      0.532634,
      0,
      1.064404,
      1.688872,
      0.200533,
      1,
      0,
      9.758224,
      3,
      6.072154,
      6,
      4,
      5.617252,
      0.047624,
      NULL,
      0.586558,
      NULL,
      0,
      3.143103,
      50,
      NULL,
      0,
      NULL,
      NULL,
      64.835765,
      69,
      0,
      3.501939,
      4,
      '02031',
      '40031',
      '',
      NULL,
      NULL,
      '',
      '',
      1.747287,
      NULL,
      '',
      NULL,
      1.224963,
      32.626825,
      113,
      7.112301,
      0,
      29.066913,
      0,
      0,
      2,
      2.266960,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707947,
      NULL,
      NULL,
      1.059679,
      0.719548,
      1,
      3,
      NULL,
      0,
      1.495660,
      NULL,
      NULL,
      2.080406,
      NULL,
      1.202444,
      1.672827,
      NULL,
      NULL,
      NULL,
      2,
      2.305694,
      1,
      NULL,
      NULL,
      1.017644,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11,
      3,
      NULL,
      0.146288,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.621201,
      NULL,
      NULL,
      1.698917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.937692,
      NULL,
      NULL,
      3.692339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.704415,
      3,
      2,
      1.741108,
      NULL,
      NULL,
      0.568487,
      NULL,
      NULL,
      0.691464,
      2,
      3.169697,
      2,
      0.066816,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.340804,
      1.817105,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.904014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973197,
      NULL,
      NULL,
      1,
      3.157406,
      2,
      2,
      5,
      5.216751,
      1,
      NULL,
      NULL,
      2.993009,
      NULL,
      5,
      NULL,
      2.081716,
      1.195324,
      2,
      1,
      NULL,
      3,
      2.990274,
      3,
      6,
      4.461175,
      4,
      0.874761,
      0.910506,
      0,
      2,
      NULL,
      3.509276,
      2,
      3,
      2,
      NULL,
      0,
      0,
      3,
      4,
      0,
      5.273310,
      0,
      1.548511,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.366561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632141,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.438348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.581772,
      1.525532,
      0.819899,
      1,
      2,
      1,
      NULL,
      NULL,
      1.274833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.954896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.335300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.060716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.303955,
      NULL,
      NULL,
      174.436200,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334392,
      NULL,
      NULL,
      1.546406,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.461422,
      NULL,
      1,
      29.475737,
      2478,
      1.652357,
      3.633563,
      0.615252,
      0,
      1,
      1,
      NULL,
      1,
      1.407087,
      NULL,
      NULL,
      0,
      0,
      0,
      0.536513,
      1,
      0.890100,
      3,
      NULL,
      1.613004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.813389,
      NULL,
      2.703311,
      43,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654507,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.125742,
      NULL,
      0.859091,
      NULL,
      0,
      0,
      1.651826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154233,
      1.590066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748120,
      0.243913,
      NULL,
      0,
      NULL,
      1.805965,
      NULL,
      NULL,
      NULL,
      0.096229,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.063496,
      NULL,
      1,
      NULL,
      0.377137,
      NULL,
      66,
      NULL,
      2.069477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967653,
      NULL,
      1.072070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.393307,
      3.930782,
      NULL,
      NULL,
      NULL,
      352,
      NULL,
      2.318662,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9.122751,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.630561,
      NULL,
      1,
      5.032000,
      0,
      2.798350,
      3.481539,
      NULL,
      0.790840,
      1.084712,
      NULL,
      1.866474,
      1.375877,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0.050680,
      NULL,
      0,
      0,
      NULL,
      0.377533,
      0.037706,
      NULL,
      1.596992,
      1.285206,
      NULL,
      0.640287,
      0,
      NULL,
      NULL,
      1.602717,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.280601,
      NULL,
      0.666158,
      NULL,
      0,
      NULL,
      4.666727,
      5.384279,
      2,
      NULL,
      NULL,
      NULL,
      61,
      58,
      2,
      1,
      7,
      '34201',
      NULL,
      '23022',
      1,
      NULL,
      '',
      NULL,
      1.403701,
      '1031',
      '',
      NULL);
commit;
end;
/


