set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8828277';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '2344400',
      NULL,
      0.175166,
      3,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      ' 7-13-1987',
      30,
      NULL,
      0,
      2.426232,
      12,
      '10-21-1980',
      NULL,
      3.090834,
      193,
      148.815120,
      0,
      '10-18-1992',
      ' 1-18-1986',
      ' 0-15-1987',
      0.827311,
      3,
      2,
      1,
      0,
      3,
      1,
      1.963615,
      NULL,
      NULL,
      NULL,
      NULL,
      11.203619,
      5,
      92.222414,
      9.737347,
      5.781238,
      0,
      0,
      0,
      NULL,
      1.858868,
      0,
      0,
      1,
      1.390411,
      0,
      NULL,
      1.797498,
      0,
      139,
      NULL,
      7.522527,
      4,
      2,
      NULL,
      0.313709,
      1,
      NULL,
      3,
      1.184165,
      6,
      0,
      1.188499,
      2.029734,
      NULL,
      1,
      NULL,
      NULL,
      1.786774,
      1.264414,
      0.134765,
      NULL,
      NULL,
      NULL,
      1.148099,
      NULL,
      NULL,
      0,
      1.508157,
      7.899600,
      NULL,
      0.764294,
      NULL,
      2.534205,
      3,
      1,
      1.218110,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.636213,
      1.461624,
      8.900559,
      5.092533,
      1.156952,
      NULL,
      0.274202,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.706061,
      NULL,
      1.806826,
      3.523292,
      NULL,
      4,
      0.776224,
      1.989483,
      NULL,
      0,
      0.612359,
      0.795234,
      4.405528,
      1,
      NULL,
      0.796933,
      0.351418,
      1.258358,
      NULL,
      1.386409,
      4.904685,
      1.423754,
      NULL,
      NULL,
      1.103077,
      7.382488,
      7,
      0.616650,
      3,
      4,
      0.862860,
      3.259294,
      7,
      NULL,
      2.647512,
      0,
      4.881751,
      1.814723,
      5,
      1.420448,
      6,
      3,
      7.558656,
      2,
      1,
      NULL,
      3.900743,
      '11- 3-1982',
      473.314997,
      ' 8-27-1978',
      185,
      0,
      0,
      3.980045,
      7.854426,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680334,
      1.900095,
      0.162106,
      1.879317,
      NULL,
      NULL,
      1,
      1.795777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002767,
      NULL,
      919.650799,
      3,
      0,
      1.214844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      3.163891,
      3,
      3,
      7,
      0,
      0,
      0.334126,
      0.471487,
      5.062230,
      3.975946,
      1,
      NULL,
      NULL,
      0.051511,
      3.124246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155746,
      NULL,
      1.659693,
      1,
      2,
      1.596517,
      NULL,
      NULL,
      30,
      2.865807,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016546,
      3.985199,
      0,
      3.642700,
      2.696585,
      2.118308,
      3,
      2.091207,
      NULL,
      0,
      0.877687,
      NULL,
      2.997229,
      17.434392,
      5,
      0,
      112.312805,
      109.071579,
      190,
      101,
      175.177217,
      NULL,
      0.341954,
      0,
      0,
      1.438376,
      0.411862,
      NULL,
      1.336963,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959613,
      NULL,
      NULL,
      NULL,
      28.160508,
      6,
      0,
      4,
      '21040',
      '1200',
      '',
      0.809943,
      '20111',
      '',
      '',
      1.526416,
      '',
      '',
      '',
      1.830021,
      7.439429,
      NULL,
      NULL,
      0,
      2,
      0.473378,
      7,
      5,
      3.790329,
      2.911486,
      NULL,
      0.170494,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.275224,
      2.915829,
      3.778137,
      1,
      2,
      NULL,
      2,
      1.783417,
      3,
      7.733520,
      NULL,
      NULL,
      9.518612,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.446760,
      NULL,
      NULL,
      3,
      1.044787,
      1.946743,
      1.514100,
      1.977939,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.445546,
      0,
      4.698165,
      12.398685,
      NULL,
      NULL,
      18.228895,
      NULL,
      NULL,
      0,
      0.640698,
      1.395909,
      3,
      NULL,
      NULL,
      NULL,
      2.511085,
      1.408056,
      2,
      0,
      1.646386,
      1.917312,
      NULL,
      NULL,
      0.131709,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      17.249132,
      NULL,
      NULL,
      2.618923,
      0.709507,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3.291500,
      9.662528,
      15.561233,
      0.730253,
      NULL,
      NULL,
      NULL,
      3.554596,
      2,
      2,
      15,
      14.536010,
      0,
      NULL,
      NULL,
      1,
      1,
      2.098389,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770133,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.101897,
      NULL,
      NULL,
      1.685934,
      4,
      NULL,
      0,
      13.676540,
      12.718096,
      6.986893,
      2.258996,
      1,
      1.447719,
      3,
      2,
      0.383977,
      NULL,
      NULL,
      0.749546,
      NULL,
      NULL,
      2.048255,
      19,
      NULL,
      0.862653,
      2.638127,
      2,
      4.390440,
      3,
      2,
      0,
      16.756749,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      13.180693,
      0.510173,
      2,
      3,
      0,
      9,
      3,
      1.589960,
      5,
      3,
      1.820442,
      3.596911,
      1,
      NULL,
      NULL,
      0,
      0.944425,
      NULL,
      1,
      3,
      NULL,
      NULL,
      2.337707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549807,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0.748905,
      NULL,
      NULL,
      2,
      1.666100,
      0,
      NULL,
      0.234110,
      0.710890,
      0,
      NULL,
      NULL,
      7.996728,
      NULL,
      NULL,
      NULL,
      542.746525,
      NULL,
      NULL,
      NULL,
      1.837123,
      NULL,
      NULL,
      NULL,
      1.525614,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.141542,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.340585,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.749432,
      7.461222,
      1.847168,
      1247,
      1567,
      3,
      1828.300214,
      656,
      1.159082,
      NULL,
      NULL,
      0.089170,
      NULL,
      NULL,
      NULL,
      606.982795,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1391,
      1.115955,
      15265,
      NULL,
      0,
      NULL,
      0.552200,
      NULL,
      0.061858,
      0.154990,
      NULL,
      NULL,
      0.351258,
      1.368336,
      0.137180,
      1,
      1.921575,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.980514,
      1.424173,
      0.065850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024365,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.392391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.086347,
      NULL,
      1.469321,
      0.934122,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.872665,
      0,
      1.995758,
      0.554279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904236,
      5,
      0.586936,
      11,
      0.475033,
      2,
      NULL,
      2,
      2,
      0.385405,
      0,
      1,
      1.224144,
      1.134833,
      NULL,
      0.485747,
      1.928498,
      NULL,
      0,
      3,
      NULL,
      0,
      1.410660,
      NULL,
      0,
      2,
      NULL,
      3.895705,
      NULL,
      NULL,
      1.046450,
      NULL,
      NULL,
      1,
      0.295978,
      NULL,
      0,
      0,
      NULL,
      1.180441,
      3.316667,
      NULL,
      1,
      1.693691,
      NULL,
      3.474079,
      1.975205,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234902,
      NULL,
      NULL,
      NULL,
      1.424779,
      NULL,
      1.158086,
      1.241036,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.621068,
      NULL,
      '3403',
      '',
      3,
      '34313',
      '',
      '',
      0.148058,
      '',
      '',
      '');
commit;
end;
/


