set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '2411241',
      2.431186,
      1,
      4,
      3,
      '0301',
      0.225738,
      0.590217,
      NULL,
      NULL,
      ' 0- 2-1984',
      54.014919,
      NULL,
      4,
      1,
      0.329892,
      '11-18-1978',
      14,
      3.684007,
      170,
      93,
      2,
      ' 9-28-1989',
      ' 4- 7-1999',
      ' 2- 7-1989',
      0.923603,
      1,
      NULL,
      NULL,
      0,
      1,
      2,
      2.180636,
      NULL,
      NULL,
      NULL,
      9.384729,
      0,
      2.769579,
      21,
      1,
      6,
      7,
      5.612168,
      6,
      0,
      1,
      0,
      1.895548,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.436066,
      NULL,
      1,
      3,
      4,
      1.551254,
      2.283735,
      1.028134,
      1,
      0.181095,
      NULL,
      1.344916,
      NULL,
      1.323963,
      NULL,
      0.956314,
      1,
      0.742817,
      3.491719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465771,
      1.089158,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      7.294783,
      NULL,
      5.599843,
      0,
      1.788620,
      1,
      1,
      2,
      1.749952,
      0,
      2.174396,
      1,
      1.751685,
      1,
      0.784705,
      NULL,
      NULL,
      1,
      3,
      5.042820,
      0,
      0.059837,
      4.592543,
      1,
      3.955357,
      1.988055,
      6.900518,
      9.655424,
      2,
      5.753331,
      6,
      2.631968,
      4,
      NULL,
      NULL,
      2,
      5.259875,
      0,
      6,
      2.581007,
      4,
      5.331811,
      4.297329,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      0.050907,
      1,
      1.676900,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5.864368,
      1.716865,
      1,
      NULL,
      0.570277,
      NULL,
      NULL,
      NULL,
      0.768395,
      1.616507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.391366,
      1,
      0,
      0,
      0,
      8,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.765823,
      0,
      3,
      0.670313,
      1.159405,
      0.878196,
      NULL,
      NULL,
      3,
      2,
      0.215379,
      NULL,
      1.072654,
      NULL,
      18.662842,
      0,
      0,
      1,
      0.011056,
      3,
      0.630987,
      1,
      1.595313,
      0,
      0.193815,
      1.152474,
      NULL,
      0.405993,
      0.895181,
      2,
      10.585358,
      1,
      4,
      NULL,
      6,
      6,
      NULL,
      2,
      NULL,
      0,
      4.796115,
      NULL,
      1,
      3,
      23.006976,
      NULL,
      1.434873,
      NULL,
      34.125160,
      28,
      41.934389,
      4.806681,
      NULL,
      3.925527,
      '30244',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      0.923115,
      8.947364,
      14.912739,
      15,
      0,
      NULL,
      2,
      0,
      1.236034,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.414375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512102,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.553810,
      NULL,
      1,
      NULL,
      NULL,
      0.425398,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.634178,
      1.809778,
      0,
      1.657755,
      0.845252,
      NULL,
      NULL,
      NULL,
      1.819919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.076908,
      NULL,
      1.003569,
      1,
      2,
      0.313068,
      0,
      0.017207,
      NULL,
      NULL,
      1.281781,
      0,
      3.267538,
      0.660994,
      NULL,
      0,
      3.706726,
      NULL,
      0.268396,
      1.150230,
      1.902203,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.540416,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.252873,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.091203,
      0,
      0,
      0.392574,
      2,
      0,
      3,
      1.229927,
      NULL,
      4,
      4.725143,
      3.915345,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1.352998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528391,
      NULL,
      NULL,
      1.157754,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.125990,
      NULL,
      NULL,
      2,
      0,
      0.962314,
      2.248032,
      1,
      0.112547,
      NULL,
      0.531506,
      0.337086,
      1,
      1.058885,
      0,
      NULL,
      NULL,
      NULL,
      1.970277,
      3.222594,
      1.905826,
      NULL,
      1.573847,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.350191,
      1.307282,
      1.991500,
      1.577745,
      1,
      1,
      NULL,
      0.288126,
      0,
      1,
      0.023594,
      0,
      NULL,
      0.650692,
      1,
      4,
      2,
      4.848596,
      0,
      2,
      7.099206,
      0.622030,
      NULL,
      0.031128,
      1,
      NULL,
      2.969268,
      NULL,
      NULL,
      3.678927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.495578,
      NULL,
      NULL,
      1.638461,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.377221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165016,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.757940,
      1,
      1,
      NULL,
      0.745412,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.822556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058898,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.384685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474913,
      NULL,
      NULL,
      0.486033,
      1,
      NULL,
      NULL,
      1.503034,
      3.013885,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.270100,
      1,
      NULL,
      NULL,
      NULL,
      2.796361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.259725,
      1,
      NULL,
      NULL,
      0.698304,
      NULL,
      NULL,
      NULL,
      2.699275,
      NULL,
      5,
      2.911508,
      13,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.738089,
      NULL,
      NULL,
      1,
      NULL,
      1.610263,
      280.466464,
      NULL,
      0,
      0.377683,
      1,
      1.904078,
      0.107308,
      1.646382,
      1,
      NULL,
      NULL,
      0,
      0,
      1.660284,
      1.821557,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.572007,
      3,
      NULL,
      3,
      1,
      4,
      0,
      NULL,
      2.265810,
      1,
      2.830486,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      3.299156,
      1,
      NULL,
      1,
      0,
      NULL,
      3,
      1.462828,
      1,
      3.354438,
      3.130303,
      0,
      NULL,
      0,
      NULL,
      2.863338,
      NULL,
      NULL,
      3.901024,
      1,
      NULL,
      NULL,
      1.901552,
      2.749350,
      3,
      0,
      1.101040,
      3.332200,
      0.471575,
      0.409303,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.275080,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.203946,
      NULL,
      1,
      NULL,
      1.008559,
      NULL,
      7.855523,
      NULL,
      0,
      0.057737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.853367,
      1,
      0,
      0,
      0,
      3.837268,
      0.174901,
      1,
      2,
      3,
      NULL,
      16.229470,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


