set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215884';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      2.575579,
      0,
      3,
      NULL,
      3.440660,
      NULL,
      '331',
      '33413111',
      74,
      NULL,
      '2030004',
      3.480088,
      0.960489,
      2,
      2,
      '1120',
      0.609386,
      1,
      NULL,
      NULL,
      '11-15-1985',
      168,
      114,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.754992,
      '11-27-1999',
      ' 2-22-1997',
      ' 5- 8-2000',
      1.710117,
      2,
      1,
      3.897828,
      1,
      NULL,
      1.181286,
      NULL,
      1,
      0,
      0,
      11,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928580,
      6.973609,
      2,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1.948285,
      NULL,
      0.031838,
      1.155018,
      3.502743,
      1.496341,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.926703,
      0,
      1.938426,
      2.573250,
      NULL,
      0,
      2,
      1,
      1.267497,
      0.538104,
      0,
      0,
      1,
      3.167972,
      1.867067,
      0,
      0,
      1.408092,
      NULL,
      1.678332,
      1.517283,
      0.784074,
      2,
      0.807790,
      0,
      3,
      1.998729,
      NULL,
      NULL,
      0.104621,
      NULL,
      NULL,
      1.215015,
      NULL,
      1.594548,
      1,
      0.619930,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262169,
      NULL,
      0,
      1,
      1.155044,
      NULL,
      1.091536,
      NULL,
      NULL,
      1.404180,
      0.272585,
      0,
      1.150672,
      1.549536,
      1.917803,
      1.247069,
      3,
      0,
      NULL,
      NULL,
      0.409039,
      0,
      4,
      1,
      5.582268,
      1.226691,
      NULL,
      2.745352,
      3,
      2.246516,
      7.228772,
      3.573212,
      NULL,
      0,
      0.939758,
      1.095823,
      2.995465,
      NULL,
      182,
      ' 3-27-1986',
      NULL,
      3,
      1,
      1.205234,
      0,
      0.448024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316954,
      0.736601,
      0.633692,
      NULL,
      0.456374,
      0.736615,
      0.898505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.610270,
      NULL,
      7,
      1.010981,
      1,
      NULL,
      1.967751,
      0.596574,
      2,
      3.454873,
      NULL,
      5.665414,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.450052,
      0,
      1,
      9,
      NULL,
      NULL,
      0.919361,
      NULL,
      NULL,
      NULL,
      0.281354,
      4,
      0.388491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.987254,
      NULL,
      0,
      NULL,
      1.820154,
      NULL,
      5,
      2,
      1.969716,
      NULL,
      NULL,
      NULL,
      3.448920,
      1.102059,
      1.966685,
      3.936634,
      NULL,
      1,
      2,
      2.087116,
      0,
      2.176615,
      0.141050,
      NULL,
      0.339176,
      2.053851,
      NULL,
      1.698538,
      NULL,
      0,
      1.401900,
      3.446195,
      1,
      1.386998,
      1.086317,
      0,
      NULL,
      0,
      1,
      0,
      2.340554,
      1.632534,
      NULL,
      1,
      0.698542,
      2.203251,
      2,
      1.411255,
      8.886548,
      5,
      NULL,
      NULL,
      0.429703,
      0,
      NULL,
      NULL,
      6,
      3.280833,
      2.679987,
      8,
      NULL,
      3.601697,
      1.689590,
      NULL,
      NULL,
      1,
      '32411',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.224368,
      '44241',
      '2000',
      '3040',
      1.296110,
      3.498174,
      109,
      43.142386,
      2.174157,
      5,
      3.256292,
      3.083365,
      4,
      1.238371,
      3,
      2.133051,
      0,
      NULL,
      NULL,
      1.297846,
      NULL,
      NULL,
      0.484416,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.622569,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1.096099,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10,
      NULL,
      7,
      1.412243,
      0.254494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.504423,
      0,
      1.704621,
      0,
      NULL,
      NULL,
      1.780126,
      NULL,
      NULL,
      NULL,
      0,
      1.162504,
      NULL,
      0.186964,
      1,
      3.363731,
      1,
      1.254438,
      NULL,
      2.206040,
      1,
      0,
      0.639975,
      1.420528,
      0,
      1,
      NULL,
      NULL,
      0.745493,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.377245,
      NULL,
      NULL,
      NULL,
      1.721590,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      7.550805,
      1,
      0,
      0,
      3,
      1,
      0.677972,
      NULL,
      NULL,
      7.007311,
      3,
      1,
      0.535379,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.637629,
      NULL,
      NULL,
      0.410838,
      NULL,
      NULL,
      1.716044,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.031714,
      NULL,
      NULL,
      NULL,
      5.505397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.108035,
      1.702256,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      7.671567,
      7.859937,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      3,
      0.830662,
      1.701312,
      1,
      0.318235,
      3.791222,
      3,
      2.560695,
      NULL,
      2.429793,
      0,
      NULL,
      NULL,
      1,
      3.724384,
      0.823517,
      0.730659,
      0,
      1.410038,
      1.378246,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011701,
      NULL,
      NULL,
      1.685521,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.448640,
      NULL,
      NULL,
      0,
      0.150100,
      NULL,
      1.997689,
      0.929482,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.857014,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.860595,
      NULL,
      NULL,
      NULL,
      1.899541,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.242832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.014246,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.095395,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      12,
      13,
      0,
      49.653619,
      0,
      0,
      NULL,
      NULL,
      2.008969,
      78,
      11,
      0,
      4,
      2.757624,
      0.639197,
      NULL,
      NULL,
      0,
      NULL,
      0.619445,
      5.251851,
      NULL,
      0,
      1.709110,
      NULL,
      0,
      1.651040,
      1.192938,
      0.380753,
      3.592976,
      1.065299,
      0,
      1.451669,
      3.256590,
      NULL,
      2.827820,
      1.541551,
      1.438614,
      1,
      NULL,
      NULL,
      2.355230,
      NULL,
      2.263065,
      NULL,
      2.862198,
      NULL,
      3.438645,
      NULL,
      2.475390,
      NULL,
      15,
      NULL,
      3,
      3.273049,
      NULL,
      NULL,
      NULL,
      2.462516,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.057724,
      NULL,
      NULL,
      NULL,
      0.114551,
      NULL,
      NULL,
      NULL,
      3.990004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221210,
      NULL,
      NULL,
      NULL,
      0.637516,
      NULL,
      1,
      NULL,
      0,
      1,
      1.901396,
      0.289308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.855597,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.805092,
      1,
      NULL,
      0.803366,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.378263,
      NULL,
      0.371571,
      NULL,
      0,
      NULL,
      1.687146,
      1.357237,
      0,
      NULL,
      1.336621,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.656077,
      1.334897,
      NULL,
      NULL,
      0,
      NULL,
      1.853913,
      NULL,
      NULL,
      NULL,
      0.527929,
      NULL,
      NULL,
      0,
      1,
      0.370358,
      1.860951,
      NULL,
      NULL,
      0.167980,
      0.906584,
      NULL,
      0.979428,
      0,
      1,
      0.028319,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003540,
      0.396024,
      0,
      1,
      3,
      NULL,
      0,
      3,
      NULL,
      2,
      1,
      0.659715,
      0,
      0.306864,
      NULL,
      1.021746,
      NULL,
      NULL,
      0.035284,
      NULL,
      NULL,
      0.978412,
      1.086352,
      NULL,
      NULL,
      1.579783,
      NULL,
      NULL,
      0.732081,
      NULL,
      1.795036,
      2.515967,
      NULL,
      1.909166,
      1.621281,
      NULL,
      1.698277,
      0,
      NULL,
      1.962444,
      NULL,
      NULL,
      1,
      3.590547,
      NULL,
      2,
      0.979668,
      1.347016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2.667722,
      4.116783,
      1.444527,
      1.113801,
      0.235930,
      80.447359,
      80.943574,
      1,
      1.042913,
      3,
      NULL,
      '44100',
      '',
      0.479161,
      '',
      '',
      NULL,
      3,
      '01420',
      '4312',
      '2200');
commit;
end;
/


