set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8330912';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      1.570574,
      1,
      NULL,
      '3444',
      3.317197,
      1,
      NULL,
      NULL,
      ' 4- 2-2003',
      32,
      NULL,
      2.406631,
      0,
      1,
      '11-18-1994',
      25,
      1,
      307,
      84,
      1.109697,
      ' 5- 0-1998',
      ' 2-29-1990',
      ' 7- 7-1986',
      0,
      1,
      2.231845,
      2,
      3,
      0,
      1,
      1.564699,
      0,
      10,
      1.538738,
      1,
      0,
      6.659778,
      NULL,
      NULL,
      12,
      1.237514,
      NULL,
      NULL,
      NULL,
      3.508225,
      1.380918,
      1,
      0,
      1,
      1,
      0,
      1.210317,
      NULL,
      NULL,
      1,
      2,
      3.833793,
      3.480585,
      4.063214,
      3.510061,
      0,
      1.270754,
      1.845726,
      1.461175,
      NULL,
      3,
      5.761217,
      2,
      5,
      0.889103,
      5,
      NULL,
      NULL,
      1.697262,
      NULL,
      1,
      NULL,
      NULL,
      0.696092,
      NULL,
      NULL,
      NULL,
      6,
      5,
      0.511579,
      1.321345,
      0.984705,
      3,
      0.882784,
      3,
      2.730067,
      2.744808,
      0,
      NULL,
      2,
      1.429267,
      0.282054,
      2,
      3,
      2,
      1,
      NULL,
      1.226684,
      5.516725,
      1,
      0.557831,
      4.301705,
      1.775218,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.446176,
      6.204423,
      5,
      0,
      3,
      0.842866,
      4,
      NULL,
      1,
      1,
      1.210553,
      1.894127,
      1,
      0.978116,
      0.216501,
      NULL,
      1.618041,
      1,
      0.958378,
      NULL,
      0,
      0.362569,
      2,
      0.161554,
      1.510550,
      0,
      2,
      1.887746,
      1.451342,
      1.550899,
      1.371436,
      0,
      1,
      1.261004,
      2,
      0.095510,
      1.457730,
      0.951699,
      NULL,
      1.365385,
      3.963613,
      2.510059,
      NULL,
      5.535199,
      1,
      0,
      1.457572,
      1,
      '11-16-1976',
      487,
      ' 4-29-2003',
      NULL,
      1,
      0.770881,
      5.243189,
      0.570935,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.624231,
      0,
      NULL,
      0.810177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.990715,
      0.566244,
      1,
      1,
      0,
      NULL,
      1.697315,
      NULL,
      NULL,
      NULL,
      1.329349,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.651523,
      1.519794,
      1.005969,
      NULL,
      NULL,
      NULL,
      8,
      1.905569,
      0.448339,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.944215,
      3,
      2,
      2,
      3,
      0,
      0.820170,
      2.720276,
      NULL,
      3,
      2.968950,
      NULL,
      2.710644,
      0,
      NULL,
      0,
      1.341176,
      1.482066,
      1,
      1.159307,
      0,
      NULL,
      NULL,
      0.467027,
      0.490349,
      0,
      0.075142,
      0,
      1,
      0,
      NULL,
      9.420182,
      7.251440,
      NULL,
      10,
      0,
      0.231079,
      1.782178,
      1.651367,
      NULL,
      3,
      3,
      0,
      2,
      0.387606,
      NULL,
      42.092506,
      49,
      42,
      NULL,
      0.220948,
      6.136573,
      '10340',
      NULL,
      '24224',
      1.254693,
      '',
      NULL,
      '',
      NULL,
      '21104',
      NULL,
      '',
      NULL,
      42,
      57.463631,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      1.773349,
      NULL,
      1.835671,
      0,
      NULL,
      NULL,
      1.283899,
      NULL,
      NULL,
      0.299790,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.254535,
      0.303457,
      2.242661,
      NULL,
      1.818101,
      0.333582,
      2.385614,
      0.658349,
      NULL,
      0.922790,
      NULL,
      NULL,
      3.139070,
      NULL,
      NULL,
      0.075465,
      1,
      NULL,
      1,
      NULL,
      NULL,
      6,
      6.858798,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.985892,
      0,
      0.570185,
      0.914691,
      2,
      NULL,
      NULL,
      0.387331,
      0.360297,
      0.592287,
      1,
      0.640306,
      0,
      1,
      NULL,
      3,
      1.794206,
      2,
      0,
      2,
      0,
      0,
      2,
      1,
      0.980103,
      0.503734,
      3.503181,
      3.608486,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.739983,
      0,
      0.124269,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241974,
      NULL,
      NULL,
      NULL,
      0.839314,
      NULL,
      1.824196,
      3,
      3,
      0.036533,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1.599081,
      1,
      0.423432,
      NULL,
      1.284555,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613125,
      NULL,
      NULL,
      1.409719,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.097464,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.984771,
      NULL,
      NULL,
      1.109593,
      NULL,
      4.761355,
      3.236470,
      NULL,
      0.142911,
      5,
      4,
      5,
      0.653020,
      NULL,
      NULL,
      2,
      3,
      1.026851,
      1.845887,
      NULL,
      NULL,
      NULL,
      2,
      3.024308,
      0.030153,
      NULL,
      NULL,
      3.245532,
      1,
      NULL,
      0,
      1.094142,
      2,
      2,
      3,
      1.527908,
      3.772037,
      5,
      0,
      1.594403,
      NULL,
      NULL,
      0.994804,
      0.046825,
      5,
      NULL,
      0.039804,
      1,
      1.988560,
      0.557787,
      NULL,
      NULL,
      NULL,
      0.666626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.915976,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.577480,
      NULL,
      NULL,
      1.387604,
      NULL,
      NULL,
      1.766050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.388975,
      0.327334,
      1.311937,
      3.073193,
      NULL,
      NULL,
      NULL,
      3.453915,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.214372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.308033,
      NULL,
      NULL,
      NULL,
      1.887105,
      NULL,
      NULL,
      NULL,
      2.391231,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515896,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382099,
      NULL,
      NULL,
      NULL,
      1.417466,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.295639,
      NULL,
      NULL,
      NULL,
      2,
      7.209246,
      3.001585,
      NULL,
      11.472245,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.492659,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2176,
      28.625754,
      0,
      NULL,
      0.015997,
      1,
      0,
      0,
      0,
      3.328399,
      NULL,
      3,
      1,
      NULL,
      1.667388,
      1,
      NULL,
      0,
      1,
      3.598181,
      NULL,
      2.074126,
      NULL,
      1,
      NULL,
      1.564733,
      NULL,
      0,
      NULL,
      0,
      NULL,
      321,
      NULL,
      3,
      18,
      9,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.460676,
      NULL,
      1.582710,
      NULL,
      0.476849,
      NULL,
      0.371604,
      NULL,
      0,
      0.021170,
      NULL,
      1.980417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.398146,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852578,
      NULL,
      1.448034,
      NULL,
      1.169167,
      NULL,
      0.929384,
      0.992213,
      3,
      NULL,
      3.761200,
      NULL,
      3,
      NULL,
      594.827808,
      NULL,
      NULL,
      NULL,
      1.076387,
      NULL,
      NULL,
      NULL,
      1.954457,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      1.422150,
      NULL,
      9,
      NULL,
      1,
      1.608372,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      183.652400,
      NULL,
      0.074258,
      NULL,
      1.351902,
      NULL,
      0,
      1,
      2,
      31,
      21.115035,
      1.032729,
      NULL,
      2,
      3.291617,
      1,
      0.433354,
      1,
      0,
      1.969245,
      1.420908,
      1.190156,
      3.820425,
      0.484145,
      3.616297,
      1,
      1.218149,
      1,
      NULL,
      NULL,
      1,
      0.718748,
      NULL,
      0,
      1.825051,
      NULL,
      0,
      0,
      NULL,
      1.859933,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0.115790,
      1,
      NULL,
      1.003213,
      NULL,
      NULL,
      3.840276,
      2.721434,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.316976,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      4.945508,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      63,
      5,
      1.523685,
      NULL,
      '34200',
      '31102',
      '33111',
      1.397441,
      '',
      '',
      '',
      1.968730,
      NULL,
      '',
      '');
commit;
end;
/


