set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      0.846082,
      1.091202,
      6,
      2,
      '4233',
      1,
      1.875083,
      NULL,
      NULL,
      ' 6- 7-1992',
      34,
      NULL,
      2,
      3,
      NULL,
      ' 9-28-1976',
      38,
      NULL,
      67,
      91.426513,
      2.284167,
      NULL,
      NULL,
      ' 4-12-1986',
      2,
      0.064579,
      NULL,
      NULL,
      1,
      0.566645,
      9,
      0.426882,
      0.173567,
      16.468411,
      4,
      4.956763,
      1,
      17,
      25,
      4.172973,
      16.173906,
      NULL,
      2,
      7.798530,
      NULL,
      0,
      0.798335,
      1.736616,
      0,
      1,
      1,
      1,
      0,
      NULL,
      5,
      NULL,
      NULL,
      5.639826,
      2.987336,
      0,
      1,
      1.390709,
      1.064869,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      6.899781,
      0.833776,
      0.852454,
      1.388544,
      0.420257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530687,
      0.955136,
      NULL,
      0.823499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328471,
      1.588747,
      1.683247,
      0.656118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.608152,
      NULL,
      0.182223,
      0,
      NULL,
      1.620816,
      1,
      0,
      1,
      NULL,
      NULL,
      1.350955,
      1,
      0,
      0.194129,
      0.832270,
      0,
      NULL,
      1,
      NULL,
      0.755547,
      1.418289,
      1.048343,
      NULL,
      NULL,
      3,
      NULL,
      0.770932,
      NULL,
      2,
      NULL,
      3.162103,
      NULL,
      1.235500,
      3,
      1.552228,
      2,
      0.686971,
      1,
      0,
      NULL,
      NULL,
      1,
      1.147440,
      0,
      NULL,
      NULL,
      149,
      ' 4-19-2003',
      402.772121,
      2.637108,
      0,
      1.890626,
      0.838025,
      0.334627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175537,
      0.118928,
      NULL,
      NULL,
      0.479430,
      1,
      1.712403,
      1.216063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632754,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.745221,
      NULL,
      1.634211,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.691422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      1.276184,
      0.928209,
      0.195211,
      NULL,
      1.334852,
      1.971504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501231,
      NULL,
      2,
      3,
      0,
      0,
      0.742525,
      0.024641,
      0,
      0.372459,
      NULL,
      2.983124,
      3,
      3,
      1,
      1.285545,
      1.105242,
      0.262307,
      1.447176,
      1,
      0,
      0.668367,
      NULL,
      NULL,
      0.107372,
      0.601358,
      NULL,
      1,
      0.859851,
      1.641973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366752,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042000,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      26.942059,
      161.454080,
      40,
      0,
      48.769181,
      1,
      2,
      2.866715,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.025612,
      1.232784,
      1.340973,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      0.002415,
      1,
      1.381061,
      2,
      0.428288,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.460634,
      NULL,
      NULL,
      1.641069,
      1,
      NULL,
      NULL,
      NULL,
      1.607555,
      NULL,
      NULL,
      NULL,
      0.242509,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.532818,
      NULL,
      NULL,
      3.504349,
      1,
      1,
      0.309921,
      0.891033,
      NULL,
      0,
      1.173051,
      1.453462,
      2,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0.597515,
      NULL,
      NULL,
      1.107214,
      NULL,
      NULL,
      0.015160,
      NULL,
      NULL,
      5,
      NULL,
      6.368145,
      0.330781,
      0.814296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.495566,
      0,
      1.875111,
      0.910078,
      NULL,
      NULL,
      1.511645,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.093346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542699,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.681575,
      NULL,
      NULL,
      1.883405,
      NULL,
      NULL,
      3,
      0.443308,
      NULL,
      0.470520,
      NULL,
      NULL,
      0,
      0.731751,
      1,
      NULL,
      0.301188,
      4,
      2,
      NULL,
      NULL,
      0.434630,
      NULL,
      NULL,
      NULL,
      1.957720,
      NULL,
      NULL,
      1,
      3,
      4.242253,
      2.814822,
      3.981523,
      1,
      0.347661,
      0.400685,
      1.197111,
      NULL,
      NULL,
      2.207190,
      1.092049,
      0,
      2,
      0.947016,
      2.216648,
      NULL,
      1.054436,
      NULL,
      3,
      2.384702,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      NULL,
      0.474751,
      0,
      1.804108,
      NULL,
      1.767080,
      17.906536,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.192606,
      NULL,
      NULL,
      1.824656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.886231,
      NULL,
      NULL,
      NULL,
      5.097655,
      NULL,
      1.842586,
      1.840888,
      NULL,
      3.700039,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.739519,
      NULL,
      2,
      1,
      NULL,
      1.749195,
      1,
      NULL,
      2.733149,
      0.931509,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.350774,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.983178,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.718962,
      NULL,
      1.174788,
      NULL,
      NULL,
      NULL,
      2.890760,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.811869,
      NULL,
      0.648676,
      NULL,
      0,
      NULL,
      1.162126,
      NULL,
      1.530049,
      NULL,
      1.400207,
      NULL,
      NULL,
      NULL,
      1.295067,
      NULL,
      2.569540,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      55,
      39.329518,
      1.223380,
      NULL,
      NULL,
      1.263917,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.056588,
      10.081049,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      151,
      358.855609,
      1,
      NULL,
      0,
      NULL,
      0.458037,
      0,
      0.186963,
      0.049063,
      1,
      0.047356,
      0,
      1,
      0,
      NULL,
      1,
      1.779188,
      1,
      0.724999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.000376,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613686,
      0.931815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107872,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.217924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.279552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787748,
      1.728339,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.459598,
      NULL,
      1.935595,
      NULL,
      0.804767,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175975,
      2,
      2,
      2,
      2,
      2,
      0,
      0.608047,
      NULL,
      0.663959,
      2,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.844538,
      0.586837,
      NULL,
      0.874366,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.356635,
      NULL,
      0.751137,
      0.052007,
      NULL,
      1,
      NULL,
      NULL,
      0.066306,
      1.050999,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.356710,
      NULL,
      1,
      1.102146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153396,
      NULL,
      0.894657,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      26.143210,
      NULL,
      0,
      NULL,
      '01013',
      '13433',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


