set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '3122430',
      0.611527,
      1.419214,
      NULL,
      1,
      '2132',
      0,
      NULL,
      NULL,
      NULL,
      ' 2- 5-1997',
      49.855437,
      NULL,
      4.684183,
      1.435912,
      1.937377,
      ' 7-17-1987',
      9.177817,
      3.531667,
      192,
      34.760140,
      0,
      ' 6- 2-2001',
      ' 3-20-2000',
      NULL,
      3.994284,
      0.679607,
      0.717157,
      1,
      NULL,
      3,
      NULL,
      1,
      1,
      113.899685,
      9.736551,
      12.136025,
      4,
      22,
      25,
      7.022506,
      10.842619,
      2.553932,
      2,
      5.376466,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.047727,
      NULL,
      4,
      0,
      1.654792,
      NULL,
      0.026421,
      NULL,
      6.017122,
      10.284364,
      NULL,
      2.372453,
      3,
      NULL,
      0,
      5.103542,
      1,
      3,
      0.396032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.983006,
      0.089496,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.871788,
      NULL,
      NULL,
      1.105228,
      3.453596,
      0,
      0.411290,
      0.241899,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      1.905126,
      4.943517,
      0,
      2.639115,
      3.891451,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      2,
      4,
      5,
      0,
      1,
      NULL,
      3.802461,
      0.940560,
      0.430125,
      7.169508,
      0.344074,
      NULL,
      0,
      0.686038,
      1,
      NULL,
      NULL,
      1,
      0.355010,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      4.852147,
      4,
      1.320207,
      1.486619,
      1,
      0,
      0.600999,
      8,
      8.105962,
      9,
      6,
      0.208299,
      0.105202,
      5.449127,
      1,
      3,
      1.896027,
      1.796835,
      0,
      ' 5-12-1984',
      716,
      NULL,
      52.739639,
      0.915200,
      NULL,
      0.204809,
      3,
      0.389738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952295,
      3.313496,
      1.618337,
      1,
      1,
      0.528486,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.598045,
      NULL,
      0.076519,
      1.678408,
      0.201795,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348286,
      1,
      2.228708,
      0,
      0.414418,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893170,
      2.184575,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      48.230768,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.973776,
      0,
      3.710055,
      0,
      NULL,
      NULL,
      3.904503,
      0,
      3,
      0,
      2.451599,
      2.075248,
      3.084657,
      0,
      0,
      1.130916,
      0.948606,
      0.167827,
      1.888967,
      1,
      0,
      1,
      0.325530,
      0,
      0.358919,
      1.767728,
      NULL,
      1,
      NULL,
      0,
      7,
      6.047345,
      1.252728,
      8.880234,
      NULL,
      4.504516,
      NULL,
      NULL,
      NULL,
      2.718790,
      0.047699,
      0.663082,
      66.051175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      7.067466,
      3.790585,
      1,
      '14004',
      '',
      '',
      1.446432,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      30,
      68,
      33,
      0.647148,
      0,
      12.122848,
      1,
      2,
      2,
      2.067025,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.623305,
      NULL,
      1.898466,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.931478,
      NULL,
      NULL,
      0.692076,
      2,
      1,
      0,
      3.195490,
      3,
      1,
      2,
      3.041951,
      NULL,
      0.726441,
      7.331121,
      1,
      7.227153,
      1.920529,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.671642,
      1.621348,
      1,
      NULL,
      NULL,
      0,
      0.403610,
      3,
      0.021967,
      1.968758,
      1,
      2.237367,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      1.552155,
      NULL,
      1.879006,
      0.821117,
      0.929072,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.202856,
      1,
      1.609973,
      2.116804,
      3.732406,
      7,
      NULL,
      1.557036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057416,
      NULL,
      NULL,
      2.351802,
      0,
      1.180207,
      1,
      NULL,
      0.557148,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.754639,
      0,
      1.083380,
      0.460576,
      1.762481,
      1,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.727790,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.345598,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.530497,
      1.089668,
      2.376093,
      1.646139,
      3,
      NULL,
      4.151822,
      1.076962,
      0.867377,
      0.010173,
      NULL,
      NULL,
      2,
      0,
      1.340670,
      2,
      3,
      2,
      NULL,
      3,
      7.550199,
      1.279311,
      1.757461,
      3.852783,
      0.654537,
      NULL,
      NULL,
      1.646137,
      NULL,
      2,
      NULL,
      0,
      2.395520,
      NULL,
      5.237772,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2,
      1,
      1,
      1,
      3.728478,
      0.582937,
      1,
      1,
      NULL,
      NULL,
      NULL,
      84.844313,
      NULL,
      10,
      1.898326,
      NULL,
      1,
      0.761360,
      NULL,
      NULL,
      0,
      NULL,
      0.648932,
      11,
      NULL,
      1.245483,
      3,
      NULL,
      1.328837,
      3.904188,
      NULL,
      NULL,
      9,
      NULL,
      1,
      0,
      NULL,
      1,
      2.539048,
      NULL,
      NULL,
      18,
      NULL,
      1.231895,
      0.045296,
      NULL,
      0.041366,
      11.487128,
      NULL,
      NULL,
      3.071583,
      NULL,
      0.985314,
      1.204873,
      NULL,
      NULL,
      1,
      3.839871,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.180156,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.299767,
      NULL,
      NULL,
      NULL,
      0.946472,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.927017,
      NULL,
      0,
      NULL,
      1.638161,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.416703,
      NULL,
      4,
      NULL,
      0.462678,
      NULL,
      1.403495,
      NULL,
      NULL,
      NULL,
      1.982947,
      69.010808,
      NULL,
      0.233314,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.968368,
      NULL,
      NULL,
      84,
      14,
      2,
      11,
      0,
      1.838627,
      NULL,
      0.132498,
      NULL,
      32,
      1.234564,
      1.275642,
      1.668999,
      0,
      0.307204,
      1.816677,
      1,
      1,
      0,
      1,
      1.566450,
      1.686194,
      NULL,
      0,
      1.006347,
      1.818753,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.555267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859519,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.918135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401795,
      0.873358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724171,
      1.567773,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.090062,
      6.553031,
      1.530510,
      NULL,
      3.594264,
      0.359207,
      10,
      1.947451,
      2.268492,
      1.880490,
      1,
      0.018182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.325157,
      1,
      NULL,
      NULL,
      1.073019,
      NULL,
      1.459091,
      0.369003,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.144399,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8,
      2.850138,
      0.585687,
      1.832085,
      24,
      75.840841,
      2.915248,
      0,
      2.820326,
      NULL,
      '44330',
      NULL,
      1.509434,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


