set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9434890';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34',
      NULL,
      28.673987,
      8.295283,
      '4244024',
      3,
      0,
      2,
      1,
      '1042',
      4.656849,
      0.905845,
      NULL,
      NULL,
      ' 9-13-2001',
      47,
      33,
      NULL,
      3,
      0,
      ' 9-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      1.723117,
      NULL,
      NULL,
      ' 4-24-1992',
      2.061880,
      3,
      0.031542,
      1.024636,
      1,
      0.358121,
      NULL,
      1,
      0,
      6,
      NULL,
      4.853530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.428097,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      0.266347,
      3.302587,
      1,
      0,
      1.452063,
      NULL,
      3,
      11,
      NULL,
      4.850992,
      5.972972,
      0,
      1.104907,
      6.600690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313516,
      3.927679,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.227575,
      NULL,
      NULL,
      3.654286,
      0,
      1.735929,
      3,
      2.010627,
      2.673703,
      2,
      1,
      NULL,
      NULL,
      2,
      1.604144,
      2,
      3.189734,
      2,
      0,
      2,
      1,
      0,
      5.794455,
      1.532912,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132123,
      1,
      0.344565,
      0,
      1,
      1,
      0,
      0.597661,
      0.652667,
      0,
      0.781278,
      1,
      0,
      1.265929,
      0.531234,
      0.448191,
      1,
      0.159468,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0.517433,
      0.617918,
      1.967683,
      3,
      1.494490,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      2,
      6.644345,
      NULL,
      6.250021,
      5,
      6.211450,
      2.392989,
      3.138174,
      NULL,
      0.926462,
      NULL,
      3,
      ' 4-19-2000',
      29.821218,
      ' 8-26-1998',
      NULL,
      3,
      0,
      1,
      0.873823,
      0.462544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.381612,
      1,
      NULL,
      1,
      1.808859,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      1.823129,
      7,
      2,
      1,
      1,
      2.299218,
      0.841104,
      1.359409,
      0,
      0.926880,
      NULL,
      NULL,
      1,
      1,
      1,
      0.229637,
      0.486635,
      NULL,
      1,
      2.768819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280803,
      NULL,
      1.078376,
      0.484802,
      0,
      NULL,
      1.635072,
      0.993725,
      8.147653,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.808964,
      1,
      0.480566,
      5,
      NULL,
      2.482811,
      4.195070,
      4.996199,
      3.028175,
      1.275343,
      NULL,
      0.389921,
      NULL,
      1,
      3.201320,
      NULL,
      1.600439,
      NULL,
      0,
      0,
      NULL,
      1.771795,
      0.989427,
      0.217415,
      NULL,
      0.834283,
      NULL,
      1,
      0.082267,
      0.253200,
      NULL,
      1.648353,
      3,
      NULL,
      2.433411,
      NULL,
      6.198722,
      1.440472,
      1.247481,
      3.676243,
      0.715362,
      3,
      3.280393,
      3,
      5.359464,
      2,
      1,
      NULL,
      NULL,
      36,
      NULL,
      5.399954,
      3,
      2.173819,
      NULL,
      NULL,
      NULL,
      3.069415,
      '2220',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      4.983060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.897227,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.716617,
      6.072875,
      5619,
      0.665558,
      0.615030,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0.970476,
      0,
      2,
      1.837581,
      1.723282,
      1,
      1.905288,
      1.894944,
      NULL,
      0,
      0,
      NULL,
      1.906175,
      NULL,
      1.675954,
      NULL,
      1.984690,
      NULL,
      0.605985,
      NULL,
      42,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.056853,
      1,
      3.117799,
      NULL,
      NULL,
      1,
      NULL,
      1.380506,
      NULL,
      0.087697,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.575004,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.618834,
      NULL,
      2,
      NULL,
      1.622923,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.583358,
      NULL,
      0.479412,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.830573,
      1.310191,
      NULL,
      NULL,
      1.752811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276775,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.026070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272560,
      1.154232,
      NULL,
      1.177292,
      NULL,
      0.388336,
      NULL,
      NULL,
      NULL,
      0.915583,
      2.900976,
      0,
      NULL,
      NULL,
      0.094190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626396,
      NULL,
      0.376203,
      NULL,
      NULL,
      1,
      31.096983,
      NULL,
      1.866695,
      1,
      NULL,
      NULL,
      1,
      1,
      3.958349,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      1,
      2.589635,
      0,
      1.556431,
      0.839583,
      NULL,
      0.397626,
      NULL,
      NULL,
      NULL,
      0.139874,
      NULL,
      0,
      0.410986,
      NULL,
      0.983882,
      NULL,
      NULL,
      1.234347,
      0.470555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1.366237,
      2,
      NULL,
      0.657668,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044235,
      NULL,
      1.067382,
      NULL,
      1,
      NULL,
      0.401215,
      7,
      2.141151,
      3,
      1.542113,
      1,
      51.901685,
      33,
      NULL,
      0,
      2,
      NULL,
      '00211',
      '',
      2,
      '0210',
      '',
      '',
      0.389430,
      '',
      '',
      '');
commit;
end;
/


