set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7504246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '4001342',
      NULL,
      0,
      4,
      1,
      '1220',
      0,
      1.690607,
      NULL,
      NULL,
      ' 6-10-1993',
      70.681736,
      NULL,
      4.664952,
      NULL,
      NULL,
      ' 2- 3-1982',
      13,
      2.331007,
      NULL,
      94.034080,
      0.493899,
      NULL,
      ' 4-17-1974',
      '10- 2-1992',
      1.142442,
      0.199421,
      0,
      0.958468,
      0.186796,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      11,
      NULL,
      26,
      4.428809,
      NULL,
      3.997064,
      0,
      0.486601,
      0,
      1,
      0,
      0.645389,
      0.014743,
      NULL,
      1.658544,
      0.062836,
      1,
      NULL,
      1.366446,
      0,
      3.712596,
      8.451824,
      0.248401,
      0,
      6.205067,
      0,
      2,
      NULL,
      3,
      3,
      2,
      0.159755,
      1,
      9.267880,
      NULL,
      2,
      1,
      0.756787,
      0.705552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474211,
      0.705514,
      2.756896,
      1.202313,
      NULL,
      NULL,
      3.980470,
      0,
      1.227426,
      0.233611,
      0,
      NULL,
      3,
      NULL,
      0,
      2.336610,
      0.054758,
      1.788539,
      0,
      1,
      0,
      7,
      0,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877683,
      1,
      1.670793,
      0.208665,
      0,
      NULL,
      1.333364,
      0.355150,
      1,
      0,
      1.939268,
      1,
      0.964912,
      NULL,
      1.616694,
      0,
      0.724068,
      1.895288,
      0.832770,
      NULL,
      0.250073,
      0,
      1,
      1,
      0.437772,
      0,
      1,
      0,
      1.119729,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0.987435,
      1.012469,
      0.576663,
      1.795207,
      0,
      6.845495,
      2,
      7.200971,
      8,
      1.513667,
      NULL,
      3,
      2,
      ' 4- 0-1977',
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      2.388195,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.774907,
      1,
      NULL,
      NULL,
      1.910415,
      3.547702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742052,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233803,
      1,
      0.262569,
      0,
      NULL,
      0.891720,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.826773,
      1.419264,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.624563,
      1,
      1,
      0.537070,
      NULL,
      NULL,
      3.865310,
      NULL,
      1,
      3,
      NULL,
      0.317315,
      2.719551,
      4,
      3,
      5,
      1,
      0,
      0.251066,
      NULL,
      1,
      1.427515,
      0.904445,
      0.849900,
      0,
      NULL,
      1,
      0.257970,
      1.171430,
      4.782015,
      0,
      10.815314,
      0.390015,
      4.892396,
      4,
      9.882627,
      6,
      2,
      0.514345,
      7.671562,
      2.841656,
      0.687650,
      NULL,
      14,
      0,
      0.885486,
      NULL,
      NULL,
      63.363114,
      31,
      2,
      NULL,
      3.031406,
      NULL,
      '',
      '',
      0.086200,
      '',
      '',
      NULL,
      1.378794,
      '',
      '',
      '',
      1.761873,
      50.338982,
      117.596268,
      5,
      0,
      3,
      4,
      4,
      0.350287,
      1.180149,
      2,
      2.549070,
      0,
      NULL,
      NULL,
      1.725932,
      NULL,
      NULL,
      0.670621,
      0,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.159742,
      3,
      NULL,
      NULL,
      1.854802,
      NULL,
      NULL,
      1,
      3.601325,
      0.542116,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.309041,
      4.465210,
      3.677484,
      1.132486,
      1.512552,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      2.048117,
      1,
      2,
      3,
      0.151539,
      1.812183,
      1.139488,
      3.925273,
      0.547181,
      1.526057,
      NULL,
      0,
      2.867626,
      NULL,
      2.176382,
      NULL,
      0,
      NULL,
      2.851382,
      NULL,
      0,
      0,
      0.913485,
      NULL,
      NULL,
      0.227515,
      NULL,
      NULL,
      4.592779,
      1.660364,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554299,
      NULL,
      NULL,
      NULL,
      0.657177,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.106240,
      0.681620,
      0,
      NULL,
      NULL,
      NULL,
      3.589089,
      1,
      0.513581,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.295250,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.826383,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.096348,
      NULL,
      NULL,
      1.656841,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117134,
      0.655246,
      NULL,
      NULL,
      1,
      3.555865,
      0,
      0.860839,
      NULL,
      NULL,
      0.381758,
      NULL,
      NULL,
      3,
      1,
      3.877390,
      3,
      NULL,
      1,
      6.816067,
      3.702857,
      7.533048,
      4.928404,
      1,
      0.145275,
      0.065969,
      NULL,
      2.507162,
      0,
      0.989421,
      1,
      0,
      0,
      1.528382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211592,
      NULL,
      NULL,
      3.552780,
      NULL,
      NULL,
      1.306669,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.921505,
      NULL,
      NULL,
      2.779382,
      NULL,
      NULL,
      1,
      0,
      1,
      1.537460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.682272,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707650,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.145404,
      NULL,
      NULL,
      NULL,
      1.069699,
      NULL,
      NULL,
      NULL,
      2.396341,
      9.671279,
      NULL,
      1.136173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831912,
      NULL,
      0.200711,
      NULL,
      35.578926,
      0,
      1,
      NULL,
      0,
      1.658789,
      0.863991,
      NULL,
      NULL,
      1.203870,
      0.230992,
      1.812154,
      NULL,
      0,
      NULL,
      1.338355,
      1.164083,
      NULL,
      1.521467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.049335,
      1.810085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733707,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917889,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471995,
      NULL,
      1.396246,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.742967,
      0.525205,
      0,
      NULL,
      NULL,
      1.150328,
      0,
      1.421582,
      2.994634,
      3.234024,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.378201,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.559650,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.140943,
      1.358733,
      NULL,
      NULL,
      0.946608,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419202,
      1.305620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.005829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755889,
      NULL,
      0.621002,
      NULL,
      0.369233,
      NULL,
      6,
      0.213517,
      1,
      1.856818,
      NULL,
      NULL,
      27,
      34,
      0.460699,
      0.809889,
      3,
      '13003',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.275168,
      '',
      '',
      NULL);
commit;
end;
/


