set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9435005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3043223',
      2.252774,
      0.383114,
      0,
      2,
      '1332',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.270596,
      1.516887,
      NULL,
      47,
      2,
      53,
      40.654340,
      1,
      ' 0-28-2000',
      NULL,
      ' 7- 5-1977',
      0.470535,
      NULL,
      2,
      3,
      NULL,
      2,
      0,
      2.902433,
      NULL,
      NULL,
      NULL,
      6,
      1,
      41,
      21.858124,
      5.290959,
      10.738940,
      5,
      1.066987,
      NULL,
      1.977119,
      NULL,
      1.838956,
      0,
      1.675684,
      0,
      0.362647,
      1,
      1.393649,
      0,
      1.936457,
      NULL,
      2.902521,
      NULL,
      NULL,
      NULL,
      1.024758,
      1.373296,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.920630,
      0,
      1,
      3.421254,
      0.744803,
      0,
      0.504199,
      NULL,
      NULL,
      2,
      1,
      5.331527,
      2.318305,
      1.658560,
      0.390717,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.333587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.800825,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1.945174,
      1.269461,
      1,
      0.537931,
      0.478423,
      NULL,
      NULL,
      2.888745,
      1,
      NULL,
      3.598531,
      1.267964,
      NULL,
      2,
      NULL,
      6.873443,
      3,
      1,
      4,
      4,
      NULL,
      5.266570,
      2,
      0.654231,
      6.103253,
      NULL,
      6,
      7.646666,
      4,
      NULL,
      4,
      1.905725,
      4.060245,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139085,
      1.704125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1.371184,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.721642,
      1.671183,
      4.836269,
      4,
      7.477598,
      4.682123,
      NULL,
      NULL,
      NULL,
      2.293192,
      4,
      NULL,
      NULL,
      NULL,
      4.890931,
      NULL,
      NULL,
      108,
      ' 3-25-2000',
      135.634522,
      1.975710,
      1.723405,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      2.948198,
      7.118592,
      3.988533,
      0.406596,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0.578727,
      NULL,
      NULL,
      3.586664,
      2,
      2.393460,
      1,
      0.700858,
      NULL,
      NULL,
      1,
      14,
      1.698624,
      0,
      1,
      1,
      1,
      1.520162,
      1,
      1,
      0,
      1.364379,
      0,
      0,
      1,
      1.028526,
      3.392302,
      NULL,
      NULL,
      NULL,
      4.197904,
      NULL,
      1,
      NULL,
      2.703423,
      2,
      0,
      3,
      2.066141,
      0.132797,
      NULL,
      2.728190,
      0.621290,
      NULL,
      7,
      9.397813,
      33,
      4,
      3,
      NULL,
      NULL,
      '410',
      '',
      0.198492,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      33.718310,
      3,
      42.551042,
      1.087939,
      1.219451,
      5.340013,
      0.056823,
      1,
      1,
      0.208912,
      NULL,
      NULL,
      0.003633,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.705966,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.497192,
      1.964783,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355578,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0.401027,
      NULL,
      NULL,
      0.552993,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.768129,
      1.335651,
      NULL,
      0.403510,
      2,
      0.823345,
      NULL,
      0.867564,
      1,
      0,
      NULL,
      NULL,
      1.789534,
      1.442859,
      1,
      0.973656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705202,
      NULL,
      NULL,
      5.741698,
      5,
      1,
      0,
      1.301582,
      NULL,
      NULL,
      NULL,
      1,
      0.972880,
      1.076648,
      1.663750,
      1.320217,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.941357,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.763561,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.073344,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.381150,
      NULL,
      NULL,
      NULL,
      2,
      1,
      6,
      5.758078,
      NULL,
      1.496692,
      NULL,
      NULL,
      1,
      1.134074,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      2,
      3,
      4.395074,
      2.702969,
      2.224698,
      NULL,
      3,
      2.247317,
      1,
      0.089459,
      1.977823,
      0.753958,
      0,
      0.347588,
      0,
      8.775618,
      7.035021,
      3,
      3.738677,
      0.618094,
      NULL,
      1,
      NULL,
      NULL,
      1.498443,
      0.612835,
      1,
      1,
      NULL,
      1.981900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.403118,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.294740,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.157372,
      NULL,
      1.847121,
      NULL,
      0.229193,
      0,
      2.322087,
      NULL,
      NULL,
      NULL,
      0.914026,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2.116064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.648840,
      NULL,
      1.816361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344473,
      NULL,
      0.329678,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.140650,
      NULL,
      1.878898,
      NULL,
      3.141123,
      NULL,
      NULL,
      NULL,
      3.456993,
      NULL,
      NULL,
      NULL,
      0.417864,
      NULL,
      3.055494,
      NULL,
      1.449913,
      NULL,
      4,
      NULL,
      12,
      NULL,
      0.410249,
      1,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.512290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      489.759080,
      29.666536,
      1,
      2.941682,
      0.546079,
      3,
      1,
      3,
      0.267660,
      1,
      0,
      1,
      0,
      NULL,
      1.362368,
      3.991015,
      NULL,
      1.851954,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.734128,
      NULL,
      3.136406,
      NULL,
      87.926379,
      NULL,
      2.237452,
      24.823741,
      37.620140,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.704416,
      NULL,
      1,
      NULL,
      0.304749,
      NULL,
      2,
      NULL,
      2.889570,
      NULL,
      2,
      NULL,
      1.304511,
      NULL,
      0,
      NULL,
      0.769968,
      NULL,
      2,
      NULL,
      1.061822,
      0.482074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064753,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107539,
      NULL,
      0.786343,
      NULL,
      0.895138,
      NULL,
      0.014490,
      NULL,
      3.752157,
      NULL,
      0,
      NULL,
      0.472051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416153,
      NULL,
      0.843724,
      NULL,
      0.065378,
      1.090171,
      0.729406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.488282,
      0.601187,
      NULL,
      NULL,
      NULL,
      3.723873,
      NULL,
      391,
      NULL,
      NULL,
      NULL,
      1.490144,
      NULL,
      1.307217,
      NULL,
      3.360280,
      6,
      19.551155,
      2.824170,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      3,
      NULL,
      5,
      1.150980,
      2.653253,
      0.207678,
      1.066623,
      NULL,
      0,
      0.967378,
      0.264926,
      1.090423,
      1.863021,
      1,
      0,
      0,
      0.230659,
      0.283514,
      1.053779,
      1,
      1.217340,
      0.271662,
      3.891120,
      3.163452,
      0,
      0,
      1.165778,
      3,
      1,
      NULL,
      NULL,
      0.989440,
      NULL,
      1,
      0.144302,
      1.820571,
      1,
      NULL,
      1,
      0,
      0,
      3.872075,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573859,
      3.349194,
      NULL,
      1.896944,
      2.433612,
      0,
      0,
      1.893991,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      3.821308,
      NULL,
      1.907032,
      NULL,
      NULL,
      NULL,
      NULL,
      3.228290,
      127.178334,
      1.226619,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.469687,
      NULL,
      0.991340,
      4.871658,
      1,
      NULL,
      NULL,
      NULL,
      117,
      3.673503,
      0,
      7.740275,
      '2144',
      '43022',
      '13204',
      0.303399,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


