set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716130';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1.970040,
      1.727353,
      '310',
      '24044300',
      15.835145,
      33,
      '2321210',
      0.379256,
      1,
      4,
      2,
      '1021',
      6.098294,
      0.718603,
      NULL,
      NULL,
      ' 9-18-1988',
      NULL,
      89.155110,
      NULL,
      3,
      0.214021,
      ' 8-21-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-10-2002',
      '10- 7-1988',
      ' 3- 3-1994',
      NULL,
      3.278692,
      NULL,
      0,
      0,
      0.774812,
      3.790169,
      0,
      NULL,
      NULL,
      NULL,
      8,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.413813,
      0,
      NULL,
      0.093335,
      0,
      1.892997,
      0,
      1,
      0.466260,
      0.616768,
      NULL,
      0,
      NULL,
      1.990465,
      0,
      4.856594,
      1,
      NULL,
      7.698850,
      0,
      1,
      1,
      1.981444,
      1,
      NULL,
      5.674048,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3.651285,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.466551,
      5.651249,
      NULL,
      0,
      1.904821,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.018381,
      2,
      NULL,
      0.040795,
      2.875872,
      2,
      0.155676,
      3,
      0.455136,
      3,
      7.896074,
      1,
      3.983008,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.485031,
      1.137817,
      NULL,
      1.042299,
      NULL,
      0,
      0,
      0.363496,
      NULL,
      1.079643,
      0,
      0,
      1.495885,
      0,
      0.377477,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.593240,
      2.690212,
      5,
      0,
      NULL,
      7,
      NULL,
      3,
      3.870906,
      1,
      NULL,
      3,
      1.384515,
      1.921080,
      2.479724,
      NULL,
      0,
      3,
      4.911048,
      NULL,
      NULL,
      9.451556,
      NULL,
      3,
      NULL,
      1,
      ' 4- 5-2003',
      6,
      ' 7-14-1980',
      8,
      3,
      0,
      1,
      7,
      1.576696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427604,
      NULL,
      0.448295,
      1.593854,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      1.014813,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      5.104897,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.882636,
      4,
      9.772566,
      7,
      2.266383,
      2,
      0.327512,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.838203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.972193,
      1.868786,
      1.116437,
      1.282731,
      1.656547,
      1,
      0.927850,
      1,
      0,
      1.018956,
      NULL,
      NULL,
      NULL,
      0.325661,
      NULL,
      3,
      0,
      1,
      1.721129,
      NULL,
      1,
      NULL,
      2,
      1.274638,
      1,
      1,
      NULL,
      3,
      3,
      0.456789,
      1,
      0.597209,
      NULL,
      NULL,
      NULL,
      0.808428,
      0.702481,
      0,
      0,
      0.078056,
      1.876477,
      1.370999,
      0.683829,
      NULL,
      0.767740,
      5,
      0,
      1,
      6.394045,
      7,
      3.964637,
      NULL,
      NULL,
      5.733639,
      1,
      NULL,
      NULL,
      27,
      3,
      3.027545,
      29,
      NULL,
      NULL,
      61,
      NULL,
      0.179816,
      2,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.102429,
      NULL,
      NULL,
      NULL,
      1.881181,
      3.710466,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.349975,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      135.948911,
      7,
      0.589383,
      NULL,
      0.041839,
      0.385687,
      0,
      1.359350,
      0,
      0,
      0.696414,
      0.241724,
      1,
      NULL,
      1.272534,
      0.548530,
      0,
      0.248267,
      1.014932,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.042797,
      0.252575,
      3.884821,
      NULL,
      1.268273,
      NULL,
      0.775682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448066,
      NULL,
      1.982417,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.828230,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.516530,
      3.387059,
      NULL,
      2.246887,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      3.272797,
      NULL,
      NULL,
      NULL,
      0.990573,
      NULL,
      1.178474,
      1,
      0.096268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852142,
      3.033230,
      NULL,
      0.066381,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.084149,
      1,
      2.506722,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.423576,
      24,
      11,
      1.056715,
      NULL,
      NULL,
      NULL,
      3.915485,
      NULL,
      3,
      3.676633,
      3.236056,
      0,
      NULL,
      1,
      3.652958,
      0.330247,
      3.066234,
      NULL,
      1,
      0,
      NULL,
      1,
      0.723354,
      NULL,
      1,
      0,
      NULL,
      1,
      1.379636,
      NULL,
      0.681477,
      NULL,
      NULL,
      0.810446,
      0.794588,
      NULL,
      1.624610,
      NULL,
      NULL,
      0.391159,
      0,
      NULL,
      NULL,
      0.615594,
      NULL,
      0,
      NULL,
      NULL,
      1.417242,
      NULL,
      NULL,
      3.460643,
      NULL,
      1.108323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.290823,
      NULL,
      NULL,
      NULL,
      2.376703,
      0,
      NULL,
      NULL,
      35,
      NULL,
      NULL,
      2.340362,
      1.261716,
      NULL,
      '23024',
      '',
      0.617581,
      '',
      '',
      NULL,
      1.515237,
      '',
      '',
      '');
commit;
end;
/


