set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9033939';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '2012212',
      3,
      1.603684,
      2,
      NULL,
      '1341',
      2,
      NULL,
      NULL,
      NULL,
      ' 1-20-1988',
      44.578526,
      NULL,
      4,
      2,
      0,
      ' 7-11-1977',
      5.053715,
      0,
      44.504730,
      NULL,
      3,
      ' 7-18-1974',
      '10-11-1974',
      ' 9-10-1999',
      NULL,
      NULL,
      1.820460,
      1.833475,
      1,
      0.576455,
      3,
      1.805669,
      0,
      4.707464,
      8.635270,
      16,
      2,
      NULL,
      10.559316,
      5,
      7,
      5,
      1.665915,
      1,
      0.830215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.048953,
      3,
      10,
      1.386861,
      0,
      1,
      1.152891,
      NULL,
      1.783868,
      1,
      0.575321,
      0.666230,
      1.814730,
      0,
      4,
      0,
      0.941919,
      0.668724,
      1.287925,
      NULL,
      NULL,
      NULL,
      1.363206,
      NULL,
      0,
      4,
      1.212101,
      1,
      2,
      0.783504,
      1,
      0,
      1,
      3,
      2,
      NULL,
      1,
      NULL,
      3.726027,
      1.799872,
      3.544283,
      2,
      0.188986,
      1.746403,
      NULL,
      1,
      2.896635,
      NULL,
      1.366331,
      NULL,
      3.100011,
      1,
      NULL,
      NULL,
      0,
      3,
      1.196404,
      1,
      1.772089,
      0.256405,
      1,
      3.023935,
      0,
      NULL,
      NULL,
      1.848549,
      1.346504,
      1,
      NULL,
      0,
      0.389920,
      0.147969,
      0,
      0.295515,
      1.064922,
      0,
      NULL,
      0.086848,
      3.811992,
      1.450847,
      1,
      1.830824,
      1,
      1,
      5.477358,
      2,
      1.783668,
      4,
      5.287897,
      1,
      7,
      0,
      1,
      0.788033,
      1.439249,
      1,
      NULL,
      NULL,
      2,
      1.812583,
      10,
      NULL,
      2.277221,
      1.382367,
      3.527196,
      ' 3-14-1981',
      1059.173187,
      ' 2-28-1978',
      197,
      2,
      1,
      1.225252,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.886822,
      0.832783,
      1,
      NULL,
      0.569746,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.418953,
      0.495181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845483,
      0.110410,
      NULL,
      3.425147,
      1.046692,
      0,
      NULL,
      9.444485,
      1,
      1,
      1,
      3.960129,
      1,
      NULL,
      NULL,
      0.711871,
      3,
      1.638553,
      3.009545,
      7,
      3.986788,
      NULL,
      NULL,
      NULL,
      '10-15-1993',
      3.808031,
      0.256160,
      1,
      NULL,
      2,
      3,
      0.159546,
      NULL,
      1,
      1.806862,
      1.079050,
      NULL,
      118.546215,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915186,
      1,
      2,
      0,
      NULL,
      2,
      0.302755,
      1.250356,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10.039525,
      33,
      22.255338,
      95.592161,
      152,
      84.241561,
      48.815909,
      0.767605,
      1,
      1.748907,
      1.811778,
      1,
      1.584861,
      0.149047,
      7.422007,
      4.030715,
      0,
      5.001347,
      9,
      5,
      NULL,
      7,
      NULL,
      4.069438,
      1.263901,
      4.405862,
      NULL,
      3,
      1.714430,
      69,
      0,
      1.267122,
      NULL,
      NULL,
      26.383966,
      39,
      4,
      0.985370,
      5.079892,
      '00134',
      NULL,
      '',
      0.978357,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      3.021599,
      NULL,
      43.405320,
      16,
      2.530814,
      41,
      2.284027,
      NULL,
      2.395660,
      0.720641,
      NULL,
      2.181925,
      1,
      NULL,
      NULL,
      1.917167,
      NULL,
      NULL,
      1.484855,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.083275,
      NULL,
      NULL,
      2,
      1,
      0.870378,
      0.447627,
      NULL,
      NULL,
      1.226827,
      NULL,
      NULL,
      0.567891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908384,
      NULL,
      NULL,
      3,
      7.602666,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.859475,
      NULL,
      NULL,
      NULL,
      1,
      3.790205,
      1.159442,
      2.030928,
      2,
      NULL,
      1,
      0.008745,
      1,
      3,
      0.763205,
      1,
      3,
      2.482934,
      3,
      2.434012,
      3.534973,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.291123,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002905,
      NULL,
      NULL,
      2,
      0,
      0.375098,
      2,
      0.826451,
      1,
      1.246352,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.635798,
      NULL,
      NULL,
      1.051151,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095494,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.220534,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.698384,
      NULL,
      NULL,
      0.387022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798547,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3.534015,
      1.688460,
      0.848000,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      1,
      0.117770,
      2.264757,
      NULL,
      0,
      1,
      0.783474,
      4,
      NULL,
      3.502653,
      2.737148,
      3,
      1.187269,
      0,
      NULL,
      NULL,
      0.064030,
      0,
      1,
      0.955120,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.573706,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.734834,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.871327,
      1,
      NULL,
      1.592194,
      1,
      2,
      1.847808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.992047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.238187,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.439536,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.834547,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0.706747,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.754744,
      2.536473,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.588503,
      NULL,
      1,
      NULL,
      NULL,
      1.841601,
      NULL,
      NULL,
      0.538349,
      NULL,
      0,
      25.484980,
      0,
      0,
      3,
      1.042781,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993233,
      1,
      1,
      0.097929,
      0.349025,
      1.188369,
      0.162229,
      NULL,
      1.631152,
      1,
      NULL,
      2.980416,
      NULL,
      1.627776,
      NULL,
      0.452076,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      176,
      NULL,
      NULL,
      0.219689,
      22,
      0,
      1.835575,
      NULL,
      NULL,
      0,
      NULL,
      0.352924,
      NULL,
      1.626312,
      NULL,
      0.211185,
      NULL,
      0.352619,
      NULL,
      0.702626,
      NULL,
      0,
      NULL,
      0.865174,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.805114,
      NULL,
      NULL,
      NULL,
      1,
      0.258447,
      1.386033,
      1.057569,
      NULL,
      2.281964,
      NULL,
      3.991568,
      NULL,
      NULL,
      NULL,
      3.618100,
      NULL,
      0.101533,
      NULL,
      0.063947,
      NULL,
      0.770810,
      NULL,
      3,
      NULL,
      1.703438,
      NULL,
      0.789712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.351492,
      NULL,
      1.179978,
      0.503764,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439546,
      NULL,
      1139.534215,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579050,
      0.843014,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      990,
      NULL,
      2.644123,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.729650,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.202707,
      NULL,
      889.298067,
      NULL,
      1,
      NULL,
      0.599985,
      NULL,
      0.675176,
      1,
      3.973149,
      9.203769,
      NULL,
      1.102487,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692718,
      0,
      1,
      0.091660,
      1.829740,
      1.807618,
      0.082846,
      1,
      0,
      2,
      0.663138,
      1.758192,
      NULL,
      NULL,
      1.527088,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1.673194,
      NULL,
      1.895921,
      0.205603,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262337,
      1.806620,
      NULL,
      NULL,
      1,
      NULL,
      1.319515,
      1.247173,
      NULL,
      0,
      0.681601,
      NULL,
      2,
      0.142593,
      0.083278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498257,
      0.822958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356485,
      NULL,
      1.609506,
      NULL,
      6.514254,
      4,
      3.134243,
      3,
      1.196210,
      1.373778,
      9.268810,
      43.560454,
      5,
      0.740797,
      2.020297,
      '14203',
      '43320',
      '',
      0,
      '',
      '',
      '',
      1.445980,
      '',
      '',
      '');
commit;
end;
/


