set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8812417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3.296968,
      7.488165,
      3,
      6.828003,
      3.414710,
      3.899672,
      2,
      '034',
      '11040130',
      18,
      32,
      '2113410',
      3,
      1.124105,
      0,
      1,
      '3232',
      2.828782,
      NULL,
      NULL,
      NULL,
      ' 2-13-1994',
      44,
      50.156938,
      NULL,
      0.419421,
      1.901185,
      '10-23-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1996',
      NULL,
      ' 1-19-1979',
      2.288824,
      3.557205,
      NULL,
      1.489263,
      0.345693,
      0.974166,
      1.376051,
      NULL,
      NULL,
      1,
      NULL,
      6.113092,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.737600,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1.472180,
      0.529318,
      1,
      4,
      NULL,
      5,
      11,
      NULL,
      1,
      6.951682,
      0.194910,
      0,
      NULL,
      1.221347,
      0.358513,
      3.278075,
      3.410203,
      0.029246,
      3,
      0.669522,
      1,
      5,
      0,
      NULL,
      3.497355,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334733,
      NULL,
      NULL,
      6.283803,
      1,
      4.534661,
      3.898061,
      1,
      1,
      NULL,
      0.702806,
      1,
      NULL,
      3.784898,
      NULL,
      NULL,
      1.759241,
      1.930175,
      1.982072,
      3.546545,
      0.676394,
      0,
      1.916303,
      0.296619,
      NULL,
      NULL,
      0,
      3.761546,
      1.221793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.892499,
      8,
      0,
      0.140174,
      7,
      NULL,
      2.539432,
      NULL,
      1,
      6.512707,
      NULL,
      NULL,
      NULL,
      5,
      0.568113,
      0,
      1,
      1,
      NULL,
      NULL,
      1.245328,
      1,
      2,
      NULL,
      NULL,
      1,
      1,
      0.905880,
      0.799995,
      1,
      NULL,
      NULL,
      NULL,
      3.173512,
      1,
      3,
      NULL,
      0,
      1.403381,
      NULL,
      4,
      6.522172,
      NULL,
      4,
      3,
      1,
      2,
      1,
      ' 3- 8-1983',
      709.580838,
      ' 9-14-1995',
      258,
      1.967408,
      0,
      1,
      4,
      3,
      NULL,
      3.861109,
      1.661444,
      1.682860,
      NULL,
      1,
      NULL,
      3,
      6.489583,
      0,
      0,
      1,
      1.229964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.127701,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.837166,
      1,
      1.750017,
      2.795041,
      0.803877,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.755265,
      NULL,
      NULL,
      0,
      4.528607,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186862,
      NULL,
      1.616420,
      0.758165,
      0.562731,
      NULL,
      NULL,
      0.064656,
      6,
      NULL,
      1.729601,
      NULL,
      NULL,
      NULL,
      3.401167,
      3.892170,
      2,
      2.917711,
      1.765573,
      0.816469,
      NULL,
      0,
      NULL,
      2,
      2.660697,
      NULL,
      1,
      0.021939,
      3,
      0.625600,
      NULL,
      0.902972,
      0.776719,
      2,
      0.535797,
      NULL,
      NULL,
      0,
      0,
      0.668767,
      0,
      1,
      NULL,
      NULL,
      3.026931,
      1,
      0.619833,
      7.560341,
      0,
      0.515610,
      4,
      4,
      2,
      3.141113,
      NULL,
      NULL,
      0,
      2.147836,
      48,
      0.167445,
      1,
      7.677744,
      NULL,
      66.123357,
      33,
      5,
      2.819804,
      4.350832,
      '01003',
      NULL,
      '',
      1.250637,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      1,
      190.447592,
      45.796980,
      1.326347,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.700156,
      1.247048,
      NULL,
      NULL,
      1.601995,
      NULL,
      NULL,
      3,
      0,
      0.619441,
      0.955979,
      NULL,
      NULL,
      1.894179,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.241859,
      NULL,
      NULL,
      1.351800,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.093363,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      4.913674,
      2,
      1.027292,
      0.241237,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.348718,
      NULL,
      NULL,
      1,
      2.008155,
      0,
      2,
      NULL,
      2.602869,
      1.942592,
      0.330294,
      1,
      NULL,
      NULL,
      0.329222,
      0,
      0.499215,
      NULL,
      1,
      0,
      0,
      1.989083,
      NULL,
      NULL,
      NULL,
      1.245130,
      NULL,
      NULL,
      2,
      1.310687,
      NULL,
      2.558149,
      5.970892,
      NULL,
      0,
      0.928088,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      3,
      NULL,
      0.656961,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.701153,
      NULL,
      3.482382,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.201098,
      0.569942,
      1.213967,
      1,
      NULL,
      NULL,
      0.305051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277361,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.057336,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.381434,
      3,
      NULL,
      5,
      3.442609,
      1,
      NULL,
      NULL,
      1.778092,
      NULL,
      NULL,
      0.145055,
      3.181982,
      3,
      2,
      0,
      0,
      0.853626,
      NULL,
      NULL,
      2.555385,
      0.677441,
      5.987041,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      0.313036,
      3,
      2.199584,
      NULL,
      4.171449,
      NULL,
      1.309799,
      NULL,
      NULL,
      1.422295,
      NULL,
      4.800872,
      1.898474,
      0.890505,
      NULL,
      NULL,
      0,
      3.431334,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215815,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108775,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.071558,
      1.992791,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.429941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.413643,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773957,
      NULL,
      NULL,
      0.556901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.397682,
      345.015815,
      8.693339,
      0.383462,
      2,
      1,
      0.604729,
      1.234636,
      0.104047,
      1,
      2.438560,
      NULL,
      0,
      0.151044,
      1.296879,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.557109,
      NULL,
      NULL,
      0,
      1.851967,
      NULL,
      0.810992,
      0,
      NULL,
      1.738515,
      0,
      1,
      25,
      0.025836,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.073649,
      0,
      0.682291,
      NULL,
      NULL,
      0.394726,
      0,
      NULL,
      0.071301,
      0,
      1.964365,
      1,
      NULL,
      1.408739,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.808833,
      0,
      1,
      0,
      0.065555,
      0,
      NULL,
      0.965537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265272,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.381382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.873036,
      2,
      20,
      NULL,
      0.456063,
      3,
      0,
      1,
      1.938077,
      0,
      0,
      0,
      1,
      NULL,
      1.495773,
      NULL,
      NULL,
      NULL,
      1.660812,
      2,
      3.539508,
      0,
      3,
      NULL,
      NULL,
      5,
      11,
      0,
      1.046972,
      0.899866,
      2,
      1.645467,
      NULL,
      0.221911,
      0.709054,
      NULL,
      NULL,
      3,
      NULL,
      0.728902,
      0.645203,
      NULL,
      1.383623,
      0,
      NULL,
      0,
      0.600652,
      NULL,
      0,
      1,
      NULL,
      1.417419,
      1.518018,
      NULL,
      NULL,
      0.482869,
      NULL,
      0.108986,
      1.656192,
      NULL,
      2.620277,
      0,
      NULL,
      3,
      0,
      1.538704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050035,
      NULL,
      1.152219,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.973163,
      NULL,
      0.757986,
      0,
      6,
      NULL,
      1,
      0,
      4,
      '02123',
      '12103',
      '22412',
      1.516078,
      NULL,
      NULL,
      NULL,
      0.747489,
      '',
      '',
      '');
commit;
end;
/


