set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9223065';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '4131314',
      2,
      1.348924,
      0,
      NULL,
      '3443',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1994',
      54.356484,
      NULL,
      5.338838,
      0,
      0.477434,
      '11-10-1975',
      NULL,
      2.745420,
      224,
      127.699436,
      0.426291,
      ' 3- 9-1984',
      '11-26-2002',
      ' 1- 8-2001',
      NULL,
      3,
      2,
      3,
      NULL,
      3,
      2,
      0.162436,
      0.802682,
      107,
      7.825913,
      15,
      4.671701,
      24.414859,
      8.076999,
      2,
      4.282509,
      2,
      4.225467,
      1.124858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.181091,
      NULL,
      NULL,
      2,
      1.372890,
      0.394429,
      NULL,
      0,
      3,
      6.951759,
      4,
      0,
      NULL,
      1.400497,
      0,
      NULL,
      1,
      0,
      3,
      2.283784,
      0.824395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959774,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1.538147,
      0.093893,
      1,
      1.108306,
      NULL,
      0,
      1,
      3.646751,
      1.172462,
      1.239145,
      NULL,
      1,
      3.266607,
      1,
      5,
      NULL,
      1,
      4,
      1.764957,
      NULL,
      NULL,
      1.454929,
      NULL,
      NULL,
      NULL,
      NULL,
      2.781927,
      1,
      3.839769,
      8.123191,
      9.215572,
      0.414823,
      5,
      0.540592,
      4.754839,
      0,
      0.692928,
      4.208899,
      NULL,
      0.062758,
      1.597620,
      1,
      0,
      NULL,
      1.675397,
      0.496135,
      7,
      8.450360,
      1.751699,
      NULL,
      5.298399,
      5,
      1.390255,
      1.584506,
      7,
      5.730782,
      5.742006,
      NULL,
      1,
      5,
      3,
      NULL,
      3,
      3.577239,
      0.956335,
      2,
      3.950871,
      2,
      NULL,
      1.404012,
      0.453793,
      1.644471,
      ' 8- 9-2002',
      NULL,
      ' 4-27-1983',
      18,
      0.355646,
      1,
      NULL,
      NULL,
      1.161834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.210527,
      NULL,
      0.252805,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.386563,
      NULL,
      NULL,
      1.951593,
      1.993593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.545043,
      0.413269,
      1.564882,
      1,
      1,
      0.158425,
      0,
      1,
      NULL,
      0.083287,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      3.613020,
      2,
      0,
      2.804348,
      1,
      NULL,
      3.832277,
      NULL,
      1,
      2,
      2,
      2,
      0.640649,
      NULL,
      0,
      0.602185,
      NULL,
      0,
      0,
      0.148882,
      0.959631,
      1,
      1,
      0,
      0.065041,
      0.565047,
      1.111721,
      9.653462,
      7.243601,
      2,
      11.869949,
      1,
      5,
      2,
      NULL,
      5,
      3.654030,
      2.072967,
      1,
      68.984477,
      0,
      NULL,
      NULL,
      5,
      25,
      68.484774,
      1.603473,
      NULL,
      3.807224,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      1.146492,
      '',
      '',
      '',
      NULL,
      NULL,
      70.957725,
      28,
      1.014666,
      23,
      1,
      2.330634,
      NULL,
      3.878824,
      2,
      2,
      1,
      NULL,
      NULL,
      0.162317,
      NULL,
      NULL,
      NULL,
      2.922000,
      3,
      1.572092,
      NULL,
      NULL,
      0.067351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.760990,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.127648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.926474,
      7,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.527299,
      3,
      3.462526,
      1.801908,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.625763,
      NULL,
      0,
      1.736302,
      0.399440,
      3,
      3.922081,
      3,
      NULL,
      NULL,
      1,
      1.113383,
      3.664520,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556663,
      NULL,
      NULL,
      NULL,
      0.011418,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.835077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      1.814751,
      3,
      0.590225,
      NULL,
      NULL,
      NULL,
      6.396809,
      4.164042,
      0,
      0,
      1,
      1.472617,
      NULL,
      NULL,
      5.152877,
      2.339209,
      4,
      1,
      NULL,
      NULL,
      1.611174,
      NULL,
      NULL,
      1.535309,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.185031,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.784070,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      7.081881,
      4.821837,
      8.275721,
      NULL,
      2,
      3.868077,
      0.866971,
      NULL,
      NULL,
      2.081470,
      NULL,
      1.394240,
      1.317889,
      2,
      4.287243,
      2,
      4.648953,
      NULL,
      0.990364,
      2,
      NULL,
      NULL,
      NULL,
      2.699283,
      1.699289,
      NULL,
      3,
      0,
      1.236978,
      NULL,
      1,
      1.881165,
      1.746101,
      2.991092,
      NULL,
      3,
      0,
      9.751350,
      1,
      3.740002,
      NULL,
      1,
      0.655821,
      1.425009,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      15.659755,
      NULL,
      NULL,
      0.484403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.542140,
      NULL,
      NULL,
      0.843311,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.785594,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      2.903032,
      0.452310,
      0,
      0.239770,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.337847,
      NULL,
      NULL,
      NULL,
      1.450152,
      NULL,
      NULL,
      NULL,
      0.217041,
      NULL,
      NULL,
      NULL,
      0.077747,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.111676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.840962,
      NULL,
      NULL,
      NULL,
      3.341781,
      NULL,
      NULL,
      NULL,
      1.359050,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.439928,
      NULL,
      NULL,
      NULL,
      1.639942,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.653273,
      NULL,
      NULL,
      NULL,
      1.468498,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.927387,
      0.157320,
      53,
      0.303947,
      51.742465,
      1.267134,
      1.058966,
      NULL,
      NULL,
      2.642163,
      1.470157,
      0.014370,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      814.201176,
      10,
      0.263344,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0.621109,
      1.076140,
      1.743456,
      0.833778,
      0.011649,
      NULL,
      0.455807,
      NULL,
      1.264015,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.998429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.269300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640212,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.478101,
      NULL,
      0.524401,
      0.113428,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484103,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802111,
      2.722096,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.487864,
      1.086888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.739426,
      1.623976,
      3,
      5.825741,
      0.098073,
      0,
      NULL,
      6,
      2,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.718339,
      1.853539,
      0.206365,
      1.992893,
      NULL,
      2.089737,
      0,
      0,
      1.206422,
      2.372918,
      1.064726,
      NULL,
      1,
      NULL,
      3,
      1,
      0,
      3.751931,
      NULL,
      0.338601,
      3,
      1,
      2.393083,
      0,
      2.718746,
      2.219609,
      0.768282,
      NULL,
      2.217091,
      2,
      3.759311,
      1,
      1.172328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.862101,
      0.414607,
      1.723550,
      7.849872,
      9.182170,
      1.870600,
      NULL,
      NULL,
      53,
      2,
      NULL,
      1.991323,
      0.067654,
      '13340',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


