set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627387';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '4221340',
      2,
      0,
      2,
      NULL,
      '3021',
      0,
      NULL,
      NULL,
      NULL,
      ' 4-13-1997',
      50.135241,
      NULL,
      NULL,
      0.428077,
      2,
      ' 6-22-1987',
      34,
      NULL,
      204.823395,
      48,
      0,
      ' 5- 4-1979',
      ' 4- 1-2003',
      ' 7-24-1999',
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.838357,
      2.560496,
      NULL,
      NULL,
      NULL,
      1.115993,
      2,
      NULL,
      12,
      3.229160,
      14.197540,
      3,
      2,
      9.549665,
      0,
      1.994049,
      1.527385,
      0.714918,
      0,
      NULL,
      NULL,
      1.222902,
      0.839390,
      1.766823,
      1,
      7.286268,
      0.070812,
      0,
      2,
      5,
      0.504432,
      NULL,
      NULL,
      6.150699,
      NULL,
      NULL,
      NULL,
      0.583747,
      4.570634,
      NULL,
      0,
      9.909466,
      0,
      2,
      0,
      0.469860,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.517959,
      1,
      1,
      0.885699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445637,
      1.146485,
      1.104012,
      0,
      1.233545,
      1.553190,
      3,
      NULL,
      1,
      NULL,
      1,
      1.716378,
      0,
      6.898481,
      1.531139,
      1.530480,
      1,
      NULL,
      1.102421,
      NULL,
      0,
      0.644425,
      3.560403,
      1.519444,
      1.266787,
      0,
      4,
      NULL,
      0,
      1.254845,
      NULL,
      1,
      1.097912,
      4.104885,
      NULL,
      5,
      NULL,
      1,
      2,
      1.154552,
      1,
      NULL,
      5,
      4.264275,
      5,
      3,
      1,
      0.469765,
      ' 9- 0-1976',
      33,
      ' 0- 3-1978',
      8.594143,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611292,
      NULL,
      5,
      NULL,
      0.388698,
      0,
      1.414032,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.661650,
      1,
      1.960764,
      3.529627,
      1.042806,
      1.030672,
      0,
      1,
      1.284381,
      1,
      0.759079,
      4,
      1.349530,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.339869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      2.215177,
      17,
      1.375493,
      0.446716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640687,
      4.220445,
      2.692166,
      5,
      1.121975,
      0.400239,
      4.951141,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.032957,
      0.163867,
      0,
      0,
      3,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      2,
      1,
      8.482140,
      8,
      2,
      NULL,
      1,
      6,
      4,
      NULL,
      4,
      2,
      0.704303,
      2.402020,
      36,
      2.504625,
      3.716616,
      NULL,
      39.154235,
      NULL,
      34,
      3.168954,
      4,
      NULL,
      '30132',
      '34410',
      '02434',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      39,
      53,
      16,
      1.542843,
      36.523346,
      0,
      3,
      NULL,
      2.706572,
      1,
      0.381571,
      1.925266,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.786184,
      1,
      1.731861,
      3,
      2.018006,
      0,
      1.309629,
      0,
      1,
      NULL,
      0,
      0.287964,
      0.737138,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.870474,
      0.637032,
      2,
      1,
      0,
      NULL,
      NULL,
      5,
      NULL,
      0.754988,
      NULL,
      1.682778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.818350,
      0,
      3,
      3.627084,
      0.518526,
      3.179448,
      3,
      1.486102,
      3.490045,
      0,
      0.773942,
      1,
      2,
      1.120580,
      1,
      NULL,
      0,
      NULL,
      2.414738,
      NULL,
      0,
      1,
      2.556457,
      3.470211,
      1,
      0.467933,
      1.430988,
      0,
      NULL,
      NULL,
      0.827551,
      NULL,
      NULL,
      7,
      0,
      NULL,
      1.764572,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306795,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.210898,
      NULL,
      NULL,
      0.512424,
      NULL,
      NULL,
      1.728110,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      7.098140,
      1.201277,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.799333,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      3,
      2.550032,
      0.406034,
      2.888350,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1.640234,
      1,
      NULL,
      NULL,
      3,
      1.589031,
      NULL,
      NULL,
      NULL,
      2.348263,
      5,
      1.544111,
      0.122177,
      1,
      0,
      2,
      2.353318,
      0.010260,
      1,
      3.669344,
      0.311036,
      2.398335,
      1,
      0,
      5,
      3,
      1.557380,
      3,
      0.627914,
      0.043457,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.489122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.927566,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.848359,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168564,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.494152,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      4.186413,
      1,
      NULL,
      NULL,
      3.844173,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975365,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.031884,
      NULL,
      NULL,
      NULL,
      1.625843,
      NULL,
      NULL,
      NULL,
      3.094682,
      NULL,
      NULL,
      NULL,
      1.242895,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.223282,
      1.915529,
      NULL,
      NULL,
      2.158548,
      1.250742,
      NULL,
      NULL,
      1.528518,
      0.905591,
      NULL,
      NULL,
      0.025975,
      1.188477,
      NULL,
      NULL,
      1.962692,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1.691948,
      0.086692,
      8,
      0,
      3,
      NULL,
      2,
      NULL,
      3.259421,
      1.536015,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.434820,
      NULL,
      NULL,
      1.656490,
      NULL,
      1.229110,
      35.423869,
      0,
      0,
      1,
      1.025754,
      0.144901,
      1,
      3,
      0,
      3.983225,
      1,
      3.262137,
      1.472448,
      1.880331,
      1.847274,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      2.017887,
      12.238558,
      32.811916,
      2,
      0.169225,
      NULL,
      NULL,
      0.803207,
      NULL,
      2.156232,
      NULL,
      NULL,
      NULL,
      1.159261,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.740272,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.502543,
      NULL,
      0,
      3.928768,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.813133,
      NULL,
      NULL,
      NULL,
      0.131661,
      NULL,
      0.917887,
      NULL,
      NULL,
      NULL,
      1,
      0.784881,
      NULL,
      NULL,
      1,
      NULL,
      0.034375,
      NULL,
      NULL,
      NULL,
      1.366916,
      NULL,
      0.659429,
      NULL,
      0.815939,
      NULL,
      0.552857,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536851,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.840061,
      NULL,
      0,
      1,
      2.197833,
      0.373648,
      1,
      NULL,
      496.571174,
      0.311531,
      0,
      0,
      NULL,
      1,
      1.737884,
      NULL,
      0,
      NULL,
      51,
      1.036025,
      NULL,
      NULL,
      NULL,
      4.591920,
      NULL,
      2,
      1.795623,
      4,
      5.725935,
      0.656676,
      0.828501,
      15.972892,
      0,
      3.908091,
      3.798429,
      1,
      NULL,
      0,
      1.964335,
      3,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      0.731838,
      0.732405,
      0,
      0,
      0,
      1.488780,
      1,
      0,
      1.765648,
      NULL,
      1.652169,
      NULL,
      NULL,
      NULL,
      1,
      0.470999,
      1.217070,
      1.022885,
      1,
      1,
      0.661890,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348264,
      1.913867,
      1,
      0,
      0.026585,
      0,
      1.431685,
      5.057752,
      7.459733,
      1.294728,
      NULL,
      NULL,
      NULL,
      21.550339,
      NULL,
      3,
      1,
      '40310',
      '10114',
      '03430',
      1.733206,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


