set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      '11',
      45,
      30.278596,
      '4130132',
      3.744897,
      0.653076,
      NULL,
      2,
      '0013',
      1,
      1.958976,
      NULL,
      NULL,
      ' 7-20-1983',
      147.686421,
      2.750287,
      NULL,
      0.904500,
      1,
      ' 4-10-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 5-1987',
      ' 1-29-1975',
      0,
      NULL,
      2,
      0.810532,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437308,
      NULL,
      1.750280,
      NULL,
      1.225447,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.442317,
      1,
      0,
      1.546995,
      0.954400,
      0,
      0.412517,
      2,
      5.958529,
      0.947072,
      0,
      0.926635,
      5.721548,
      0.070746,
      2,
      1.687649,
      NULL,
      3.910393,
      0.155181,
      0,
      0,
      NULL,
      2,
      3.129645,
      1,
      NULL,
      7,
      1,
      0.485592,
      0,
      0.953812,
      1,
      1.984689,
      NULL,
      NULL,
      1.275591,
      NULL,
      NULL,
      0.358281,
      1.406049,
      0,
      3,
      1,
      1,
      1,
      1,
      2,
      0.812160,
      NULL,
      0.576566,
      NULL,
      0,
      0.248514,
      1,
      2.392920,
      1.339598,
      3,
      1.095434,
      NULL,
      2,
      4,
      NULL,
      1.875960,
      1.928617,
      NULL,
      NULL,
      NULL,
      0.020603,
      NULL,
      NULL,
      1,
      2.640553,
      0.344815,
      1,
      7,
      7.032193,
      0,
      0.426506,
      2,
      2,
      0,
      3.768557,
      3.237231,
      6.548578,
      0.244201,
      0,
      0,
      0,
      0,
      NULL,
      1,
      2.314712,
      3.580279,
      4,
      NULL,
      0.291794,
      8.591661,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.767041,
      4,
      0.258959,
      1.168301,
      0,
      0,
      NULL,
      4.971588,
      0,
      8.432856,
      NULL,
      0.183868,
      7.068304,
      3,
      0,
      1.741957,
      ' 7-11-1975',
      696,
      '10- 4-1985',
      9.060563,
      0,
      0,
      0,
      4.112449,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      4,
      3.803967,
      4.062234,
      0.635588,
      0.486227,
      0.221156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.001012,
      5.521069,
      NULL,
      2.782682,
      1,
      0.221622,
      NULL,
      5.963422,
      0,
      0.195361,
      NULL,
      2,
      0.200749,
      3.397225,
      NULL,
      NULL,
      1.735500,
      NULL,
      1.825044,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086025,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.423061,
      0.210789,
      NULL,
      1.530458,
      1,
      NULL,
      0,
      2.234176,
      NULL,
      0.413122,
      0,
      NULL,
      NULL,
      NULL,
      1.233264,
      NULL,
      0,
      NULL,
      3,
      2.369772,
      1.565940,
      1.163644,
      0.471536,
      NULL,
      NULL,
      1.220036,
      NULL,
      2,
      3.421586,
      NULL,
      0,
      1.666928,
      0,
      0,
      NULL,
      0.709416,
      0,
      0,
      0.081047,
      0.616765,
      1,
      1.106905,
      1.520415,
      0,
      1.651455,
      1.029374,
      10,
      8.215209,
      0.778443,
      2,
      11,
      3.254045,
      4.853939,
      0,
      4,
      0,
      2.850168,
      1,
      28,
      NULL,
      0,
      NULL,
      NULL,
      6,
      66.920007,
      5,
      4,
      3,
      '24314',
      '',
      '',
      0.442116,
      '',
      NULL,
      '',
      1.457420,
      '',
      '',
      '',
      2.103905,
      11.884945,
      NULL,
      49.352516,
      3,
      9.638454,
      4,
      3.311830,
      0.694707,
      1.874968,
      1,
      2,
      1.110255,
      NULL,
      NULL,
      0.517389,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276038,
      NULL,
      NULL,
      1,
      0,
      1.928424,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0.488532,
      0,
      0,
      NULL,
      NULL,
      1,
      0.146176,
      0.117414,
      5.840574,
      2.985823,
      2,
      0,
      0.505551,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.976094,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.439908,
      NULL,
      1.075311,
      0.551730,
      1.372039,
      1,
      NULL,
      1.833904,
      2.600860,
      1.835226,
      0,
      1,
      NULL,
      3.436821,
      3.605124,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.173780,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.211268,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.271461,
      0.358557,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      0.292782,
      1.699971,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.933839,
      1,
      2.550431,
      1,
      NULL,
      NULL,
      9.019803,
      1.311453,
      3.364569,
      0,
      4.742554,
      4,
      2,
      NULL,
      NULL,
      2.425151,
      1.824901,
      NULL,
      1.920280,
      NULL,
      NULL,
      0.891969,
      3,
      NULL,
      5,
      4,
      4,
      1,
      1,
      2,
      2.636821,
      1.643977,
      3.446179,
      3.401408,
      0.314289,
      0,
      0,
      NULL,
      1,
      NULL,
      4.347664,
      5.872438,
      2.390673,
      NULL,
      NULL,
      NULL,
      5,
      0.543903,
      1,
      0,
      0,
      1.284052,
      0,
      1.929900,
      NULL,
      NULL,
      0.208830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.596732,
      NULL,
      NULL,
      1.454445,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.209576,
      NULL,
      NULL,
      1.332370,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.728983,
      1,
      1.244032,
      NULL,
      0.446144,
      NULL,
      2.244253,
      NULL,
      NULL,
      1,
      2.349114,
      NULL,
      NULL,
      12.650574,
      NULL,
      NULL,
      NULL,
      1.328630,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.437752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.510626,
      NULL,
      NULL,
      1.372938,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.788891,
      0,
      NULL,
      NULL,
      5.775194,
      3,
      NULL,
      NULL,
      1.746136,
      NULL,
      NULL,
      NULL,
      3.970415,
      NULL,
      5.275149,
      2,
      21,
      NULL,
      1,
      NULL,
      NULL,
      1.663080,
      NULL,
      NULL,
      1.340124,
      NULL,
      NULL,
      1.611728,
      NULL,
      NULL,
      0,
      NULL,
      0,
      30.514248,
      1,
      1.273661,
      0,
      NULL,
      1,
      0.172832,
      NULL,
      0,
      1.902704,
      0,
      0.965422,
      NULL,
      NULL,
      0.133093,
      1.420465,
      1,
      1.566489,
      1,
      1.748021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.148839,
      2.092851,
      1.085735,
      0.721158,
      0.549340,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0.872217,
      0.288120,
      0,
      1.820594,
      0,
      1,
      1,
      1.909654,
      0.420401,
      1.955168,
      0.787603,
      0,
      0.684630,
      NULL,
      1.912332,
      1,
      0.140216,
      0.228834,
      0.699173,
      1.828517,
      1,
      1.914159,
      1.938254,
      NULL,
      1,
      0.518482,
      1,
      1.880023,
      1,
      2.202661,
      3.735293,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.682724,
      0,
      1,
      1,
      1.562171,
      NULL,
      0.317350,
      0.894025,
      0.772028,
      NULL,
      NULL,
      1.984681,
      1,
      0,
      1.449546,
      NULL,
      0,
      NULL,
      0.018237,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.144852,
      0.782601,
      4,
      0.337912,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.796038,
      NULL,
      2.056344,
      1.472858,
      3.337991,
      0.454595,
      NULL,
      NULL,
      87,
      NULL,
      3.431386,
      2,
      NULL,
      '33300',
      '01100',
      '',
      0,
      NULL,
      '',
      '',
      1.793039,
      '',
      '',
      '');
commit;
end;
/


