set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '3044233',
      2,
      0.008610,
      1,
      NULL,
      '2200',
      0.656202,
      1,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      1.836760,
      1.286140,
      1.974960,
      ' 8-13-1980',
      37.373679,
      3.472759,
      38.850723,
      48,
      1,
      ' 1-10-1982',
      ' 2- 2-2001',
      ' 6-28-1993',
      3.587065,
      3.386346,
      1.651668,
      0,
      1.197410,
      NULL,
      1.531191,
      0,
      NULL,
      NULL,
      NULL,
      5.921982,
      0.621346,
      17.106524,
      NULL,
      6,
      3.093987,
      3,
      0.550260,
      NULL,
      0,
      1,
      NULL,
      0.605475,
      NULL,
      1.489223,
      1,
      NULL,
      1.008078,
      0.450930,
      NULL,
      3.897140,
      NULL,
      5.046976,
      2.305801,
      1,
      1,
      1,
      0,
      NULL,
      1.855138,
      NULL,
      0,
      NULL,
      1.982378,
      1,
      1,
      0,
      1.711517,
      NULL,
      2.799085,
      1,
      1.249560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.912278,
      1.607437,
      1.257154,
      NULL,
      0,
      NULL,
      0,
      1,
      2.743215,
      1.478614,
      1,
      1,
      0.385142,
      2.741696,
      1.685512,
      2,
      1.793614,
      2.426166,
      1.147858,
      1,
      0,
      4,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.074360,
      4.509606,
      1.924767,
      2.136172,
      NULL,
      4,
      NULL,
      0,
      4,
      2,
      1.608183,
      NULL,
      0.239751,
      1.252789,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0.800751,
      0.186353,
      1.815485,
      NULL,
      0.881354,
      1.761160,
      1,
      0,
      0.842538,
      0.131554,
      0.480904,
      NULL,
      1.846558,
      1.313018,
      5,
      7.854919,
      6.443788,
      NULL,
      0,
      3,
      1.340286,
      1,
      NULL,
      1.882920,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.547864,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004699,
      4,
      0.305949,
      NULL,
      0,
      NULL,
      0.566258,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.725095,
      2,
      1,
      NULL,
      NULL,
      NULL,
      5.784184,
      2,
      NULL,
      5,
      NULL,
      2.956973,
      0,
      NULL,
      NULL,
      NULL,
      0.403853,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.072992,
      NULL,
      1,
      0.089072,
      13,
      1.267889,
      1.257919,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.228524,
      0.920185,
      2,
      NULL,
      0.591324,
      1,
      0,
      1,
      1.367293,
      1,
      2.209380,
      3,
      0.672087,
      NULL,
      1,
      0.823717,
      1,
      0.527036,
      1.272286,
      0.408594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.030861,
      5.967003,
      1,
      5.205031,
      11,
      NULL,
      3,
      NULL,
      6.396564,
      3.219105,
      3.063403,
      2.483458,
      NULL,
      NULL,
      NULL,
      57,
      2.023464,
      3.815020,
      NULL,
      3,
      82.588124,
      97.238598,
      1,
      0,
      5.378069,
      '42140',
      '00333',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.830470,
      '0034',
      '1111',
      '',
      1.681325,
      29,
      33.070970,
      1,
      1.369422,
      16,
      1.732729,
      45.226511,
      2.274316,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.175535,
      NULL,
      NULL,
      2.423328,
      NULL,
      NULL,
      3,
      3.891411,
      NULL,
      3,
      0.147608,
      NULL,
      3.885413,
      0.802098,
      2,
      1,
      NULL,
      NULL,
      2.558879,
      0.308193,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11,
      3.190434,
      3.622211,
      0,
      NULL,
      NULL,
      NULL,
      1.676553,
      NULL,
      NULL,
      NULL,
      0,
      2.316939,
      3.525292,
      0,
      NULL,
      NULL,
      1.475951,
      NULL,
      NULL,
      NULL,
      3.203207,
      0,
      1.960048,
      0.528016,
      1.378914,
      0.060438,
      NULL,
      1.290533,
      3,
      1.713723,
      1,
      1.768570,
      3.466370,
      1.294687,
      2.109255,
      1,
      NULL,
      NULL,
      1.804531,
      NULL,
      NULL,
      1.255792,
      0.795286,
      1,
      4.186925,
      6.635741,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.402626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.665081,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      NULL,
      0.661905,
      3,
      1.370329,
      2.418891,
      5,
      4.368066,
      3.577204,
      0,
      NULL,
      NULL,
      0.255441,
      NULL,
      NULL,
      0.855521,
      NULL,
      NULL,
      0.329023,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.943826,
      NULL,
      0.532184,
      NULL,
      NULL,
      3.585629,
      0.139581,
      1,
      3,
      4,
      5.763240,
      1.132900,
      NULL,
      NULL,
      NULL,
      2.664361,
      3.838028,
      1,
      3,
      NULL,
      0.751537,
      2.194146,
      NULL,
      4,
      NULL,
      NULL,
      3.253075,
      1.873225,
      0.094851,
      0,
      NULL,
      NULL,
      3,
      1,
      3.042252,
      1.980292,
      1.124346,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.541912,
      NULL,
      0,
      3.324984,
      0,
      1.806897,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      5.984568,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.444326,
      NULL,
      NULL,
      3.729444,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.688227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.262976,
      NULL,
      NULL,
      0,
      0.648274,
      NULL,
      1.330150,
      1,
      0.078431,
      1.647954,
      NULL,
      NULL,
      1.771395,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.245803,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      2.461134,
      NULL,
      NULL,
      3.683103,
      2,
      NULL,
      NULL,
      1.976690,
      1,
      NULL,
      NULL,
      1.187841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621748,
      0.712796,
      NULL,
      NULL,
      3,
      1.764750,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      6.131311,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.839213,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.246582,
      NULL,
      0,
      1111.723010,
      10,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.611819,
      NULL,
      3.462142,
      0.696140,
      0,
      0.519909,
      2.303466,
      NULL,
      1,
      1.809978,
      3.078293,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.937916,
      NULL,
      NULL,
      NULL,
      83.362277,
      NULL,
      1.957938,
      NULL,
      31.958882,
      NULL,
      2,
      0,
      NULL,
      0.542277,
      NULL,
      0.621582,
      NULL,
      NULL,
      NULL,
      1.613481,
      NULL,
      1.667859,
      NULL,
      1,
      NULL,
      1.570267,
      NULL,
      0.460288,
      NULL,
      0.732132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.618991,
      NULL,
      0.235147,
      NULL,
      0.459887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.639652,
      4,
      3,
      3,
      1,
      9.928394,
      2.386218,
      3.986673,
      NULL,
      1.871414,
      NULL,
      1.595338,
      0,
      1,
      1.811236,
      1,
      0.540765,
      0,
      0.717760,
      0.825343,
      1,
      2,
      0,
      NULL,
      0,
      1.221134,
      2,
      1,
      0.861543,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.041226,
      0.099293,
      1.365759,
      NULL,
      NULL,
      0,
      0.534382,
      3,
      1,
      3.348363,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.252075,
      1,
      4,
      5.393844,
      3,
      0,
      NULL,
      NULL,
      NULL,
      103.614010,
      NULL,
      1.056198,
      3.371488,
      NULL,
      '34130',
      '',
      1.212813,
      '',
      '',
      '',
      NULL,
      '4021',
      '3021',
      '');
commit;
end;
/


