set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '3344403',
      1.688451,
      NULL,
      6,
      2,
      '2300',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-22-1974',
      3,
      NULL,
      5,
      NULL,
      1.772834,
      NULL,
      33,
      3,
      NULL,
      25.246044,
      NULL,
      ' 8-27-1995',
      ' 0-10-1994',
      NULL,
      3.503674,
      3,
      1.761665,
      0.614742,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3.702303,
      NULL,
      9.768027,
      NULL,
      NULL,
      6,
      4,
      3,
      3.721491,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.729380,
      0,
      1.553485,
      6,
      1,
      0.416095,
      1.395128,
      1.187180,
      2.800971,
      7,
      NULL,
      NULL,
      3.067819,
      1.856632,
      2,
      NULL,
      NULL,
      8,
      0,
      1.873222,
      NULL,
      2.925156,
      1.899552,
      NULL,
      NULL,
      1.031851,
      NULL,
      NULL,
      3.558115,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      4.854624,
      0.857161,
      0.925051,
      0,
      0.726569,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.762889,
      3.047566,
      0.606539,
      5.241947,
      NULL,
      1,
      0.910080,
      1,
      NULL,
      3,
      1,
      1.048601,
      NULL,
      NULL,
      1.847398,
      0,
      0,
      0,
      NULL,
      0,
      1.047808,
      0,
      1,
      0,
      NULL,
      0.832607,
      1,
      0,
      1.790235,
      1,
      0.851741,
      NULL,
      1,
      5.296457,
      2.400313,
      NULL,
      NULL,
      2.014127,
      2,
      0.279573,
      5.603067,
      3.198647,
      4,
      1.445990,
      0.986732,
      1.200292,
      1,
      ' 5-26-1984',
      385,
      ' 0-25-1976',
      422,
      1,
      1.435393,
      0.823294,
      1.145234,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990206,
      1,
      NULL,
      5,
      0.798079,
      1.383342,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025022,
      1,
      0.772279,
      5.619244,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.216424,
      0.532785,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.634053,
      1.759387,
      1,
      0,
      3,
      0,
      0.332013,
      NULL,
      50.862600,
      2,
      0.143069,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      7,
      2,
      NULL,
      5.955913,
      3.862888,
      6,
      1,
      1,
      3,
      0,
      0,
      1.933655,
      0.451313,
      0,
      NULL,
      1.662140,
      1,
      1,
      0.718236,
      1.375487,
      0.506443,
      NULL,
      1.692285,
      1.224591,
      NULL,
      3,
      7,
      6,
      0,
      5,
      5.378414,
      2.714215,
      NULL,
      0.158782,
      NULL,
      1,
      67.841053,
      NULL,
      NULL,
      NULL,
      21.111639,
      NULL,
      27,
      1,
      1.374006,
      NULL,
      '01232',
      '31032',
      '22141',
      NULL,
      '',
      '',
      NULL,
      0.677373,
      NULL,
      '',
      NULL,
      2,
      1,
      53.711000,
      NULL,
      NULL,
      22,
      0,
      4,
      4.664950,
      NULL,
      3.610329,
      0,
      1.266067,
      NULL,
      NULL,
      NULL,
      1.524934,
      1,
      2.550011,
      2,
      1,
      3.021881,
      3,
      NULL,
      3.698929,
      3.259902,
      1,
      2,
      1.935925,
      1.870137,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.020701,
      NULL,
      NULL,
      0,
      1,
      1.411411,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      0.140013,
      NULL,
      NULL,
      NULL,
      1.542414,
      NULL,
      NULL,
      NULL,
      0.560607,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.266101,
      NULL,
      0.381886,
      1.920883,
      1.540512,
      1.908543,
      2,
      3.412038,
      0.887269,
      1.438690,
      7,
      0.672679,
      2,
      1.868048,
      NULL,
      NULL,
      NULL,
      0.557740,
      NULL,
      NULL,
      NULL,
      0.622776,
      NULL,
      NULL,
      0.254195,
      0,
      1.745497,
      NULL,
      2.427642,
      1,
      1.637404,
      NULL,
      NULL,
      1.883193,
      2.379467,
      1.682700,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.484521,
      4,
      1.629295,
      0.697761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357520,
      NULL,
      NULL,
      0.178121,
      NULL,
      NULL,
      0.327423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530477,
      4,
      0,
      1.314078,
      5,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.923552,
      1.468660,
      2,
      0.454459,
      9,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.321063,
      NULL,
      2.575246,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      5,
      2.932168,
      NULL,
      NULL,
      3.316159,
      3.658483,
      0.734285,
      0,
      1,
      1,
      0.923143,
      1,
      NULL,
      NULL,
      2.057654,
      NULL,
      NULL,
      11.128166,
      NULL,
      NULL,
      1.460493,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.315916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213662,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.731939,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.867058,
      NULL,
      NULL,
      1.907080,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      1,
      0,
      0.294281,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823445,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.430195,
      NULL,
      NULL,
      NULL,
      2.139648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.418312,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.810449,
      NULL,
      NULL,
      7.083659,
      0,
      NULL,
      NULL,
      1.209029,
      NULL,
      NULL,
      1.343164,
      NULL,
      NULL,
      3.623596,
      NULL,
      2,
      1.265124,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512825,
      78,
      31.499803,
      0.804760,
      3,
      0.657542,
      1,
      1,
      1.780700,
      0,
      1.242960,
      NULL,
      NULL,
      0,
      1.870813,
      NULL,
      2,
      0.977110,
      1.646351,
      0.202070,
      0.680766,
      NULL,
      0,
      NULL,
      0.285253,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      98,
      NULL,
      0.284497,
      14.339587,
      28.141124,
      0,
      1,
      NULL,
      NULL,
      1.235162,
      NULL,
      1.488890,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.831223,
      NULL,
      3.923676,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.469230,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850886,
      0,
      NULL,
      0.922831,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.975475,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      1.743576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632399,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773444,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535140,
      0.106900,
      NULL,
      3,
      NULL,
      2,
      NULL,
      258,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      0.944687,
      2,
      1,
      NULL,
      NULL,
      0,
      3,
      2.730374,
      0.397318,
      NULL,
      1,
      NULL,
      2,
      1,
      0,
      1.453106,
      1,
      1.937777,
      NULL,
      NULL,
      0.504875,
      NULL,
      0,
      0.888280,
      NULL,
      0.309663,
      1,
      NULL,
      0.501355,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      2.663081,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.598768,
      NULL,
      1.240305,
      NULL,
      1,
      NULL,
      2,
      5,
      NULL,
      1.087849,
      NULL,
      NULL,
      74,
      NULL,
      3.567483,
      0,
      NULL,
      '22030',
      '04111',
      '42434',
      1.345697,
      '',
      '',
      '',
      1.004387,
      '3213',
      '',
      '');
commit;
end;
/


