set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015635';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '1212123',
      3,
      1,
      3,
      3,
      '3013',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-2003',
      5.757636,
      NULL,
      2,
      0,
      0.308721,
      ' 5-13-1993',
      NULL,
      1.097273,
      55.337280,
      22,
      3,
      NULL,
      ' 3- 1-1984',
      ' 0-11-1978',
      NULL,
      NULL,
      NULL,
      1.208482,
      0,
      1.209416,
      1.876457,
      1.504085,
      0,
      121.934131,
      12.065924,
      2,
      NULL,
      104,
      184.012584,
      11,
      NULL,
      1.163529,
      2,
      3,
      0,
      1.696319,
      1.807430,
      NULL,
      1.534688,
      1,
      0,
      NULL,
      1.951558,
      0.644275,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.290156,
      1.917996,
      0,
      2.817513,
      1.322221,
      0,
      1.204530,
      0.817375,
      1.202229,
      0.642381,
      1,
      0,
      10.444804,
      1,
      3.356714,
      NULL,
      1,
      0.801287,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.108628,
      0.678442,
      0.361432,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335378,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.921897,
      0,
      8,
      5.178734,
      9,
      1,
      1.633931,
      1.396784,
      NULL,
      1,
      1.444242,
      0,
      1,
      1,
      1,
      0.374366,
      0.274013,
      NULL,
      1,
      10,
      2,
      0,
      6.946739,
      0.479860,
      NULL,
      9,
      NULL,
      2.479747,
      6,
      NULL,
      5,
      6,
      8.273636,
      3.098214,
      4.863076,
      6,
      0.160894,
      NULL,
      8,
      2.316007,
      1,
      0.356024,
      10,
      1,
      7.221950,
      1.296284,
      '10- 8-1980',
      NULL,
      ' 1-22-1997',
      32,
      NULL,
      0,
      1,
      1.512431,
      0.825201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.902690,
      1.219974,
      1.693196,
      0.518824,
      NULL,
      0.940365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.343030,
      NULL,
      NULL,
      0.332782,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.485903,
      0,
      3.668764,
      3,
      1,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961975,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.935743,
      2,
      181.943244,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.486137,
      0,
      1.324488,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.117283,
      0.753095,
      0.092533,
      2.024731,
      NULL,
      2.080372,
      NULL,
      NULL,
      32,
      NULL,
      64.263943,
      197.462062,
      55,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.354848,
      11,
      1,
      1.968444,
      9.263854,
      3,
      9.132179,
      7.759722,
      5.850532,
      1,
      1,
      7,
      NULL,
      0,
      0,
      29,
      1,
      2,
      NULL,
      NULL,
      7,
      17.390486,
      NULL,
      0.440538,
      1.718426,
      '40220',
      '13341',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      11,
      68,
      13,
      0.790499,
      18.392996,
      3,
      12,
      5,
      2,
      1.277137,
      1.136815,
      1,
      NULL,
      NULL,
      0.387488,
      NULL,
      NULL,
      NULL,
      0.154821,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.180502,
      0.516245,
      1.969820,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619185,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      2,
      1,
      0.172814,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.962772,
      NULL,
      NULL,
      1.666120,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.700834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986758,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140501,
      NULL,
      NULL,
      0.799283,
      2,
      0,
      2.986851,
      0,
      1.606748,
      1.105656,
      NULL,
      NULL,
      0.117725,
      NULL,
      3.448264,
      NULL,
      0.586926,
      3.043737,
      1.973833,
      NULL,
      NULL,
      2.001037,
      0.381757,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.245143,
      NULL,
      NULL,
      0.676347,
      NULL,
      NULL,
      0.545695,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.298745,
      NULL,
      NULL,
      0.627246,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4,
      0,
      1.569310,
      0,
      NULL,
      NULL,
      2,
      1,
      1.997526,
      NULL,
      0.653785,
      1.984153,
      1.182629,
      0,
      NULL,
      0.215807,
      3,
      2,
      NULL,
      3,
      1.991170,
      3.113573,
      2,
      1.184130,
      3.518680,
      1.634190,
      3,
      1.812003,
      1.768148,
      NULL,
      1.770241,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.400074,
      NULL,
      2.915835,
      1.935869,
      NULL,
      0,
      1.481080,
      0,
      2.664170,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631647,
      NULL,
      NULL,
      0.226369,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.948210,
      NULL,
      NULL,
      1.128798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.917225,
      1.893782,
      2,
      0.389266,
      1.744084,
      2.826906,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.629826,
      NULL,
      1.869129,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.856021,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840568,
      NULL,
      NULL,
      NULL,
      1.573766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673388,
      NULL,
      0,
      NULL,
      0,
      0.022034,
      2.201413,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.004358,
      0.084908,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.261000,
      NULL,
      NULL,
      1.733348,
      11,
      NULL,
      2.876243,
      NULL,
      3.239226,
      NULL,
      NULL,
      0,
      1.889960,
      NULL,
      0.477855,
      75,
      20.792430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238324,
      73.767080,
      21,
      3.476899,
      4.896578,
      NULL,
      NULL,
      4,
      0,
      0.523926,
      0.577393,
      0.186981,
      0,
      1.998957,
      0.423153,
      0,
      1.271383,
      0.187558,
      NULL,
      0,
      NULL,
      0,
      0.680856,
      1.256003,
      0.026036,
      0.111395,
      1,
      1.919794,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      5,
      4.201319,
      3,
      5,
      2.513247,
      13.878388,
      3.423468,
      NULL,
      3.221399,
      1.108920,
      0.171555,
      1,
      0.924321,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0.736860,
      0.981873,
      NULL,
      0,
      NULL,
      0.787564,
      0.969127,
      1,
      0,
      0.915913,
      1,
      NULL,
      1,
      0,
      1,
      0.213707,
      NULL,
      1,
      0.900240,
      1,
      NULL,
      3.602351,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520745,
      NULL,
      1.863985,
      1.770618,
      NULL,
      1,
      NULL,
      7,
      10,
      1.868160,
      0.054485,
      NULL,
      26,
      61,
      NULL,
      0.900540,
      5,
      NULL,
      '43232',
      '',
      NULL,
      '',
      '',
      NULL,
      1.240520,
      '',
      NULL,
      '');
commit;
end;
/


