set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7712658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '4444123',
      3.762462,
      NULL,
      NULL,
      1,
      '2201',
      2.801561,
      1,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      0,
      NULL,
      1.612665,
      NULL,
      6,
      2,
      NULL,
      146.681812,
      1.991952,
      '11-23-1987',
      ' 3- 6-2001',
      ' 9- 5-2001',
      NULL,
      0.426876,
      1,
      1,
      NULL,
      0,
      1,
      0.286255,
      0.168729,
      6,
      6.079606,
      0,
      1,
      13.876870,
      0.615702,
      4.228745,
      8.784199,
      4.170027,
      1,
      8.429429,
      1.027653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.679368,
      3,
      0,
      1,
      2,
      1.234017,
      0,
      0.571775,
      3.611354,
      1,
      6.449534,
      5.190511,
      1.603788,
      1.156650,
      6,
      NULL,
      0,
      1,
      5.637519,
      NULL,
      1.476610,
      0.191841,
      NULL,
      NULL,
      1.114879,
      NULL,
      NULL,
      2,
      3,
      1,
      0,
      0.066325,
      NULL,
      2.740495,
      1,
      1,
      NULL,
      3,
      1.570392,
      0,
      1,
      2,
      0.265418,
      0.907321,
      1.223983,
      1.561503,
      0,
      0,
      1.032878,
      10,
      1.051538,
      5,
      0.750056,
      NULL,
      NULL,
      NULL,
      0.718587,
      NULL,
      NULL,
      0.796167,
      1.303821,
      9.535725,
      NULL,
      NULL,
      2.307763,
      5.405598,
      NULL,
      2,
      0.293992,
      NULL,
      4,
      0.235298,
      1.111368,
      1.409284,
      0,
      NULL,
      1,
      0.144158,
      NULL,
      1.475468,
      0.433648,
      4.608172,
      0.855215,
      NULL,
      0.304904,
      2.220616,
      0,
      1,
      0,
      0.361100,
      0,
      NULL,
      NULL,
      4.082200,
      0.131613,
      0.335033,
      1,
      0,
      1.766411,
      6,
      NULL,
      1.526106,
      NULL,
      5,
      0.209848,
      0.188892,
      NULL,
      ' 9-20-1982',
      NULL,
      ' 5- 7-2003',
      38,
      1,
      NULL,
      0,
      2.597540,
      2.118467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2.454175,
      1.744576,
      3.186927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      4,
      2,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.526795,
      1,
      0.577839,
      1,
      1,
      1.785882,
      0,
      122,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0.780073,
      0,
      NULL,
      0.111068,
      1.319247,
      2.737270,
      NULL,
      1,
      3.509811,
      0,
      0.263811,
      2,
      0.394044,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0.013506,
      NULL,
      1.039390,
      7.776103,
      1,
      3.980295,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.730451,
      NULL,
      42.671907,
      0,
      0,
      NULL,
      14.196716,
      7.982384,
      79,
      1.479587,
      0.036184,
      2,
      '33211',
      '01332',
      '',
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      2.774305,
      NULL,
      NULL,
      31,
      1.793678,
      20,
      3,
      1,
      3,
      0,
      0.458218,
      2,
      0.600729,
      NULL,
      NULL,
      NULL,
      1.712063,
      NULL,
      NULL,
      0,
      1.877410,
      NULL,
      0.162558,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      0.105561,
      1.419114,
      0,
      NULL,
      2.292230,
      1,
      0.721728,
      1,
      0,
      1.152391,
      1.977126,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4.273078,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.342507,
      NULL,
      NULL,
      1.329158,
      NULL,
      2,
      3.790915,
      3,
      3.292764,
      3.647979,
      0.073404,
      NULL,
      1.428292,
      0.458997,
      1,
      3,
      1.805104,
      1.747768,
      2,
      3,
      NULL,
      2.768964,
      0.585062,
      1,
      2.714834,
      0,
      0.526975,
      3,
      1,
      3.664973,
      3.808933,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.636514,
      3,
      NULL,
      0,
      NULL,
      3,
      2.458551,
      2,
      NULL,
      2.903302,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248431,
      2,
      1.335820,
      1.025299,
      3,
      0.138761,
      0,
      NULL,
      NULL,
      0,
      10,
      2.347093,
      1.641212,
      NULL,
      1,
      2,
      2.716864,
      0.630981,
      1.907804,
      NULL,
      NULL,
      0.943559,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.866309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462502,
      NULL,
      NULL,
      3.395854,
      0,
      0,
      4.392032,
      NULL,
      0,
      NULL,
      1.339822,
      2,
      NULL,
      5.620406,
      2.701459,
      NULL,
      1,
      1.112016,
      2,
      1,
      NULL,
      NULL,
      3.534718,
      1,
      6.627903,
      9.606334,
      1.245553,
      3,
      3.696313,
      NULL,
      NULL,
      NULL,
      1.765712,
      NULL,
      0,
      NULL,
      NULL,
      1.633042,
      0.293857,
      NULL,
      4,
      NULL,
      5.509110,
      2.205199,
      0.549155,
      2.945691,
      1.905913,
      NULL,
      3.872914,
      1.019531,
      2,
      0,
      2.722924,
      NULL,
      NULL,
      6.327916,
      2.083819,
      NULL,
      8,
      54.798994,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0.021556,
      NULL,
      0.700135,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      2.054645,
      1.336720,
      NULL,
      3,
      NULL,
      NULL,
      9,
      0.943221,
      NULL,
      0,
      0.163135,
      0,
      1,
      0.998910,
      0,
      3.162335,
      3.019360,
      NULL,
      7.956186,
      0.284316,
      4,
      NULL,
      2,
      239.186645,
      27,
      NULL,
      1.483827,
      1.251750,
      3,
      NULL,
      0.494856,
      1,
      1,
      NULL,
      1.801966,
      1.593312,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.491758,
      NULL,
      NULL,
      0,
      2.558757,
      NULL,
      0,
      0.642369,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.454943,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0.331579,
      NULL,
      NULL,
      1.311371,
      1.480055,
      3.226607,
      NULL,
      2.405437,
      NULL,
      0,
      NULL,
      2,
      0.261200,
      2.061671,
      NULL,
      2,
      1.514551,
      0,
      NULL,
      NULL,
      0.091590,
      NULL,
      NULL,
      0.064725,
      2.951617,
      3,
      NULL,
      NULL,
      7,
      10.282405,
      NULL,
      2,
      2,
      NULL,
      1.833288,
      1,
      3,
      85,
      NULL,
      2.183103,
      4.112299,
      NULL,
      0.119102,
      NULL,
      NULL,
      NULL,
      5.105708,
      NULL,
      2,
      13.109834,
      3.319303,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      26,
      28.088576,
      0.990233,
      0.647137,
      NULL,
      2,
      NULL,
      1.159107,
      1,
      1,
      1,
      NULL,
      1.073885,
      0,
      1,
      2.000762,
      0.105176,
      NULL,
      1,
      2.954134,
      NULL,
      2.872927,
      NULL,
      3,
      NULL,
      2,
      NULL,
      2.580203,
      NULL,
      3,
      NULL,
      12.281367,
      NULL,
      0.406065,
      33.451808,
      45.239352,
      1.827434,
      1.290964,
      NULL,
      NULL,
      0.548141,
      NULL,
      1.522286,
      NULL,
      1.270568,
      NULL,
      2,
      NULL,
      1.309184,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.485962,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.745740,
      3.631344,
      1.124729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930148,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978810,
      0.487099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308610,
      2.510252,
      NULL,
      0.162744,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.150391,
      NULL,
      1.097375,
      0.321258,
      1.183450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666057,
      1,
      NULL,
      2.720459,
      NULL,
      0.199548,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.862654,
      NULL,
      1,
      0,
      1.070497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.259196,
      2,
      2,
      NULL,
      NULL,
      5,
      3.854562,
      1.154820,
      1.294035,
      1.653771,
      1,
      0,
      1.809183,
      3.674770,
      NULL,
      1,
      0,
      3.771557,
      NULL,
      0,
      3.630988,
      0.891086,
      0,
      2.485280,
      1,
      3,
      3.807206,
      1,
      2.606265,
      2,
      0,
      0,
      1,
      1,
      1,
      0.503186,
      1.582411,
      2,
      3,
      0,
      NULL,
      1,
      0.132801,
      1,
      3,
      NULL,
      2,
      1.623937,
      1,
      NULL,
      3,
      NULL,
      3,
      0,
      1.608651,
      NULL,
      NULL,
      1.134427,
      0,
      NULL,
      1,
      NULL,
      0,
      3,
      1,
      0,
      0.870631,
      1,
      0,
      NULL,
      1,
      1.207986,
      NULL,
      41,
      3,
      NULL,
      2,
      2.236031,
      1.394361,
      NULL,
      NULL,
      NULL,
      2.614179,
      3,
      3,
      1,
      2,
      NULL,
      3.360501,
      0,
      NULL,
      2,
      3.289488,
      0.535334,
      0.130916,
      1.942158,
      2.456937,
      1,
      NULL,
      3,
      2,
      2.911628,
      3,
      NULL,
      0,
      NULL,
      0,
      2.250896,
      1.779324,
      0,
      7,
      NULL,
      6.297563,
      NULL,
      NULL,
      NULL,
      52,
      14.097266,
      0.632492,
      1,
      4.838800,
      '00214',
      NULL,
      '',
      1.065805,
      '',
      NULL,
      '',
      0.624039,
      '',
      '',
      '');
commit;
end;
/


