set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8904329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      '1311',
      3,
      NULL,
      NULL,
      NULL,
      ' 9-16-1983',
      66.905713,
      NULL,
      NULL,
      0.594287,
      NULL,
      NULL,
      40,
      1,
      130.489172,
      135,
      NULL,
      ' 7-23-2002',
      ' 1-26-1983',
      '10-13-1997',
      2,
      0.300470,
      2.351208,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.798722,
      104,
      5.708732,
      16,
      5.212774,
      10.107308,
      5,
      6,
      15,
      3,
      1,
      8.302657,
      1.334518,
      3,
      NULL,
      NULL,
      1,
      0.047662,
      0,
      1.843418,
      1,
      1.212602,
      NULL,
      3,
      3.079252,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3.224558,
      2.151502,
      5.757453,
      9.666719,
      2,
      0,
      NULL,
      1.935257,
      0.556347,
      2,
      1.582422,
      5,
      1.619042,
      1.889927,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.104739,
      1,
      1.034443,
      0,
      2,
      NULL,
      NULL,
      0.266342,
      1,
      0,
      2.676544,
      NULL,
      3.847006,
      0,
      1.838105,
      0,
      0.374214,
      1,
      1.228808,
      0.906926,
      NULL,
      NULL,
      0.590415,
      0.415149,
      2,
      0.444978,
      0,
      NULL,
      NULL,
      1.864652,
      NULL,
      NULL,
      NULL,
      5.667747,
      5.497246,
      1,
      NULL,
      1.372583,
      1,
      0.267468,
      1.884521,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0.643123,
      1.191641,
      1.808014,
      0,
      NULL,
      1.253817,
      8.063261,
      4,
      1.199574,
      4,
      NULL,
      NULL,
      8,
      NULL,
      4,
      1,
      1.679230,
      9.696780,
      6,
      4.397402,
      8.815434,
      8,
      9,
      10.459906,
      1.654620,
      6,
      NULL,
      3.443178,
      1.896570,
      5,
      9.699488,
      6,
      0.929080,
      ' 4-20-1981',
      849,
      NULL,
      847,
      NULL,
      NULL,
      1.198114,
      6.628125,
      0.824226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.743825,
      0.675754,
      NULL,
      1,
      1.691988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.683699,
      NULL,
      2,
      2.078128,
      0.898872,
      1,
      0.403228,
      0.491339,
      NULL,
      4.903214,
      NULL,
      5,
      0.816958,
      NULL,
      NULL,
      NULL,
      1,
      1.699315,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      0,
      1,
      1.375663,
      1,
      14.378475,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.293106,
      NULL,
      1,
      2,
      3.991347,
      1.686797,
      3,
      1,
      2,
      NULL,
      0,
      3,
      1,
      NULL,
      1.274272,
      NULL,
      3.864985,
      NULL,
      0.191792,
      3,
      0.288278,
      0.137774,
      NULL,
      1.080208,
      1.850776,
      0.245151,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.899276,
      4,
      0,
      NULL,
      0.258434,
      4.995180,
      NULL,
      2.966074,
      3,
      3,
      3,
      NULL,
      1.002726,
      NULL,
      NULL,
      40,
      26,
      7,
      0.795880,
      0,
      3,
      '22322',
      '11113',
      '',
      0,
      '',
      '',
      '',
      0.099977,
      '',
      '',
      '',
      NULL,
      10.090468,
      43,
      17.746337,
      0,
      14,
      14,
      NULL,
      0.386207,
      2.663416,
      NULL,
      NULL,
      0.991829,
      NULL,
      NULL,
      2.203986,
      NULL,
      2.033786,
      0.926299,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.499064,
      3.329361,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043206,
      NULL,
      NULL,
      1.735860,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.484519,
      NULL,
      5.427481,
      1.819789,
      0.718294,
      NULL,
      NULL,
      NULL,
      1.718985,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.063961,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.694904,
      2.813511,
      0,
      1,
      1,
      1,
      2,
      0.596035,
      NULL,
      3.182269,
      NULL,
      1.144106,
      1.617220,
      2,
      0.622318,
      1,
      0.478083,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.709538,
      0.831676,
      6.007966,
      3.173413,
      5.128364,
      NULL,
      1.800494,
      NULL,
      NULL,
      NULL,
      0.607044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.384070,
      0,
      0.635745,
      3.794304,
      0.095915,
      NULL,
      NULL,
      6.979977,
      5.608887,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.258344,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174234,
      NULL,
      NULL,
      1.571076,
      NULL,
      NULL,
      3.253316,
      0.213089,
      2,
      NULL,
      2.125869,
      3,
      NULL,
      3.838605,
      NULL,
      4.694307,
      8.586795,
      7,
      3,
      NULL,
      4.926977,
      0.310055,
      0.453044,
      0.105185,
      3,
      0.467995,
      2.535038,
      3.973047,
      0.707099,
      NULL,
      9.652589,
      0.061950,
      0,
      NULL,
      0,
      2.243821,
      NULL,
      1,
      0.684373,
      2.037171,
      2,
      2,
      1.112640,
      3,
      1.956073,
      5,
      5,
      0,
      4,
      3,
      1,
      1.906910,
      0.906693,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255202,
      NULL,
      NULL,
      0.807875,
      NULL,
      NULL,
      0.747431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.414960,
      1,
      0.884117,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600167,
      NULL,
      NULL,
      NULL,
      0.629452,
      NULL,
      NULL,
      NULL,
      2.159449,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.039310,
      NULL,
      NULL,
      NULL,
      0.958776,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.695791,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.643268,
      NULL,
      NULL,
      NULL,
      3.047212,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0.860637,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.737100,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      NULL,
      3,
      NULL,
      3.059305,
      1.317705,
      2.722897,
      0,
      NULL,
      0,
      0,
      1.471353,
      0,
      1.518364,
      3.273361,
      NULL,
      NULL,
      NULL,
      3,
      1.133036,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.491554,
      NULL,
      15,
      NULL,
      2,
      NULL,
      24.716990,
      NULL,
      NULL,
      0,
      2,
      1.906292,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.110113,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.796561,
      NULL,
      NULL,
      NULL,
      0.911035,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.752086,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.697503,
      NULL,
      1,
      4,
      13.645808,
      3,
      3,
      NULL,
      1.527568,
      1.162778,
      NULL,
      1.654507,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.358679,
      0,
      NULL,
      0,
      1.254785,
      NULL,
      0,
      0.080887,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      0,
      1.799635,
      NULL,
      0.196451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.189044,
      1.342298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.945037,
      NULL,
      0.942389,
      8,
      1.771869,
      NULL,
      1.625830,
      1.832852,
      56.753794,
      62,
      5,
      0.029818,
      3,
      '02130',
      '03244',
      '',
      1.865522,
      '',
      '',
      '',
      0.966408,
      NULL,
      NULL,
      '');
commit;
end;
/


