set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8904329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '3334020',
      4,
      0.036168,
      3,
      NULL,
      '4102',
      2,
      2,
      0,
      17,
      ' 5- 4-1992',
      107.961840,
      NULL,
      0,
      3,
      NULL,
      NULL,
      36,
      2,
      290.245358,
      94,
      4.433090,
      NULL,
      NULL,
      NULL,
      1.283677,
      0,
      NULL,
      1.883474,
      NULL,
      3.178556,
      1,
      1,
      1.412802,
      272,
      8.376116,
      NULL,
      1.754791,
      NULL,
      8,
      3.775825,
      19.405836,
      5.893985,
      NULL,
      5,
      0,
      1.366543,
      1.658119,
      NULL,
      0.872813,
      1.268895,
      NULL,
      1.393379,
      NULL,
      1,
      1,
      NULL,
      3.017757,
      NULL,
      1,
      NULL,
      1,
      0.438504,
      3.641958,
      0,
      0.674229,
      NULL,
      0,
      2.588151,
      6.091868,
      0,
      1.120128,
      5,
      0.180663,
      3.981983,
      0.013020,
      2.833252,
      NULL,
      NULL,
      NULL,
      1.792906,
      NULL,
      NULL,
      3,
      3,
      1,
      0,
      0.415001,
      1,
      3.510237,
      1.715681,
      3,
      0.046800,
      1.367792,
      NULL,
      0.139788,
      NULL,
      0,
      0.180958,
      2.925054,
      0.995091,
      1,
      0,
      1.868678,
      NULL,
      2,
      1.144558,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.597741,
      NULL,
      5,
      5.259026,
      NULL,
      1,
      3.925670,
      NULL,
      NULL,
      1.088909,
      0.740924,
      NULL,
      1,
      1.759038,
      0,
      NULL,
      NULL,
      NULL,
      0.739427,
      NULL,
      NULL,
      2,
      1,
      4,
      3,
      4,
      4.164734,
      5.565338,
      0.955163,
      NULL,
      3.012195,
      NULL,
      6.313526,
      NULL,
      1,
      3,
      0,
      3.744186,
      2.954987,
      6.640245,
      2.499137,
      2,
      2,
      5.654417,
      0,
      ' 6- 3-1988',
      NULL,
      ' 7-10-2000',
      25,
      2.171269,
      0.163583,
      1,
      0,
      0.498458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.346869,
      0.814621,
      0.834151,
      0,
      2.098242,
      2,
      0.693849,
      3.722909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002386,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.418928,
      0.482841,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.884969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1.799491,
      1,
      NULL,
      NULL,
      1.311016,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.188318,
      1,
      0.986986,
      NULL,
      0,
      0.872319,
      NULL,
      1,
      NULL,
      2,
      0.602101,
      NULL,
      3,
      3.693920,
      1.849388,
      5.058893,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1.631167,
      NULL,
      1.672249,
      1.662157,
      NULL,
      1,
      0.573825,
      0,
      0.018900,
      NULL,
      0,
      7.688395,
      NULL,
      11,
      0,
      0.226243,
      NULL,
      0,
      NULL,
      1.775311,
      0,
      4,
      2.399236,
      NULL,
      9.117140,
      NULL,
      NULL,
      NULL,
      4.169955,
      1,
      0,
      '13322',
      NULL,
      '',
      1.162441,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0,
      21,
      270,
      8,
      2,
      NULL,
      NULL,
      10,
      0.890641,
      2.236129,
      3.547171,
      3.771737,
      3,
      1.849450,
      NULL,
      1,
      0.543189,
      NULL,
      1.191449,
      1.070313,
      0.309078,
      3.814978,
      1.065435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.120651,
      1,
      3.375741,
      NULL,
      3.250006,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      2.287980,
      0.384997,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.953679,
      1.291572,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.119601,
      2.630535,
      2,
      1.967503,
      3.465159,
      1.311476,
      NULL,
      2,
      0,
      0.609249,
      NULL,
      3.236835,
      NULL,
      1.203277,
      NULL,
      NULL,
      NULL,
      3,
      0.114656,
      NULL,
      NULL,
      0,
      1.285310,
      1.792636,
      10,
      1.088313,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.478724,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.123574,
      0.215372,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      0.419936,
      0.133910,
      1,
      0,
      3,
      0.893533,
      NULL,
      NULL,
      6,
      4,
      5,
      0.972571,
      NULL,
      NULL,
      0.579675,
      NULL,
      NULL,
      0.940002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026776,
      NULL,
      NULL,
      1.702110,
      NULL,
      NULL,
      0.665948,
      NULL,
      NULL,
      3,
      1.964067,
      0.847194,
      1,
      1,
      1.020901,
      1,
      5.474806,
      3.031911,
      7.155033,
      1,
      NULL,
      3,
      2.087573,
      0.536316,
      2.891604,
      3.688089,
      0,
      0,
      0,
      1,
      3,
      4.814581,
      1,
      0,
      3,
      NULL,
      2.690167,
      0.103343,
      1.753081,
      NULL,
      1,
      1,
      1.722179,
      0,
      3,
      3,
      2,
      NULL,
      4.049432,
      3,
      0,
      3.801081,
      NULL,
      6.220187,
      1,
      1.759274,
      0.524945,
      1.293997,
      0,
      3.771138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845426,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751851,
      NULL,
      NULL,
      0.116867,
      NULL,
      NULL,
      1.500813,
      NULL,
      NULL,
      0.170579,
      1,
      2,
      NULL,
      1,
      3.983597,
      1.192427,
      NULL,
      NULL,
      2.525665,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.413326,
      NULL,
      NULL,
      NULL,
      0,
      0.148328,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.306216,
      NULL,
      NULL,
      NULL,
      1.100519,
      0.767701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.579104,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.880093,
      0.777681,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.441300,
      1.635201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.443206,
      0.361218,
      NULL,
      1.470922,
      160,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736293,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.999284,
      NULL,
      NULL,
      1.696557,
      NULL,
      0.666166,
      NULL,
      10,
      1.415128,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0.915139,
      0,
      1.253824,
      0.777548,
      1.451457,
      NULL,
      1.004725,
      1,
      0.510249,
      1.622135,
      1.309068,
      NULL,
      NULL,
      2.689729,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.809340,
      NULL,
      191.107556,
      NULL,
      6.073653,
      NULL,
      NULL,
      NULL,
      2.156948,
      3.246387,
      NULL,
      1.383483,
      NULL,
      0.779479,
      NULL,
      3.979112,
      NULL,
      2,
      NULL,
      2.412848,
      NULL,
      3.944033,
      NULL,
      1.463915,
      NULL,
      0,
      NULL,
      0.254687,
      NULL,
      0.136095,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.111034,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.996843,
      NULL,
      1,
      NULL,
      0.690007,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0.622646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833991,
      1.751571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.776242,
      NULL,
      0.232683,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.122507,
      0.618694,
      1,
      32.103651,
      9.644606,
      0.123991,
      NULL,
      NULL,
      NULL,
      3.402684,
      2,
      NULL,
      3,
      3.171006,
      NULL,
      5.729235,
      3.225646,
      NULL,
      1.875234,
      0.694258,
      2,
      1.666344,
      NULL,
      NULL,
      NULL,
      2.879243,
      NULL,
      3,
      3.208143,
      2.019156,
      1.408936,
      0,
      0,
      0.481778,
      0,
      NULL,
      1,
      0.869193,
      2.226990,
      3,
      3.590988,
      3.743663,
      2.446466,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      2.243888,
      3,
      1.773434,
      1.513949,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687100,
      1.210502,
      NULL,
      0,
      0.874380,
      0.675723,
      NULL,
      4.591020,
      4,
      2,
      1,
      3.176811,
      47,
      32.292755,
      NULL,
      1.913349,
      3.822276,
      '10410',
      '30410',
      '03342',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '304',
      '304');
commit;
end;
/


