set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      '1100',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 8-1996',
      NULL,
      NULL,
      1,
      3.623373,
      4,
      '10-11-2001',
      1.926991,
      3.274169,
      316.778912,
      37.454463,
      2.825126,
      NULL,
      NULL,
      ' 6- 7-1977',
      3,
      0,
      NULL,
      1,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      8,
      3.543910,
      26,
      5,
      5.891987,
      NULL,
      1,
      0.014653,
      7.033440,
      1.329485,
      0,
      0,
      1.092850,
      1,
      0.072974,
      1.022068,
      NULL,
      1.560079,
      1.978640,
      NULL,
      NULL,
      0,
      NULL,
      1.998474,
      NULL,
      0,
      0.224593,
      1,
      NULL,
      NULL,
      1.163940,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.888122,
      0.023190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625426,
      0,
      0.893908,
      1.683398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989869,
      0,
      0.748774,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      4,
      NULL,
      1,
      0.526200,
      1.833627,
      0,
      NULL,
      NULL,
      1.056632,
      NULL,
      1.670488,
      1.530377,
      0,
      1,
      1,
      1,
      2,
      NULL,
      0,
      0.904998,
      0.568110,
      1.819803,
      1,
      2.085105,
      3,
      1.675340,
      NULL,
      1,
      0,
      1,
      1.113142,
      NULL,
      4.251223,
      1,
      1.157228,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422535,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.351165,
      0.627464,
      0,
      NULL,
      2.216147,
      0.338598,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.886454,
      NULL,
      1495.781115,
      1.113712,
      1,
      NULL,
      0,
      NULL,
      0,
      1.060419,
      0,
      NULL,
      0.836032,
      0.081832,
      3.418358,
      0.878869,
      1.122974,
      1,
      1.475545,
      NULL,
      1.356095,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.356527,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.428290,
      1,
      0,
      1.356808,
      1.328098,
      0.291532,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.379043,
      NULL,
      NULL,
      4,
      2,
      3,
      3.447572,
      4,
      3.897931,
      5,
      3,
      0.279474,
      5.796515,
      1,
      1,
      4,
      1.469349,
      1,
      1,
      1.138827,
      1.689327,
      0,
      NULL,
      NULL,
      1,
      0.218735,
      0,
      NULL,
      9,
      10.122312,
      2.841230,
      10,
      9,
      7,
      2,
      NULL,
      5.129372,
      3,
      0.101441,
      1.346117,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816503,
      1,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.487564,
      '',
      '',
      '',
      NULL,
      6.992663,
      182.377036,
      8,
      1,
      NULL,
      NULL,
      1,
      1.611192,
      2,
      3,
      1.819299,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.959889,
      0.918308,
      NULL,
      NULL,
      NULL,
      1.460859,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.612251,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      9,
      0.335887,
      0.856803,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.377558,
      NULL,
      0.462023,
      1.958368,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      1.074724,
      1,
      0,
      2,
      0.713246,
      3.594154,
      2.276861,
      1,
      0.039007,
      NULL,
      1.788256,
      0.696686,
      1.679311,
      0.781348,
      0.517673,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.099181,
      NULL,
      1.469322,
      1,
      0.002244,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.570178,
      3.431447,
      2.425963,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      3,
      0.062069,
      NULL,
      NULL,
      NULL,
      5.996473,
      NULL,
      1,
      3.128512,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205785,
      NULL,
      NULL,
      0.273084,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.473140,
      1.490298,
      1.187154,
      3,
      1,
      0,
      NULL,
      7.023847,
      NULL,
      11.718405,
      6.985647,
      3,
      4.795449,
      2,
      NULL,
      NULL,
      1.897964,
      0.140933,
      2.660328,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1,
      NULL,
      1,
      1.495919,
      1,
      1.857590,
      0.678373,
      2.221803,
      NULL,
      NULL,
      1.293328,
      NULL,
      3.642442,
      1,
      NULL,
      2,
      7,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      1.509990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.952320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.243060,
      NULL,
      NULL,
      0,
      1,
      1.622625,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2.358834,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.971568,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.919424,
      1.429114,
      NULL,
      NULL,
      2.877332,
      1,
      NULL,
      NULL,
      2.305926,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.283949,
      0.785879,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.770667,
      201,
      80,
      1,
      1013.065851,
      991.063210,
      NULL,
      NULL,
      NULL,
      0.891460,
      NULL,
      NULL,
      1.794277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.205054,
      1,
      1.645196,
      0.428993,
      0,
      0.447467,
      NULL,
      0.418587,
      NULL,
      0.571039,
      1.478846,
      0.458403,
      0.630583,
      NULL,
      1.756558,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.528721,
      3,
      9.730225,
      0,
      2,
      0,
      4,
      15,
      NULL,
      NULL,
      3.633011,
      14,
      2.772100,
      1.070677,
      11,
      10.392556,
      2.494229,
      3,
      12.848339,
      2.887539,
      11,
      16,
      1.359864,
      18.031123,
      15,
      1.273123,
      NULL,
      NULL,
      0.673752,
      16,
      7,
      1.219179,
      6,
      NULL,
      1.156455,
      7.846694,
      4,
      0,
      NULL,
      12.222046,
      0,
      8,
      5,
      1.585947,
      0.096831,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.503229,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1.800056,
      1.329421,
      0.762438,
      1,
      92.485314,
      NULL,
      7,
      1.838755,
      NULL,
      '12223',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.764336,
      '',
      '',
      NULL);
commit;
end;
/


