set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '3423010',
      NULL,
      0,
      2,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      ' 9-24-1986',
      NULL,
      NULL,
      5,
      0,
      NULL,
      ' 6-15-1998',
      4.836033,
      2,
      182,
      84,
      1.715922,
      NULL,
      NULL,
      ' 6-13-1994',
      0,
      0.366461,
      2,
      0.528205,
      0,
      0.578089,
      3.485134,
      3.539887,
      NULL,
      NULL,
      NULL,
      2.845794,
      6.758684,
      167.330497,
      NULL,
      1.011725,
      19.084368,
      5,
      0.785048,
      9.347395,
      0,
      0.271588,
      1,
      1.290672,
      NULL,
      0.115227,
      0.764885,
      1,
      1.793261,
      1,
      1,
      1.897474,
      5.950787,
      2,
      2.787631,
      NULL,
      0,
      1.011078,
      NULL,
      1.266665,
      NULL,
      6.861991,
      NULL,
      0,
      1.516815,
      0,
      0,
      5.184936,
      0.270384,
      5,
      0,
      0.108500,
      1.638376,
      NULL,
      NULL,
      1.310509,
      NULL,
      NULL,
      NULL,
      2,
      1.152076,
      1.741365,
      0.431686,
      1.042342,
      NULL,
      0,
      1,
      1.608905,
      1,
      0.645067,
      0.085559,
      1.815096,
      1,
      0.664800,
      2,
      1.248320,
      NULL,
      NULL,
      1.186826,
      1,
      NULL,
      0.907380,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912016,
      NULL,
      NULL,
      2.276379,
      3,
      2,
      0,
      NULL,
      0.028860,
      3.874862,
      1,
      1.163684,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.476785,
      1,
      0.631680,
      0.796490,
      1,
      NULL,
      0,
      2.945956,
      NULL,
      1,
      1,
      4,
      NULL,
      7.043659,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.088051,
      NULL,
      0,
      3.376189,
      6,
      5.848223,
      4,
      4,
      11,
      0.130434,
      NULL,
      3.291039,
      NULL,
      NULL,
      0,
      ' 2- 6-1998',
      322,
      ' 5-27-1991',
      1.019430,
      2.559487,
      NULL,
      0,
      5,
      0.884575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.718249,
      0,
      0.995488,
      1,
      3,
      0,
      0.153753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832378,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.276832,
      1.882359,
      1,
      0,
      2,
      2.955799,
      1,
      NULL,
      3,
      3,
      1.740156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337941,
      3.829501,
      0.909974,
      1.599800,
      1,
      0.688890,
      0,
      NULL,
      NULL,
      0,
      1.481035,
      NULL,
      NULL,
      NULL,
      3.249943,
      1,
      1.831425,
      1,
      4.385350,
      1.745736,
      3.352777,
      0.961752,
      NULL,
      4.043198,
      5.545450,
      2.172970,
      5,
      2.726366,
      1,
      NULL,
      3.888526,
      1,
      1.825705,
      2.433224,
      0.618835,
      0.305821,
      NULL,
      0.555320,
      NULL,
      0.955350,
      NULL,
      NULL,
      NULL,
      0.402116,
      NULL,
      0.449360,
      5,
      7,
      3,
      NULL,
      11,
      5.796075,
      2,
      1,
      3.418502,
      0.045163,
      0.169758,
      NULL,
      29.355556,
      2.227701,
      1.865635,
      28,
      NULL,
      NULL,
      NULL,
      2,
      0.100374,
      2,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      8.064374,
      159,
      4.753120,
      NULL,
      5.797914,
      4.341676,
      NULL,
      0,
      1,
      1,
      NULL,
      0.105773,
      NULL,
      NULL,
      1.393828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.560444,
      2.108175,
      1.702583,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.300800,
      5.325067,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.113884,
      NULL,
      NULL,
      NULL,
      1.416974,
      2,
      0.973002,
      0,
      NULL,
      NULL,
      3,
      2.666623,
      NULL,
      1,
      1,
      1.522055,
      2.666634,
      NULL,
      2.551616,
      1,
      0,
      NULL,
      1.175967,
      0,
      1,
      NULL,
      NULL,
      1.734595,
      0,
      0.682801,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.483646,
      5.743409,
      1,
      1.650381,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.012532,
      1,
      NULL,
      NULL,
      1.687774,
      NULL,
      NULL,
      4,
      2.188010,
      4.115509,
      2.689302,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.878645,
      NULL,
      0.361416,
      3,
      0.512302,
      1.442050,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.104033,
      0,
      1.956386,
      NULL,
      0.978352,
      NULL,
      2,
      0,
      3.771602,
      3,
      0,
      5.142197,
      2.584129,
      2.710952,
      0,
      2.934891,
      NULL,
      1,
      3,
      0,
      1,
      1,
      NULL,
      1.005819,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.888017,
      3.134256,
      1.462917,
      NULL,
      3,
      NULL,
      3.189578,
      1,
      0,
      0,
      3.792020,
      2.265240,
      NULL,
      8.546570,
      2.616206,
      NULL,
      5,
      0.936657,
      2,
      2.794940,
      3.522256,
      1,
      1.495635,
      0,
      1.599647,
      0.626823,
      1.111182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868049,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.675257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621647,
      0.304471,
      0.860140,
      1.535948,
      1.310751,
      1.275803,
      2.776036,
      NULL,
      NULL,
      3,
      1.606926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.254646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      2.963660,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.853058,
      NULL,
      NULL,
      NULL,
      0.946392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.488214,
      NULL,
      NULL,
      0.433547,
      1.790760,
      NULL,
      NULL,
      NULL,
      1.925816,
      NULL,
      NULL,
      0,
      0.308926,
      NULL,
      NULL,
      1.179701,
      1,
      NULL,
      NULL,
      1.916448,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.355420,
      8.749244,
      82.715677,
      0.602120,
      NULL,
      1244.355629,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8876,
      1722,
      0,
      1,
      0,
      1.703674,
      1.497653,
      1.103177,
      0.884787,
      0.010524,
      0,
      0,
      0,
      0.163561,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.055439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.604093,
      NULL,
      NULL,
      9.153778,
      NULL,
      2.678300,
      NULL,
      4.635495,
      1.732627,
      2.206504,
      0,
      1.766392,
      13.730365,
      12.361581,
      1,
      17.974994,
      6,
      0.745576,
      12.851984,
      2.063772,
      0.917007,
      6,
      NULL,
      1,
      NULL,
      7.965257,
      1,
      5,
      3.008497,
      0.391462,
      3,
      18.364150,
      0,
      NULL,
      2,
      NULL,
      19,
      9.424357,
      1.423432,
      13,
      5,
      2,
      18,
      7,
      0.866344,
      NULL,
      2.708504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.016135,
      1,
      0.838161,
      1,
      0.760025,
      5.260699,
      2.763912,
      11,
      2.107936,
      1,
      2.895948,
      0,
      7,
      2.643997,
      1,
      NULL,
      '30032',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


